/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.io.IOException;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.kernel.impl.util.Validators;
import org.neo4j.test.TargetDirectory;

public class ValidatorsTest {
    @Rule
    public final TargetDirectory.TestDirectory directory = TargetDirectory.testDirForTest(this.getClass());

    @Test
    public void shouldFindFilesByRegex() throws Exception {
        this.existenceOfFile("abc");
        this.existenceOfFile("bcd");
        this.assertValid("abc");
        this.assertValid("bcd");
        this.assertValid("ab.");
        this.assertValid(".*bc");
        this.assertNotValid("abcd");
        this.assertNotValid(".*de.*");
    }

    private void assertNotValid(String string) {
        try {
            this.validate(string);
            Assert.fail((String)"Should have failed");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void assertValid(String fileByName) {
        this.validate(fileByName);
    }

    private void validate(String fileByName) {
        Validators.REGEX_FILE_EXISTS.validate((Object)this.directory.file(fileByName));
    }

    private void existenceOfFile(String name) throws IOException {
        this.directory.file(name).createNewFile();
    }
}

