/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test;

import java.io.File;
import java.util.Map;
import org.neo4j.graphdb.mockfs.LimitedFilesystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.factory.CommunityFacadeFactory;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacadeFactory;
import org.neo4j.kernel.impl.factory.PlatformModule;
import org.neo4j.test.ImpermanentGraphDatabase;

public class LimitedFileSystemGraphDatabase
extends ImpermanentGraphDatabase {
    private LimitedFilesystemAbstraction fs;

    public LimitedFileSystemGraphDatabase(String storeDir) {
        super(new File(storeDir));
    }

    @Override
    protected void create(File storeDir, Map<String, String> params, GraphDatabaseFacadeFactory.Dependencies dependencies) {
        new CommunityFacadeFactory(){

            protected PlatformModule createPlatform(File storeDir, Map<String, String> params, GraphDatabaseFacadeFactory.Dependencies dependencies, GraphDatabaseFacade graphDatabaseFacade) {
                return new ImpermanentGraphDatabase.ImpermanentPlatformModule(storeDir, params, dependencies, graphDatabaseFacade){

                    @Override
                    protected FileSystemAbstraction createFileSystemAbstraction() {
                        return LimitedFileSystemGraphDatabase.this.fs = new LimitedFilesystemAbstraction(super.createFileSystemAbstraction());
                    }
                };
            }
        }.newFacade(storeDir, params, dependencies, (GraphDatabaseFacade)this);
    }

    public void runOutOfDiskSpaceNao() {
        this.fs.runOutOfDiskSpace(true);
    }

    public void somehowGainMoreDiskSpace() {
        this.fs.runOutOfDiskSpace(false);
    }

    public LimitedFilesystemAbstraction getFileSystem() {
        return this.fs;
    }
}

