/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import java.util.Arrays;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.UpdateRecordsStep;
import org.neo4j.unsafe.impl.batchimport.staging.BatchSender;
import org.neo4j.unsafe.impl.batchimport.staging.StageControl;
import org.neo4j.unsafe.impl.batchimport.stats.Key;
import org.neo4j.unsafe.impl.batchimport.stats.Keys;
import org.neo4j.unsafe.impl.batchimport.stats.Stat;

public class UpdateRecordsStepTest {
    @Test
    public void ioThroughputStatDoesNotOverflow() throws Throwable {
        RecordStore store = (RecordStore)Mockito.mock(RecordStore.class);
        Mockito.when((Object)store.getRecordSize()).thenReturn((Object)0x3FFFFFFF);
        Configuration configuration = (Configuration)Mockito.mock(Configuration.class);
        StageControl stageControl = (StageControl)Mockito.mock(StageControl.class);
        UpdateRecordsStep step = new UpdateRecordsStep(stageControl, configuration, store);
        NodeRecord record = new NodeRecord(1L);
        record.setInUse(true);
        Object[] batch = new NodeRecord[11];
        Arrays.fill(batch, record);
        step.process((AbstractBaseRecord[])batch, (BatchSender)Mockito.mock(BatchSender.class));
        Stat stat = step.stat((Key)Keys.io_throughput);
        Assert.assertThat((Object)stat.asLong(), (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(0L)));
    }
}

