/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.store;

import org.neo4j.function.Consumer;
import org.neo4j.kernel.impl.api.store.StoreAbstractNodeCursor;
import org.neo4j.kernel.impl.api.store.StoreStatement;
import org.neo4j.kernel.impl.locking.LockService;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.record.NodeRecord;

public class StoreSingleNodeCursor
extends StoreAbstractNodeCursor {
    private long nodeId;
    private final Consumer<StoreSingleNodeCursor> instanceCache;

    public StoreSingleNodeCursor(NodeRecord nodeRecord, NeoStores neoStores, StoreStatement storeStatement, Consumer<StoreSingleNodeCursor> instanceCache, LockService lockService) {
        super(nodeRecord, neoStores, storeStatement, lockService);
        this.instanceCache = instanceCache;
    }

    public StoreSingleNodeCursor init(long nodeId) {
        this.nodeId = nodeId;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean next() {
        if (this.nodeId != -1L) {
            try {
                this.nodeRecord.setId(this.nodeId);
                NodeRecord record = this.nodeStore.loadRecord(this.nodeId, this.nodeRecord);
                boolean bl = record != null && record.inUse();
                return bl;
            }
            finally {
                this.nodeId = -1L;
            }
        }
        return false;
    }

    public void close() {
        this.instanceCache.accept((Object)this);
    }
}

