/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.neo4j.collection.primitive.PrimitiveLongObjectMap;
import org.neo4j.helpers.Pair;
import org.neo4j.helpers.UTF8;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.IdType;
import org.neo4j.kernel.api.index.NodePropertyUpdate;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.index.PropertyPhysicalToLogicalConverter;
import org.neo4j.kernel.impl.api.store.PropertyRecordCursor;
import org.neo4j.kernel.impl.store.AbstractDynamicStore;
import org.neo4j.kernel.impl.store.AbstractRecordStore;
import org.neo4j.kernel.impl.store.CommonAbstractStore;
import org.neo4j.kernel.impl.store.DynamicArrayStore;
import org.neo4j.kernel.impl.store.DynamicRecordAllocator;
import org.neo4j.kernel.impl.store.DynamicStringStore;
import org.neo4j.kernel.impl.store.InvalidRecordException;
import org.neo4j.kernel.impl.store.LongerShortString;
import org.neo4j.kernel.impl.store.PropertyKeyTokenStore;
import org.neo4j.kernel.impl.store.PropertyType;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.ShortArray;
import org.neo4j.kernel.impl.store.UnderlyingStorageException;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.transaction.state.PropertyRecordChange;
import org.neo4j.logging.LogProvider;

public class PropertyStore
extends AbstractRecordStore<PropertyRecord> {
    public static final int DEFAULT_DATA_BLOCK_SIZE = 120;
    public static final int DEFAULT_PAYLOAD_SIZE = 32;
    public static final String TYPE_DESCRIPTOR = "PropertyStore";
    public static final int RECORD_SIZE = 41;
    private final DynamicStringStore stringPropertyStore;
    private final PropertyKeyTokenStore propertyKeyTokenStore;
    private final DynamicArrayStore arrayPropertyStore;
    private final PropertyPhysicalToLogicalConverter physicalToLogicalConverter;

    public PropertyStore(File fileName, Config configuration, IdGeneratorFactory idGeneratorFactory, PageCache pageCache, LogProvider logProvider, DynamicStringStore stringPropertyStore, PropertyKeyTokenStore propertyKeyTokenStore, DynamicArrayStore arrayPropertyStore) {
        super(fileName, configuration, IdType.PROPERTY, idGeneratorFactory, pageCache, logProvider);
        this.stringPropertyStore = stringPropertyStore;
        this.propertyKeyTokenStore = propertyKeyTokenStore;
        this.arrayPropertyStore = arrayPropertyStore;
        this.physicalToLogicalConverter = new PropertyPhysicalToLogicalConverter(this);
    }

    @Override
    public <FAILURE extends Exception> void accept(RecordStore.Processor<FAILURE> processor, PropertyRecord record) throws FAILURE {
        processor.processProperty(this, record);
    }

    public DynamicStringStore getStringStore() {
        return this.stringPropertyStore;
    }

    public DynamicArrayStore getArrayStore() {
        return this.arrayPropertyStore;
    }

    @Override
    public String getTypeDescriptor() {
        return TYPE_DESCRIPTOR;
    }

    @Override
    public int getRecordSize() {
        return 41;
    }

    @Override
    public int getRecordHeaderSize() {
        return 9;
    }

    public PropertyKeyTokenStore getPropertyKeyTokenStore() {
        return this.propertyKeyTokenStore;
    }

    @Override
    public void updateRecord(PropertyRecord record) {
        block16: {
            long pageId = this.pageIdForRecord(record.getId());
            this.updatePropertyBlocks(record);
            try (PageCursor cursor = this.storeFile.io(pageId, 2);){
                if (cursor.next()) {
                    do {
                        this.updateRecord(record, cursor);
                    } while (cursor.shouldRetry());
                    break block16;
                }
                throw new UnderlyingStorageException("Could not pin page[" + pageId + " exclusively for updateRecord: " + record);
            }
            catch (IOException e) {
                throw new UnderlyingStorageException(e);
            }
        }
    }

    @Override
    public void forceUpdateRecord(PropertyRecord record) {
        this.updateRecord(record);
    }

    private void updateRecord(PropertyRecord record, PageCursor cursor) {
        long id = record.getId();
        cursor.setOffset((int)(id * 41L % (long)this.storeFile.pageSize()));
        if (record.inUse()) {
            short prevModifier = record.getPrevProp() == (long)Record.NO_NEXT_RELATIONSHIP.intValue() ? (short)0 : (short)((record.getPrevProp() & 0xF00000000L) >> 28);
            short nextModifier = record.getNextProp() == (long)Record.NO_NEXT_RELATIONSHIP.intValue() ? (short)0 : (short)((record.getNextProp() & 0xF00000000L) >> 32);
            byte modifiers = (byte)(prevModifier | nextModifier);
            cursor.putByte(modifiers);
            cursor.putInt((int)record.getPrevProp());
            cursor.putInt((int)record.getNextProp());
            int longsAppended = 0;
            for (PropertyBlock block : record) {
                long[] propBlockValues;
                for (long propBlockValue : propBlockValues = block.getValueBlocks()) {
                    cursor.putLong(propBlockValue);
                }
                longsAppended += propBlockValues.length;
            }
            if (longsAppended < PropertyType.getPayloadSizeLongs()) {
                cursor.putLong(0L);
            }
        } else {
            this.freeId(id);
            cursor.setOffset(cursor.getOffset() + 9);
            cursor.putLong(0L);
        }
    }

    private void updatePropertyBlocks(PropertyRecord record) {
        if (record.inUse()) {
            for (PropertyBlock block : record) {
                if (block.isLight() || !block.getValueRecords().get(0).isCreated()) continue;
                this.updateDynamicRecords(block.getValueRecords());
            }
        }
        this.updateDynamicRecords(record.getDeletedRecords());
    }

    private void updateDynamicRecords(List<DynamicRecord> records) {
        for (DynamicRecord valueRecord : records) {
            if (valueRecord.getType() == PropertyType.STRING.intValue()) {
                this.stringPropertyStore.updateRecord(valueRecord);
                continue;
            }
            if (valueRecord.getType() == PropertyType.ARRAY.intValue()) {
                this.arrayPropertyStore.updateRecord(valueRecord);
                continue;
            }
            throw new InvalidRecordException("Unknown dynamic record" + valueRecord);
        }
    }

    public PropertyRecord getLightRecord(long id) {
        return this.getRecord(id);
    }

    public void ensureHeavy(PropertyBlock block) {
        if (block.getType() == PropertyType.STRING) {
            PropertyStore.loadPropertyBlock(block, this.stringPropertyStore);
        } else if (block.getType() == PropertyType.ARRAY) {
            PropertyStore.loadPropertyBlock(block, this.arrayPropertyStore);
        }
    }

    private static void loadPropertyBlock(PropertyBlock block, AbstractDynamicStore dynamicStore) {
        if (block.isLight()) {
            long startBlockId = block.getSingleValueLong();
            try (AbstractDynamicStore.DynamicRecordCursor cursor = dynamicStore.getRecordsCursor(startBlockId);){
                while (cursor.next()) {
                    ((DynamicRecord)cursor.get()).setType(block.getType().intValue());
                    block.addValueRecord(((DynamicRecord)cursor.get()).clone());
                }
            }
        } else {
            for (DynamicRecord dynamicRecord : block.getValueRecords()) {
                dynamicStore.ensureHeavy(dynamicRecord);
            }
        }
    }

    @Override
    public PropertyRecord getRecord(long id) {
        return this.getRecord(new PropertyRecord(id));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PropertyRecord getRecord(PropertyRecord record) {
        try (PageCursor cursor = this.storeFile.io(this.pageIdForRecord(record.getId()), 1);){
            AbstractBaseRecord tmpRecord = null;
            if (cursor.next()) {
                do {
                    tmpRecord = this.getRecord(cursor, record);
                } while (cursor.shouldRetry());
            }
            if (tmpRecord == null) throw new InvalidRecordException("PropertyRecord[" + record.getId() + "] not in use");
            if (!tmpRecord.inUse()) {
                throw new InvalidRecordException("PropertyRecord[" + record.getId() + "] not in use");
            }
            PropertyRecord propertyRecord = record;
            return propertyRecord;
        }
        catch (IOException e) {
            throw new UnderlyingStorageException(e);
        }
    }

    public PageCursor newReadCursor(long recordId) throws IOException {
        PageCursor cursor = this.storeFile.io(this.pageIdForRecord(recordId), 1);
        try {
            if (!cursor.next()) {
                throw new IOException("Record not found: " + recordId);
            }
            cursor.setOffset((int)(recordId * 41L % (long)this.storeFile.pageSize()));
            return cursor;
        }
        catch (Throwable failure) {
            cursor.close();
            throw failure;
        }
    }

    public PropertyRecord getRecord(PropertyRecord record, PageCursor cursor) {
        try {
            AbstractBaseRecord tmpRecord = null;
            if (cursor.next(this.pageIdForRecord(record.getId()))) {
                do {
                    tmpRecord = this.getRecord(cursor, record);
                } while (cursor.shouldRetry());
            }
            if (tmpRecord == null || !tmpRecord.inUse()) {
                throw new InvalidRecordException("PropertyRecord[" + record.getId() + "] not in use");
            }
            record.verifyRecordIsWellFormed();
            return record;
        }
        catch (IOException e) {
            throw new UnderlyingStorageException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public PropertyRecord forceGetRecord(long id) {
        try (PageCursor cursor = this.storeFile.io(this.pageIdForRecord(id), 1);){
            PropertyRecord record = new PropertyRecord(id);
            if (cursor.next()) {
                do {
                    record = this.getRecord(cursor, record);
                } while (cursor.shouldRetry());
            }
            PropertyRecord propertyRecord = record == null ? new PropertyRecord(id) : record;
            return propertyRecord;
        }
        catch (IOException e) {
            throw new UnderlyingStorageException(e);
        }
    }

    private PropertyRecord getRecordFromBuffer(long id, PageCursor cursor) {
        return this.getRecordFromBuffer(cursor, new PropertyRecord(id));
    }

    private PropertyRecord getRecordFromBuffer(PageCursor cursor, PropertyRecord record) {
        PropertyBlock newBlock;
        record.clearPropertyBlocks();
        int offsetAtBeginning = cursor.getOffset();
        byte modifiers = cursor.getByte();
        long prevMod = ((long)modifiers & 0xF0L) << 28;
        long nextMod = ((long)modifiers & 0xFL) << 32;
        long prevProp = cursor.getUnsignedInt();
        long nextProp = cursor.getUnsignedInt();
        record.setPrevProp(PropertyStore.longFromIntAndMod(prevProp, prevMod));
        record.setNextProp(PropertyStore.longFromIntAndMod(nextProp, nextMod));
        while (cursor.getOffset() - offsetAtBeginning < 41 && (newBlock = this.getPropertyBlock(cursor, record)) != null) {
            record.addPropertyBlock(newBlock);
            record.setInUse(true);
        }
        return record;
    }

    private PropertyRecord getRecord(PageCursor cursor, PropertyRecord record) {
        cursor.setOffset((int)(record.getId() * 41L % (long)this.storeFile.pageSize()));
        return this.getRecordFromBuffer(cursor, record);
    }

    private PropertyBlock getPropertyBlock(PageCursor cursor, PropertyRecord record) {
        long header = cursor.getLong();
        PropertyType type = PropertyType.getPropertyType(header, true);
        if (type == null) {
            return null;
        }
        PropertyBlock toReturn = new PropertyBlock();
        int numBlocks = type.calculateNumberOfBlocksUsed(header);
        if (numBlocks == -1) {
            record.setMalformedMessage("Invalid type or encoding of property block");
            return null;
        }
        if (numBlocks > PropertyType.getPayloadSizeLongs()) {
            record.setMalformedMessage("I was given an array of size " + numBlocks + ", but I wanted it to be " + PropertyType.getPayloadSizeLongs());
            return null;
        }
        long[] blockData = new long[numBlocks];
        blockData[0] = header;
        for (int i = 1; i < numBlocks; ++i) {
            blockData[i] = cursor.getLong();
        }
        toReturn.setValueBlocks(blockData);
        return toReturn;
    }

    public Object getValue(PropertyBlock propertyBlock) {
        return propertyBlock.getType().getValue(propertyBlock, this);
    }

    public static void allocateStringRecords(Collection<DynamicRecord> target, byte[] chars, DynamicRecordAllocator allocator) {
        AbstractDynamicStore.allocateRecordsFromBytes(target, chars, IteratorUtil.emptyIterator(), allocator);
    }

    public static void allocateArrayRecords(Collection<DynamicRecord> target, Object array, DynamicRecordAllocator allocator) {
        DynamicArrayStore.allocateRecords(target, array, IteratorUtil.emptyIterator(), allocator);
    }

    public void encodeValue(PropertyBlock block, int keyId, Object value) {
        PropertyStore.encodeValue(block, keyId, value, this.stringPropertyStore, this.arrayPropertyStore);
    }

    public static void encodeValue(PropertyBlock block, int keyId, Object value, DynamicRecordAllocator stringAllocator, DynamicRecordAllocator arrayAllocator) {
        if (value instanceof String) {
            String string = (String)value;
            if (LongerShortString.encode(keyId, string, block, PropertyType.getPayloadSize())) {
                return;
            }
            byte[] encodedString = PropertyStore.encodeString(string);
            ArrayList<DynamicRecord> valueRecords = new ArrayList<DynamicRecord>();
            PropertyStore.allocateStringRecords(valueRecords, encodedString, stringAllocator);
            PropertyStore.setSingleBlockValue(block, keyId, PropertyType.STRING, IteratorUtil.first(valueRecords).getId());
            for (DynamicRecord valueRecord : valueRecords) {
                valueRecord.setType(PropertyType.STRING.intValue());
            }
            block.setValueRecords(valueRecords);
        } else if (value instanceof Integer) {
            PropertyStore.setSingleBlockValue(block, keyId, PropertyType.INT, ((Integer)value).longValue());
        } else if (value instanceof Boolean) {
            PropertyStore.setSingleBlockValue(block, keyId, PropertyType.BOOL, (Boolean)value != false ? 1L : 0L);
        } else if (value instanceof Float) {
            PropertyStore.setSingleBlockValue(block, keyId, PropertyType.FLOAT, Float.floatToRawIntBits(((Float)value).floatValue()));
        } else if (value instanceof Long) {
            long keyAndType = (long)keyId | (long)PropertyType.LONG.intValue() << 24;
            if (ShortArray.LONG.getRequiredBits((Long)value) <= 35) {
                block.setSingleBlock(keyAndType | 0x10000000L | (Long)value << 29);
            } else {
                block.setValueBlocks(new long[]{keyAndType, (Long)value});
            }
        } else if (value instanceof Double) {
            block.setValueBlocks(new long[]{(long)keyId | (long)PropertyType.DOUBLE.intValue() << 24, Double.doubleToRawLongBits((Double)value)});
        } else if (value instanceof Byte) {
            PropertyStore.setSingleBlockValue(block, keyId, PropertyType.BYTE, ((Byte)value).longValue());
        } else if (value instanceof Character) {
            PropertyStore.setSingleBlockValue(block, keyId, PropertyType.CHAR, ((Character)value).charValue());
        } else if (value instanceof Short) {
            PropertyStore.setSingleBlockValue(block, keyId, PropertyType.SHORT, ((Short)value).longValue());
        } else if (value.getClass().isArray()) {
            if (ShortArray.encode(keyId, value, block, PropertyType.getPayloadSize())) {
                return;
            }
            ArrayList<DynamicRecord> arrayRecords = new ArrayList<DynamicRecord>();
            PropertyStore.allocateArrayRecords(arrayRecords, value, arrayAllocator);
            PropertyStore.setSingleBlockValue(block, keyId, PropertyType.ARRAY, IteratorUtil.first(arrayRecords).getId());
            for (DynamicRecord valueRecord : arrayRecords) {
                valueRecord.setType(PropertyType.ARRAY.intValue());
            }
            block.setValueRecords(arrayRecords);
        } else {
            throw new IllegalArgumentException("Unknown property type on: " + value + ", " + value.getClass());
        }
    }

    public static void setSingleBlockValue(PropertyBlock block, int keyId, PropertyType type, long longValue) {
        block.setSingleBlock(PropertyStore.singleBlockLongValue(keyId, type, longValue));
    }

    public static long singleBlockLongValue(int keyId, PropertyType type, long longValue) {
        return (long)keyId | (long)type.intValue() << 24 | longValue << 28;
    }

    public static byte[] encodeString(String string) {
        return UTF8.encode(string);
    }

    public static String decodeString(byte[] byteArray) {
        return UTF8.decode(byteArray);
    }

    public String getStringFor(PropertyBlock propertyBlock) {
        this.ensureHeavy(propertyBlock);
        return this.getStringFor(propertyBlock.getValueRecords());
    }

    public String getStringFor(Collection<DynamicRecord> dynamicRecords) {
        Pair<byte[], byte[]> source = this.stringPropertyStore.readFullByteArray(dynamicRecords, PropertyType.STRING);
        return PropertyStore.decodeString(source.other());
    }

    public Object getArrayFor(PropertyBlock propertyBlock) {
        this.ensureHeavy(propertyBlock);
        return this.getArrayFor(propertyBlock.getValueRecords());
    }

    public Object getArrayFor(Iterable<DynamicRecord> records) {
        return DynamicArrayStore.getRightArray(this.arrayPropertyStore.readFullByteArray(records, PropertyType.ARRAY));
    }

    public int getStringBlockSize() {
        return this.stringPropertyStore.getBlockSize();
    }

    public int getArrayBlockSize() {
        return this.arrayPropertyStore.getBlockSize();
    }

    @Override
    public String toString() {
        return super.toString() + "[blocksPerRecord:" + PropertyType.getPayloadSizeLongs() + "]";
    }

    public PropertyRecordCursor getPropertyRecordCursor(PropertyRecordCursor cursor, long firstRecordId) {
        if (cursor == null) {
            cursor = new PropertyRecordCursor(new PropertyRecord(-1L), this);
        }
        cursor.init(firstRecordId);
        return cursor;
    }

    public Collection<PropertyRecord> getPropertyRecordChain(long firstRecordId) {
        long nextProp = firstRecordId;
        LinkedList<PropertyRecord> toReturn = new LinkedList<PropertyRecord>();
        while (nextProp != (long)Record.NO_NEXT_PROPERTY.intValue()) {
            PropertyRecord propRecord = this.getLightRecord(nextProp);
            toReturn.add(propRecord);
            nextProp = propRecord.getNextProp();
        }
        return toReturn;
    }

    public Collection<PropertyRecord> getPropertyRecordChain(long firstRecordId, PrimitiveLongObjectMap<PropertyRecord> propertyLookup) {
        long nextProp = firstRecordId;
        ArrayList<PropertyRecord> toReturn = new ArrayList<PropertyRecord>();
        while (nextProp != (long)Record.NO_NEXT_PROPERTY.intValue()) {
            PropertyRecord propRecord = (PropertyRecord)propertyLookup.get(nextProp);
            if (propRecord == null) {
                propRecord = this.getLightRecord(nextProp);
            }
            toReturn.add(propRecord);
            nextProp = propRecord.getNextProp();
        }
        return toReturn;
    }

    public void toLogicalUpdates(Collection<NodePropertyUpdate> target, Iterable<PropertyRecordChange> changes, long[] nodeLabelsBefore, long[] nodeLabelsAfter) {
        this.physicalToLogicalConverter.apply(target, changes, nodeLabelsBefore, nodeLabelsAfter);
    }

    @Override
    protected boolean isRecordInUse(PageCursor cursor) {
        return this.getRecordFromBuffer(0L, cursor).inUse();
    }

    public static abstract class Configuration
    extends CommonAbstractStore.Configuration {
    }
}

