/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import org.neo4j.graphdb.NotInTransactionException;
import org.neo4j.graphdb.TransactionTerminatedException;
import org.neo4j.kernel.api.DataWriteOperations;
import org.neo4j.kernel.api.ReadOperations;
import org.neo4j.kernel.api.SchemaWriteOperations;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.TokenWriteOperations;
import org.neo4j.kernel.api.exceptions.InvalidTransactionTypeKernelException;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.index.IndexDescriptor;
import org.neo4j.kernel.api.index.IndexReader;
import org.neo4j.kernel.api.labelscan.LabelScanReader;
import org.neo4j.kernel.api.labelscan.LabelScanStore;
import org.neo4j.kernel.api.txstate.LegacyIndexTransactionState;
import org.neo4j.kernel.api.txstate.TransactionState;
import org.neo4j.kernel.api.txstate.TxStateHolder;
import org.neo4j.kernel.impl.api.IndexReaderFactory;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.kernel.impl.api.OperationsFacade;
import org.neo4j.kernel.impl.api.StatementOperationParts;
import org.neo4j.kernel.impl.api.store.StoreStatement;
import org.neo4j.kernel.impl.locking.Locks;

public class KernelStatement
implements TxStateHolder,
Statement {
    protected final Locks.Client locks;
    protected final TxStateHolder txStateHolder;
    protected final IndexReaderFactory indexReaderFactory;
    protected final LabelScanStore labelScanStore;
    private final StoreStatement storeStatement;
    private final KernelTransactionImplementation transaction;
    private final OperationsFacade facade;
    private LabelScanReader labelScanReader;
    private int referenceCount;
    private boolean closed;

    public KernelStatement(KernelTransactionImplementation transaction, IndexReaderFactory indexReaderFactory, LabelScanStore labelScanStore, TxStateHolder txStateHolder, Locks.Client locks, StatementOperationParts operations, StoreStatement storeStatement) {
        this.transaction = transaction;
        this.locks = locks;
        this.indexReaderFactory = indexReaderFactory;
        this.txStateHolder = txStateHolder;
        this.labelScanStore = labelScanStore;
        this.storeStatement = storeStatement;
        this.facade = new OperationsFacade(this, operations);
    }

    @Override
    public ReadOperations readOperations() {
        return this.facade;
    }

    @Override
    public TokenWriteOperations tokenWriteOperations() {
        return this.facade;
    }

    @Override
    public DataWriteOperations dataWriteOperations() throws InvalidTransactionTypeKernelException {
        this.transaction.upgradeToDataTransaction();
        return this.facade;
    }

    @Override
    public SchemaWriteOperations schemaWriteOperations() throws InvalidTransactionTypeKernelException {
        this.transaction.upgradeToSchemaTransaction();
        return this.facade;
    }

    @Override
    public TransactionState txState() {
        return this.txStateHolder.txState();
    }

    @Override
    public LegacyIndexTransactionState legacyIndexTxState() {
        return this.txStateHolder.legacyIndexTxState();
    }

    @Override
    public boolean hasTxStateWithChanges() {
        return this.txStateHolder.hasTxStateWithChanges();
    }

    @Override
    public void close() {
        if (!this.closed && this.release()) {
            this.closed = true;
            this.cleanupResources();
        }
    }

    void assertOpen() {
        if (this.closed) {
            throw new NotInTransactionException("The statement has been closed.");
        }
        Status terminationReason = this.transaction.getReasonIfTerminated();
        if (terminationReason != null) {
            throw new TransactionTerminatedException(terminationReason);
        }
    }

    public Locks.Client locks() {
        return this.locks;
    }

    public IndexReader getIndexReader(IndexDescriptor descriptor) throws IndexNotFoundKernelException {
        return this.indexReaderFactory.newReader(descriptor);
    }

    public IndexReader getFreshIndexReader(IndexDescriptor descriptor) throws IndexNotFoundKernelException {
        return this.indexReaderFactory.newUnCachedReader(descriptor);
    }

    public LabelScanReader getLabelScanReader() {
        if (this.labelScanReader == null) {
            this.labelScanReader = this.labelScanStore.newReader();
        }
        return this.labelScanReader;
    }

    final void acquire() {
        ++this.referenceCount;
    }

    private boolean release() {
        --this.referenceCount;
        return this.referenceCount == 0;
    }

    final void forceClose() {
        if (!this.closed) {
            this.closed = true;
            this.referenceCount = 0;
            this.cleanupResources();
        }
    }

    private void cleanupResources() {
        this.indexReaderFactory.close();
        if (null != this.labelScanReader) {
            this.labelScanReader.close();
        }
        this.transaction.releaseStatement(this);
    }

    public StoreStatement getStoreStatement() {
        return this.storeStatement;
    }
}

