/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.cache;

import org.neo4j.unsafe.impl.batchimport.cache.MemoryStatsVisitor;
import org.neo4j.unsafe.impl.batchimport.cache.NumberArray;

abstract class ChunkedNumberArray<N extends NumberArray>
implements NumberArray {
    protected final long chunkSize;
    protected NumberArray[] chunks;

    ChunkedNumberArray(long chunkSize) {
        this.chunkSize = chunkSize;
    }

    @Override
    public long length() {
        return (long)this.chunks.length * this.chunkSize;
    }

    @Override
    public void clear() {
        for (NumberArray chunk : this.chunks) {
            chunk.clear();
        }
    }

    @Override
    public void acceptMemoryStatsVisitor(MemoryStatsVisitor visitor) {
        for (NumberArray chunk : this.chunks) {
            chunk.acceptMemoryStatsVisitor(visitor);
        }
    }

    protected N chunkAt(long index) {
        int chunkIndex = this.chunkIndex(index);
        return (N)this.chunks[chunkIndex];
    }

    protected N chunkOrNullAt(long index) {
        int chunkIndex = this.chunkIndex(index);
        return (N)(chunkIndex < this.chunks.length ? this.chunks[chunkIndex] : null);
    }

    protected int chunkIndex(long index) {
        return (int)(index / this.chunkSize);
    }

    protected long index(long index) {
        return index % this.chunkSize;
    }

    @Override
    public void close() {
        for (NumberArray chunk : this.chunks) {
            chunk.close();
        }
    }
}

