/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.context;

import org.neo4j.io.pagecache.context.OldestTransactionIdFactory;
import org.neo4j.io.pagecache.context.TransactionIdSnapshot;
import org.neo4j.io.pagecache.context.TransactionIdSnapshotFactory;
import org.neo4j.io.pagecache.context.VersionContext;

public class TransactionVersionContext
implements VersionContext {
    private static final long UNKNOWN_OBSOLETE_HEAD_VERSION = -1L;
    private final TransactionIdSnapshotFactory transactionIdSnapshotFactory;
    private final OldestTransactionIdFactory oldestTransactionIdFactory;
    private long transactionId = 0L;
    private long appendIndex = 0L;
    private TransactionIdSnapshot transactionIds;
    private long oldestTransactionId = 0L;
    private long headChain;
    private boolean dirty;
    private boolean nonVisibleHead;
    private int currentStamp = 0;

    public TransactionVersionContext(TransactionIdSnapshotFactory transactionIdSnapshotFactory, OldestTransactionIdFactory oldestIdFactory) {
        this.transactionIdSnapshotFactory = transactionIdSnapshotFactory;
        this.oldestTransactionIdFactory = oldestIdFactory;
    }

    public void initRead() {
        this.refreshVisibilityBoundaries();
        this.dirty = false;
    }

    public void initWrite(long committingTxId) {
        assert (committingTxId >= 1L);
        this.transactionId = committingTxId;
        this.oldestTransactionId = this.oldestTransactionIdFactory.oldestTransactionId();
    }

    public long committingTransactionId() {
        return this.transactionId;
    }

    public void initAppendIndex(long committingAppendIndex) {
        this.appendIndex = committingAppendIndex;
    }

    public long committingAppendIndex() {
        return this.appendIndex;
    }

    public long lastClosedTransactionId() {
        return this.transactionIds.lastClosedTxId();
    }

    public long highestClosed() {
        return this.transactionIds.highestEverSeen();
    }

    public long[] notVisibleTransactionIds() {
        return this.transactionIds.notVisibleTransactions();
    }

    public long oldestVisibleTransactionNumber() {
        return this.oldestTransactionId;
    }

    public void refreshVisibilityBoundaries() {
        this.transactionIds = this.transactionIdSnapshotFactory.createSnapshot();
        ++this.currentStamp;
    }

    public void observedChainHead(long headVersion) {
        this.headChain = headVersion;
    }

    public boolean invisibleHeadObserved() {
        return this.nonVisibleHead;
    }

    public void markHeadInvisible() {
        this.nonVisibleHead = true;
    }

    public void resetObsoleteHeadState() {
        this.headChain = -1L;
        this.nonVisibleHead = false;
    }

    public long chainHeadVersion() {
        return this.headChain;
    }

    public void markAsDirty() {
        this.dirty = true;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public boolean initializedForWrite() {
        return this.transactionId >= 1L;
    }

    public int stamp() {
        return this.currentStamp;
    }

    public boolean validateStamp(int stamp) {
        return this.currentStamp == stamp;
    }

    public String toString() {
        return "TransactionVersionContext{transactionId=" + this.transactionId + ", appendIndex=" + this.appendIndex + ", transactionIds=" + String.valueOf(this.transactionIds) + ", oldestTransactionId=" + this.oldestTransactionId + ", headChain=" + this.headChain + ", dirty=" + this.dirty + ", nonVisibleHead=" + this.nonVisibleHead + "}";
    }
}

