/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.coreapi.schema;

import java.util.List;
import java.util.Map;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.schema.ConstraintCreator;
import org.neo4j.graphdb.schema.ConstraintDefinition;
import org.neo4j.graphdb.schema.IndexSetting;
import org.neo4j.graphdb.schema.IndexSettingUtil;
import org.neo4j.graphdb.schema.IndexType;
import org.neo4j.graphdb.schema.PropertyType;
import org.neo4j.internal.schema.IndexConfig;
import org.neo4j.kernel.impl.coreapi.schema.BaseRelationshipConstraintCreator;
import org.neo4j.kernel.impl.coreapi.schema.IndexCreatorImpl;
import org.neo4j.kernel.impl.coreapi.schema.IndexDefinitionImpl;
import org.neo4j.kernel.impl.coreapi.schema.InternalSchemaActions;

public class RelationshipKeyConstraintCreator
extends BaseRelationshipConstraintCreator {
    private final List<String> propertyKeys;

    RelationshipKeyConstraintCreator(InternalSchemaActions actions, String name, RelationshipType type, List<String> propertyKeys, IndexType indexType, IndexConfig indexConfig) {
        super(actions, name, type, indexType, indexConfig);
        this.propertyKeys = propertyKeys;
    }

    @Override
    public ConstraintCreator assertPropertyIsUnique(String propertyKey) {
        throw new UnsupportedOperationException("You can only create one unique constraint at a time.");
    }

    @Override
    public ConstraintCreator assertPropertyExists(String propertyKey) {
        throw new UnsupportedOperationException("You can only create one property existence constraint at a time.");
    }

    @Override
    public ConstraintCreator assertPropertyIsRelationshipKey(String propertyKey) {
        return new RelationshipKeyConstraintCreator(this.actions, this.name, this.type, IndexCreatorImpl.copyAndAdd(this.propertyKeys, propertyKey), this.indexType, this.indexConfig);
    }

    @Override
    public ConstraintCreator assertPropertyHasType(String propertyKey, PropertyType ... propertyType) {
        throw new UnsupportedOperationException("You cannot create a property type constraint together with other constraints.");
    }

    @Override
    public ConstraintCreator withName(String name) {
        return new RelationshipKeyConstraintCreator(this.actions, name, this.type, this.propertyKeys, this.indexType, this.indexConfig);
    }

    @Override
    public ConstraintCreator withIndexType(IndexType indexType) {
        return new RelationshipKeyConstraintCreator(this.actions, this.name, this.type, this.propertyKeys, indexType, this.indexConfig);
    }

    @Override
    public ConstraintCreator withIndexConfiguration(Map<IndexSetting, Object> indexConfiguration) {
        return new RelationshipKeyConstraintCreator(this.actions, this.name, this.type, this.propertyKeys, this.indexType, IndexSettingUtil.toIndexConfigFromIndexSettingObjectMap(indexConfiguration));
    }

    @Override
    public ConstraintDefinition create() {
        this.assertInUnterminatedTransaction();
        IndexDefinitionImpl index = new IndexDefinitionImpl(this.actions, null, new RelationshipType[]{this.type}, this.propertyKeys.toArray(new String[0]), true);
        return this.actions.createRelationshipKeyConstraint(index, this.name, this.indexType, this.indexConfig);
    }
}

