/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

class TokenScanValue {
    public static final int RANGE_SIZE = 64;
    static final int RANGE_SIZE_BYTES = 8;
    long bits;

    TokenScanValue() {
    }

    TokenScanValue(long bits) {
        this.bits = bits;
    }

    TokenScanValue set(int index) {
        long mask = 1L << index;
        this.bits |= mask;
        return this;
    }

    TokenScanValue add(TokenScanValue other) {
        this.bits |= other.bits;
        return this;
    }

    TokenScanValue remove(TokenScanValue other) {
        this.bits &= other.bits ^ 0xFFFFFFFFFFFFFFFFL;
        return this;
    }

    void clear() {
        this.bits = 0L;
    }

    boolean isEmpty() {
        return this.bits == 0L;
    }

    public String toString() {
        return Long.toBinaryString(this.bits);
    }
}

