/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.OptionalLong;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import org.eclipse.collections.impl.map.mutable.primitive.LongObjectHashMap;
import org.neo4j.batchimport.api.ReadBehaviour;
import org.neo4j.common.EntityType;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.configuration.Config;
import org.neo4j.exceptions.KernelException;
import org.neo4j.exceptions.UnderlyingStorageException;
import org.neo4j.internal.helpers.collection.Pair;
import org.neo4j.internal.kernel.api.TokenRead;
import org.neo4j.internal.schema.AllIndexProviderDescriptors;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.internal.schema.ConstraintType;
import org.neo4j.internal.schema.EndpointType;
import org.neo4j.internal.schema.GraphTypeDependence;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.internal.schema.NodeLabelExistenceSchemaDescriptor;
import org.neo4j.internal.schema.RelationshipEndpointLabelSchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptors;
import org.neo4j.internal.schema.SchemaRule;
import org.neo4j.internal.schema.constraints.ConstraintDescriptorFactory;
import org.neo4j.internal.schema.constraints.IndexBackedConstraintDescriptor;
import org.neo4j.internal.schema.constraints.NodeLabelExistenceConstraintDescriptor;
import org.neo4j.internal.schema.constraints.PropertyTypeSet;
import org.neo4j.internal.schema.constraints.RelationshipEndpointLabelConstraintDescriptor;
import org.neo4j.internal.schema.constraints.UniquenessConstraintDescriptor;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.database.DatabaseTracers;
import org.neo4j.kernel.impl.newapi.ReadOnlyTokenRead;
import org.neo4j.kernel.impl.storemigration.SchemaStore44MigrationUtil;
import org.neo4j.kernel.impl.transaction.log.LogTailLogVersionsMetadata;
import org.neo4j.kernel.impl.transaction.log.LogTailMetadata;
import org.neo4j.kernel.recovery.LogTailExtractor;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.SchemaRule44;
import org.neo4j.storageengine.api.StorageEngineFactory;
import org.neo4j.storageengine.migration.SchemaRuleMigrationAccessExtended;
import org.neo4j.token.TokenHolders;

public class SchemaMigrator {
    private SchemaMigrator() {
    }

    public static List<SchemaRule> migrateSchemaRules(StorageEngineFactory fromStorage, StorageEngineFactory toStorage, FileSystemAbstraction fs, PageCache pageCache, PageCacheTracer pageCacheTracer, Config config, DatabaseLayout from, DatabaseLayout toLayout, boolean from44store, CursorContextFactory contextFactory, LogTailMetadata fromTailMetadata, boolean forceBtreeIndexesToRange, ReadBehaviour readBehaviour, MemoryTracker memoryTracker) throws IOException, KernelException {
        LogTailExtractor logTailExtractor = new LogTailExtractor(fs, config, toStorage, DatabaseTracers.EMPTY);
        LogTailMetadata logTail = logTailExtractor.getTailMetadata(toLayout, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        TokenHolders tokenHolders = fromStorage.loadReadOnlyTokens(fs, from, config, pageCache, pageCacheTracer, true, contextFactory, memoryTracker);
        ArrayList<SchemaRule> skippedSchemaRules = new ArrayList<SchemaRule>();
        try (SchemaRuleMigrationAccessExtended schemaRuleMigrationAccess = toStorage.schemaRuleMigrationAccess(fs, pageCache, pageCacheTracer, config, toLayout, contextFactory, (MemoryTracker)EmptyMemoryTracker.INSTANCE, logTail);){
            ReadOnlyTokenRead tokenRead = new ReadOnlyTokenRead(tokenHolders);
            LongObjectHashMap indexesToConnect = new LongObjectHashMap();
            LongObjectHashMap constraintsToConnect = new LongObjectHashMap();
            for (SchemaRule schemaRule : SchemaMigrator.getSrcSchemaRules(fromStorage, fs, pageCache, pageCacheTracer, config, from, contextFactory, from44store, fromTailMetadata, forceBtreeIndexesToRange, tokenHolders, memoryTracker)) {
                SchemaDescriptor schema;
                if (schemaRule instanceof IndexDescriptor) {
                    IndexDescriptor indexDescriptor = (IndexDescriptor)schemaRule;
                    try {
                        if (indexDescriptor.isTokenIndex()) continue;
                        if (SchemaMigrator.shouldSkipSinceFiltered(readBehaviour, tokenHolders, indexDescriptor.schema())) {
                            skippedSchemaRules.add((SchemaRule)indexDescriptor);
                            continue;
                        }
                        schema = SchemaMigrator.translateToNewSchema(indexDescriptor.schema(), tokenRead, schemaRuleMigrationAccess.tokenHolders());
                        IndexPrototype newPrototype = indexDescriptor.isUnique() ? IndexPrototype.uniqueForSchema((SchemaDescriptor)schema) : IndexPrototype.forSchema((SchemaDescriptor)schema);
                        IndexProviderDescriptor latestIndexProvider = (IndexProviderDescriptor)AllIndexProviderDescriptors.LATEST_INDEX_PROVIDERS.get(indexDescriptor.getIndexType());
                        newPrototype = newPrototype.withName(indexDescriptor.getName()).withIndexType(indexDescriptor.getIndexType()).withIndexConfig(indexDescriptor.getIndexConfig()).withIndexProvider(latestIndexProvider);
                        if (indexDescriptor.isUnique()) {
                            indexesToConnect.put(indexDescriptor.getId(), (Object)new IndexToConnect(indexDescriptor.getId(), indexDescriptor.getOwningConstraintId(), newPrototype));
                            continue;
                        }
                        IndexDescriptor newDescriptor = newPrototype.materialise(schemaRuleMigrationAccess.nextId());
                        schemaRuleMigrationAccess.writeSchemaRule((SchemaRule)newDescriptor);
                    }
                    catch (Exception e) {
                        readBehaviour.error((Throwable)e, "Could not copy %s", new Object[]{indexDescriptor.userDescription((TokenNameLookup)tokenHolders)});
                    }
                    continue;
                }
                if (!(schemaRule instanceof ConstraintDescriptor)) continue;
                ConstraintDescriptor constraintDescriptor = (ConstraintDescriptor)schemaRule;
                try {
                    if (SchemaMigrator.shouldSkipSinceFiltered(readBehaviour, tokenHolders, constraintDescriptor.schema())) {
                        skippedSchemaRules.add((SchemaRule)constraintDescriptor);
                        continue;
                    }
                    schema = SchemaMigrator.translateToNewSchema(constraintDescriptor.schema(), tokenRead, schemaRuleMigrationAccess.tokenHolders());
                    UniquenessConstraintDescriptor descriptor = switch (constraintDescriptor.type()) {
                        default -> throw new MatchException(null, null);
                        case ConstraintType.UNIQUE -> {
                            IndexBackedConstraintDescriptor indexBacked = constraintDescriptor.asIndexBackedConstraint();
                            yield ConstraintDescriptorFactory.uniqueForSchema((SchemaDescriptor)schema, (IndexType)indexBacked.indexType());
                        }
                        case ConstraintType.EXISTS -> ConstraintDescriptorFactory.existsForSchema((SchemaDescriptor)schema, (constraintDescriptor.graphTypeDependence() == GraphTypeDependence.DEPENDENT ? 1 : 0) != 0);
                        case ConstraintType.UNIQUE_EXISTS -> {
                            IndexBackedConstraintDescriptor indexBacked = constraintDescriptor.asIndexBackedConstraint();
                            yield ConstraintDescriptorFactory.keyForSchema((SchemaDescriptor)schema, (IndexType)indexBacked.indexType());
                        }
                        case ConstraintType.PROPERTY_TYPE -> ConstraintDescriptorFactory.typeForSchema((SchemaDescriptor)schema, (PropertyTypeSet)constraintDescriptor.asPropertyTypeConstraint().propertyType(), (constraintDescriptor.graphTypeDependence() == GraphTypeDependence.DEPENDENT ? 1 : 0) != 0);
                        case ConstraintType.RELATIONSHIP_ENDPOINT_LABEL -> {
                            RelationshipEndpointLabelConstraintDescriptor relationshipEndpointLabelSchemaDescriptor = constraintDescriptor.asRelationshipEndpointLabelConstraint();
                            yield ConstraintDescriptorFactory.relationshipEndpointLabelForSchema((RelationshipEndpointLabelSchemaDescriptor)schema.asRelationshipEndpointLabelDescriptor(), (int)relationshipEndpointLabelSchemaDescriptor.endpointLabelId(), (EndpointType)relationshipEndpointLabelSchemaDescriptor.endpointType());
                        }
                        case ConstraintType.NODE_LABEL_EXISTENCE -> {
                            NodeLabelExistenceConstraintDescriptor nodeLabelExistenceSchemaDescriptor = constraintDescriptor.asNodeLabelExistenceConstraint();
                            yield ConstraintDescriptorFactory.nodeLabelExistenceForSchema((NodeLabelExistenceSchemaDescriptor)schema.asNodeLabelExistenceSchemaDescriptor(), (int)nodeLabelExistenceSchemaDescriptor.requiredLabelId());
                        }
                    };
                    descriptor = descriptor.withName(constraintDescriptor.getName());
                    if (descriptor.isIndexBackedConstraint()) {
                        constraintsToConnect.put(constraintDescriptor.getId(), (Object)new ConstraintToConnect(constraintDescriptor.getId(), constraintDescriptor.asIndexBackedConstraint().ownedIndexId(), (ConstraintDescriptor)descriptor));
                        continue;
                    }
                    descriptor = descriptor.withId(schemaRuleMigrationAccess.nextId());
                    schemaRuleMigrationAccess.writeSchemaRule((SchemaRule)descriptor);
                }
                catch (Exception e) {
                    readBehaviour.error((Throwable)e, "Could not copy %s", new Object[]{constraintDescriptor.userDescription((TokenNameLookup)tokenHolders)});
                }
            }
            for (ConstraintToConnect constraintToConnect : constraintsToConnect.values()) {
                IndexToConnect indexToConnect = (IndexToConnect)indexesToConnect.remove(constraintToConnect.indexId);
                if (indexToConnect == null || indexToConnect.oldConstraintId.isPresent() && indexToConnect.oldConstraintId.getAsLong() != constraintToConnect.oldId) {
                    throw new UnderlyingStorageException("Encountered an inconsistent schema store - can not migrate. Affected rules have id " + constraintToConnect.oldId + (String)(indexToConnect != null ? " and " + indexToConnect.oldId : ""));
                }
                long newIndexId = schemaRuleMigrationAccess.nextId();
                long newConstraintId = schemaRuleMigrationAccess.nextId();
                schemaRuleMigrationAccess.writeSchemaRule((SchemaRule)indexToConnect.prototype.materialise(newIndexId).withOwningConstraintId(newConstraintId));
                schemaRuleMigrationAccess.writeSchemaRule((SchemaRule)constraintToConnect.prototype.withId(newConstraintId).withOwnedIndexId(newIndexId));
            }
            for (IndexToConnect indexToConnect : indexesToConnect) {
                schemaRuleMigrationAccess.writeSchemaRule((SchemaRule)indexToConnect.prototype.materialise(schemaRuleMigrationAccess.nextId()));
            }
        }
        return skippedSchemaRules;
    }

    private static boolean shouldSkipSinceFiltered(ReadBehaviour readBehaviour, TokenHolders tokenHolders, SchemaDescriptor schemaDescriptor) {
        String[] entityTokenNames = tokenHolders.entityTokensGetNames(schemaDescriptor.entityType(), schemaDescriptor.getEntityTokenIds());
        switch (schemaDescriptor.schemaPatternMatchingType()) {
            case COMPLETE_ALL_TOKENS: {
                switch (schemaDescriptor.entityType()) {
                    case NODE: {
                        for (int propertyTokenId : schemaDescriptor.getPropertyIds()) {
                            String propertyKeyName = tokenHolders.propertyKeyGetName(propertyTokenId);
                            if (readBehaviour.shouldIncludeNodeProperty(propertyKeyName, entityTokenNames, true)) continue;
                            return true;
                        }
                        if (readBehaviour.filterLabels(entityTokenNames).length == entityTokenNames.length) break;
                        return true;
                    }
                    case RELATIONSHIP: {
                        for (String entityTokenName : entityTokenNames) {
                            for (int propertyTokenId : schemaDescriptor.getPropertyIds()) {
                                String propertyKeyName = tokenHolders.propertyKeyGetName(propertyTokenId);
                                if (readBehaviour.shouldIncludeRelationshipProperty(propertyKeyName, entityTokenName)) continue;
                                return true;
                            }
                        }
                        break;
                    }
                }
                break;
            }
            case PARTIAL_ANY_TOKEN: {
                switch (schemaDescriptor.entityType()) {
                    case NODE: {
                        for (int propertyTokenId : schemaDescriptor.getPropertyIds()) {
                            String propertyKeyName = tokenHolders.propertyKeyGetName(propertyTokenId);
                            if (!readBehaviour.shouldIncludeNodeProperty(propertyKeyName, entityTokenNames, false)) continue;
                            return false;
                        }
                        if (readBehaviour.filterLabels(entityTokenNames).length == 0) {
                            return true;
                        }
                        return true;
                    }
                    case RELATIONSHIP: {
                        for (String entityTokenName : entityTokenNames) {
                            for (int propertyTokenId : schemaDescriptor.getPropertyIds()) {
                                String propertyKeyName = tokenHolders.propertyKeyGetName(propertyTokenId);
                                if (!readBehaviour.shouldIncludeRelationshipProperty(propertyKeyName, entityTokenName)) continue;
                                return false;
                            }
                        }
                        break;
                    }
                }
                break;
            }
            case ENTITY_TOKENS: {
                throw new IllegalArgumentException(schemaDescriptor.schemaPatternMatchingType().name());
            }
        }
        return false;
    }

    private static List<SchemaRule> getSrcSchemaRules(StorageEngineFactory fromStorage, FileSystemAbstraction fs, PageCache pageCache, PageCacheTracer pageCacheTracer, Config config, DatabaseLayout from, CursorContextFactory contextFactory, boolean from44store, LogTailMetadata fromTailMetadata, boolean forceBtreeIndexesToRange, TokenHolders srcTokenHolders, MemoryTracker memoryTracker) {
        if (from44store) {
            List schemaRule44s = fromStorage.load44SchemaRules(fs, pageCache, pageCacheTracer, config, from, contextFactory, (LogTailLogVersionsMetadata)fromTailMetadata, memoryTracker);
            SchemaStore44MigrationUtil.SchemaInfo44 schemaInfo44 = SchemaStore44MigrationUtil.extractRuleInfo((boolean)true, (List)schemaRule44s);
            SchemaStore44MigrationUtil.assertCanMigrate((boolean)forceBtreeIndexesToRange, (List)schemaInfo44.nonReplacedIndexes(), (List)schemaInfo44.nonReplacedConstraints(), (TokenHolders)srcTokenHolders);
            AtomicLong highestExistingId = new AtomicLong(SchemaMigrator.getHighestExistingId(schemaInfo44));
            for (SchemaRule44.Index index : schemaInfo44.nonReplacedIndexes()) {
                IndexDescriptor rangeIndex = SchemaStore44MigrationUtil.asRangeIndex((SchemaRule44.Index)index, highestExistingId::incrementAndGet);
                schemaInfo44.toCreate().add(rangeIndex);
            }
            for (Pair constraintPair : schemaInfo44.nonReplacedConstraints()) {
                SchemaRule44.Constraint oldConstraint = (SchemaRule44.Constraint)constraintPair.first();
                SchemaRule44.Index oldIndex = (SchemaRule44.Index)constraintPair.other();
                IndexDescriptor rangeIndex = SchemaStore44MigrationUtil.asRangeIndex((SchemaRule44.Index)oldIndex, highestExistingId::incrementAndGet);
                ConstraintDescriptor rangeBackedConstraint = SchemaStore44MigrationUtil.asRangeBackedConstraint((SchemaRule44.Constraint)oldConstraint, (IndexDescriptor)rangeIndex, highestExistingId::incrementAndGet, (TokenHolders)srcTokenHolders);
                rangeIndex = rangeIndex.withOwningConstraintId(rangeBackedConstraint.getId());
                schemaInfo44.toCreate().add(rangeIndex);
                schemaInfo44.toCreate().add(rangeBackedConstraint);
            }
            return schemaInfo44.toCreate();
        }
        return fromStorage.loadSchemaRules(fs, pageCache, pageCacheTracer, config, from, true, Function.identity(), contextFactory, memoryTracker);
    }

    private static long getHighestExistingId(SchemaStore44MigrationUtil.SchemaInfo44 schemaInfo44) {
        long highestExistingId = -1L;
        for (SchemaRule schemaRule : schemaInfo44.toCreate()) {
            long id = schemaRule.getId();
            if (id <= highestExistingId) continue;
            highestExistingId = id;
        }
        return highestExistingId;
    }

    private static SchemaDescriptor translateToNewSchema(SchemaDescriptor schema, TokenRead tokenRead, TokenHolders dstTokenHolders) throws KernelException {
        int[] propertyIds = schema.getPropertyIds();
        int[] newPropertyIds = new int[propertyIds.length];
        for (int i = 0; i < propertyIds.length; ++i) {
            newPropertyIds[i] = dstTokenHolders.propertyKeyTokens().getOrCreateId(tokenRead.propertyKeyName(propertyIds[i]));
        }
        boolean forNodes = EntityType.NODE.equals((Object)schema.entityType());
        if (schema.isFulltextSchemaDescriptor()) {
            int[] entityTokenIds = schema.getEntityTokenIds();
            int[] newEntityTokenIds = new int[entityTokenIds.length];
            for (int i = 0; i < entityTokenIds.length; ++i) {
                newEntityTokenIds[i] = forNodes ? dstTokenHolders.labelTokens().getOrCreateId(tokenRead.nodeLabelName(entityTokenIds[i])) : dstTokenHolders.relationshipTypeTokens().getOrCreateId(tokenRead.relationshipTypeName(entityTokenIds[i]));
            }
            return SchemaDescriptors.fulltext((EntityType)schema.entityType(), (int[])newEntityTokenIds, (int[])newPropertyIds);
        }
        if (forNodes) {
            return SchemaDescriptors.forLabel((int)dstTokenHolders.labelTokens().getOrCreateId(tokenRead.nodeLabelName(schema.getLabelId())), (int[])newPropertyIds);
        }
        return SchemaDescriptors.forRelType((int)dstTokenHolders.relationshipTypeTokens().getOrCreateId(tokenRead.relationshipTypeName(schema.getRelTypeId())), (int[])newPropertyIds);
    }

    record IndexToConnect(long oldId, OptionalLong oldConstraintId, IndexPrototype prototype) {
    }

    record ConstraintToConnect(long oldId, long indexId, ConstraintDescriptor prototype) {
    }
}

