/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.internal.event;

import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.event.PropertyEntry;
import org.neo4j.kernel.impl.core.NodeEntity;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

class NodePropertyEntryView
implements PropertyEntry<Node> {
    static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(NodePropertyEntryView.class);
    private final InternalTransaction internalTransaction;
    private final long nodeId;
    private final String key;
    private final Value newValue;
    private final Value oldValue;

    NodePropertyEntryView(InternalTransaction internalTransaction, long nodeId, String key, Value newValue, Value oldValue) {
        this.internalTransaction = internalTransaction;
        this.nodeId = nodeId;
        this.key = key;
        this.newValue = newValue;
        this.oldValue = oldValue;
    }

    public Node entity() {
        return new NodeEntity(this.internalTransaction, this.nodeId);
    }

    public String key() {
        return this.key;
    }

    public Object previouslyCommittedValue() {
        return this.oldValue.asObjectCopy();
    }

    public Object value() {
        if (this.newValue == null || this.newValue == Values.NO_VALUE) {
            throw new IllegalStateException("This property has been removed, it has no value anymore: " + String.valueOf(this));
        }
        return this.newValue.asObjectCopy();
    }

    public String toString() {
        return "NodePropertyEntryView{nodeId=" + this.nodeId + ", key='" + this.key + "', newValue=" + String.valueOf(this.newValue) + ", oldValue=" + String.valueOf(this.oldValue) + "}";
    }
}

