/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.exceptions.schema;

import org.neo4j.gqlstatus.ErrorGqlStatusObject;
import org.neo4j.gqlstatus.ErrorGqlStatusObjectImplementation;
import org.neo4j.gqlstatus.GqlParams;
import org.neo4j.gqlstatus.GqlStatusInfoCodes;
import org.neo4j.internal.kernel.api.exceptions.schema.SchemaKernelException;
import org.neo4j.kernel.api.exceptions.Status;

public class DropIndexFailureException
extends SchemaKernelException {
    private DropIndexFailureException(String message) {
        super((Status)Status.Schema.IndexDropFailed, message);
    }

    private DropIndexFailureException(ErrorGqlStatusObject gqlStatusObject, String message) {
        super(gqlStatusObject, (Status)Status.Schema.IndexDropFailed, message);
    }

    private DropIndexFailureException(ErrorGqlStatusObject gqlStatusObject, String message, Throwable cause) {
        super(gqlStatusObject, (Status)Status.Schema.IndexDropFailed, message, cause);
    }

    public static DropIndexFailureException noIndexSpecified() {
        return new DropIndexFailureException("No index was specified.");
    }

    public static DropIndexFailureException indexDoesNotExist(String indexName) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_50N10).withParam(GqlParams.StringParam.idxDescrOrName, indexName).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22N69).withParam(GqlParams.StringParam.idxDescrOrName, indexName).build()).build();
        return new DropIndexFailureException(gql, "Unable to drop index called `" + indexName + "`. There is no such index.");
    }

    public static DropIndexFailureException cannotDrop(String indexName, String message, Throwable cause) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_50N10).withParam(GqlParams.StringParam.idxDescrOrName, indexName).build();
        return new DropIndexFailureException(gql, message, cause);
    }
}

