/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.query;

import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.neo4j.cypher.internal.CypherVersion;
import org.neo4j.kernel.api.query.LookupIndexUsage;
import org.neo4j.kernel.api.query.RelationshipTypeIndexUsage;
import org.neo4j.kernel.api.query.SchemaIndexUsage;

public class CompilerInfo {
    private final String planner;
    private final String runtime;
    private final List<SchemaIndexUsage> indexes;
    private final List<RelationshipTypeIndexUsage> relationshipTypeIndexes;
    private final List<LookupIndexUsage> lookupIndexes;
    private final CypherVersion cypherVersion;

    public CompilerInfo(String planner, String runtime, List<SchemaIndexUsage> indexes, List<RelationshipTypeIndexUsage> relationshipTypeIndexes, List<LookupIndexUsage> lookupIndexes, CypherVersion cypherVersion) {
        this.planner = planner;
        this.runtime = runtime;
        this.indexes = indexes;
        this.relationshipTypeIndexes = relationshipTypeIndexes;
        this.lookupIndexes = lookupIndexes;
        this.cypherVersion = cypherVersion;
    }

    public CompilerInfo(String planner, String runtime, List<SchemaIndexUsage> indexes, CypherVersion cypherVersion) {
        this(planner, runtime, indexes, Collections.emptyList(), Collections.emptyList(), cypherVersion);
    }

    public String planner() {
        return this.planner.toLowerCase(Locale.ROOT);
    }

    public String runtime() {
        return this.runtime.toLowerCase(Locale.ROOT);
    }

    public List<SchemaIndexUsage> indexes() {
        return this.indexes;
    }

    public List<RelationshipTypeIndexUsage> relationshipTypeIndexes() {
        return this.relationshipTypeIndexes;
    }

    public List<LookupIndexUsage> lookupIndexes() {
        return this.lookupIndexes;
    }

    public CypherVersion getCypherVersion() {
        return this.cypherVersion;
    }
}

