/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.CopyOnWriteArrayList;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.kernel.api.exceptions.schema.ConstraintValidationException;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotFoundKernelException;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.exceptions.schema.IncompleteConstraintValidationException;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.TokenIndexReader;
import org.neo4j.kernel.api.index.ValueIndexReader;
import org.neo4j.kernel.impl.api.index.AbstractDelegatingIndexProxy;
import org.neo4j.kernel.impl.api.index.FlippableIndexProxy;
import org.neo4j.kernel.impl.api.index.IndexProxy;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.api.index.OnlineIndexProxy;
import org.neo4j.kernel.impl.index.schema.DeferredConflictCheckingIndexUpdater;
import org.neo4j.storageengine.api.IndexEntryUpdate;

public class TentativeConstraintIndexProxy
extends AbstractDelegatingIndexProxy {
    private final FlippableIndexProxy flipper;
    private final OnlineIndexProxy target;
    private final Collection<IndexEntryConflictException> failures = new CopyOnWriteArrayList<IndexEntryConflictException>();

    TentativeConstraintIndexProxy(FlippableIndexProxy flipper, OnlineIndexProxy target) {
        this.flipper = flipper;
        this.target = target;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public IndexUpdater newUpdater(IndexUpdateMode mode, CursorContext cursorContext, boolean parallel) {
        switch (mode) {
            case ONLINE: 
            case RECOVERY: {
                return new DeferredConflictCheckingIndexUpdater(this.target.accessor.newUpdater(mode, cursorContext, parallel), this.target::newValueReader, this.target.getDescriptor()){

                    @Override
                    public void process(IndexEntryUpdate update) {
                        try {
                            super.process(update);
                        }
                        catch (IndexEntryConflictException conflict) {
                            TentativeConstraintIndexProxy.this.failures.add(conflict);
                        }
                    }

                    @Override
                    public void close() {
                        try {
                            super.close();
                        }
                        catch (IndexEntryConflictException conflict) {
                            TentativeConstraintIndexProxy.this.failures.add(conflict);
                        }
                    }
                };
            }
            default: {
                throw new IllegalArgumentException("Unsupported update mode: " + String.valueOf(mode));
            }
        }
    }

    @Override
    public InternalIndexState getState() {
        return this.failures.isEmpty() ? InternalIndexState.POPULATING : InternalIndexState.FAILED;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[target:" + String.valueOf(this.target) + "]";
    }

    @Override
    public ValueIndexReader newValueReader() throws IndexNotFoundKernelException {
        throw IndexNotFoundKernelException.indexIsStillPopulating((IndexDescriptor)this.getDescriptor());
    }

    @Override
    public TokenIndexReader newTokenReader() {
        throw new UnsupportedOperationException("Not supported for value indexes");
    }

    @Override
    public IndexProxy getDelegate() {
        return this.target;
    }

    @Override
    public void validate() throws IncompleteConstraintValidationException {
        if (!this.failures.isEmpty()) {
            throw new IncompleteConstraintValidationException(ConstraintValidationException.Phase.VERIFICATION, new HashSet<IndexEntryConflictException>(this.failures));
        }
    }

    @Override
    public void activate() {
        if (!this.failures.isEmpty()) {
            throw new IllegalStateException("Trying to activate failed index, should have checked the failures earlier...");
        }
        this.flipper.flipTo(this.target);
    }
}

