/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.security;

import java.net.InetAddress;
import java.net.URI;
import java.util.function.Supplier;
import org.eclipse.collections.api.factory.primitive.IntSets;
import org.eclipse.collections.api.set.primitive.IntSet;
import org.eclipse.collections.api.set.primitive.MutableIntSet;
import org.neo4j.internal.kernel.api.RelTypeSupplier;
import org.neo4j.internal.kernel.api.TokenSet;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.internal.kernel.api.security.PermissionState;
import org.neo4j.internal.kernel.api.security.PrivilegeAction;
import org.neo4j.internal.kernel.api.security.ReadSecurityPropertyProvider;
import org.neo4j.internal.kernel.api.security.SelectedPropertiesProvider;
import org.neo4j.kernel.impl.api.security.WrappedAccessMode;
import org.neo4j.messages.MessageUtil;
import org.neo4j.storageengine.api.PropertySelection;

public class RestrictedAccessMode
extends WrappedAccessMode {
    public RestrictedAccessMode(AccessMode original, AccessMode.Static restricting) {
        super(original, restricting);
    }

    public boolean allowsWrites() {
        return this.original.allowsWrites() && this.wrapping.allowsWrites();
    }

    public PermissionState allowsTokenCreates(PrivilegeAction action) {
        return this.original.allowsTokenCreates(action).restrict(this.wrapping.allowsTokenCreates(action));
    }

    public boolean allowsSchemaWrites() {
        return this.original.allowsSchemaWrites() && this.wrapping.allowsSchemaWrites();
    }

    public PermissionState allowsSchemaWrites(PrivilegeAction action) {
        return this.original.allowsSchemaWrites(action).restrict(this.wrapping.allowsSchemaWrites(action));
    }

    public boolean allowsShowIndex() {
        return this.original.allowsShowIndex() && this.wrapping.allowsShowIndex();
    }

    public boolean allowsShowConstraint() {
        return this.original.allowsShowConstraint() && this.wrapping.allowsShowConstraint();
    }

    public boolean allowsTraverseAllLabels() {
        return this.original.allowsTraverseAllLabels() && this.wrapping.allowsTraverseAllLabels();
    }

    public boolean allowsTraverseAllNodesWithLabel(int label) {
        return this.original.allowsTraverseAllNodesWithLabel(label) && this.wrapping.allowsTraverseAllNodesWithLabel(label);
    }

    public boolean disallowsTraverseLabel(int label) {
        return this.original.disallowsTraverseLabel(label) || this.wrapping.disallowsTraverseLabel(label);
    }

    public boolean allowsTraverseNode(int ... labels) {
        return this.original.allowsTraverseNode(labels) && this.wrapping.allowsTraverseNode(labels);
    }

    public IntSet getTraverseNodeSecurityProperties(int[] labels) {
        return this.original.getTraverseNodeSecurityProperties(labels).union(this.wrapping.getTraverseNodeSecurityProperties(labels));
    }

    public boolean hasApplicableTraverseNodeAllowPropertyRules(int label) {
        return this.original.hasApplicableTraverseNodeAllowPropertyRules(label) || this.wrapping.hasApplicableTraverseNodeAllowPropertyRules(label);
    }

    public boolean allowsTraverseNodeWithPropertyRules(ReadSecurityPropertyProvider propertyProvider, int ... labels) {
        return this.original.allowsTraverseNodeWithPropertyRules(propertyProvider, labels) && this.wrapping.allowsTraverseNodeWithPropertyRules(propertyProvider, labels);
    }

    public boolean hasTraverseNodePropertyRules() {
        return this.original.hasTraverseNodePropertyRules() || this.wrapping.hasTraverseNodePropertyRules();
    }

    public boolean allowsTraverseAllRelTypes() {
        return this.original.allowsTraverseAllRelTypes() && this.wrapping.allowsTraverseAllRelTypes();
    }

    public boolean allowsTraverseRelType(int relType) {
        return this.original.allowsTraverseRelType(relType) && this.wrapping.allowsTraverseRelType(relType);
    }

    public boolean disallowsTraverseRelType(int relType) {
        return this.original.disallowsTraverseRelType(relType) && this.wrapping.disallowsTraverseRelType(relType);
    }

    public IntSet getTraverseRelSecurityProperties(int types) {
        return this.original.getTraverseRelSecurityProperties(types).union(this.wrapping.getTraverseRelSecurityProperties(types));
    }

    public boolean hasApplicableTraverseRelAllowPropertyRules(int type) {
        return this.original.hasApplicableTraverseRelAllowPropertyRules(type) || this.wrapping.hasApplicableTraverseRelAllowPropertyRules(type);
    }

    public boolean allowsTraverseRelationship(int type, SelectedPropertiesProvider propertyProviderSupplier) {
        return this.original.allowsTraverseRelationship(type, propertyProviderSupplier) && this.wrapping.allowsTraverseRelationship(type, propertyProviderSupplier);
    }

    public boolean hasTraverseRelPropertyRules() {
        return this.original.hasTraverseRelPropertyRules() || this.wrapping.hasTraverseRelPropertyRules();
    }

    public boolean allowsReadPropertyAllLabels(int propertyKey) {
        return this.original.allowsReadPropertyAllLabels(propertyKey) && this.wrapping.allowsReadPropertyAllLabels(propertyKey);
    }

    public boolean disallowsReadPropertyForSomeLabel(int propertyKey) {
        return this.original.disallowsReadPropertyForSomeLabel(propertyKey) || this.wrapping.disallowsReadPropertyForSomeLabel(propertyKey);
    }

    public boolean allowsReadNodePropertiesWithPropertyRules(Supplier<TokenSet> labels, int[] propertyKeys, ReadSecurityPropertyProvider propertyProvider) {
        return this.original.allowsReadNodePropertiesWithPropertyRules(labels, propertyKeys, propertyProvider) && this.wrapping.allowsReadNodePropertiesWithPropertyRules(labels, propertyKeys, propertyProvider);
    }

    public boolean allowsReadNodeProperties(Supplier<TokenSet> labels, int[] propertyKeys) {
        return this.original.allowsReadNodeProperties(labels, propertyKeys) && this.wrapping.allowsReadNodeProperties(labels, propertyKeys);
    }

    public boolean allowsReadNodePropertyWithPropertyRules(Supplier<TokenSet> labels, int propertyKey, ReadSecurityPropertyProvider propertyProvider) {
        return this.original.allowsReadNodePropertyWithPropertyRules(labels, propertyKey, propertyProvider) && this.wrapping.allowsReadNodePropertyWithPropertyRules(labels, propertyKey, propertyProvider);
    }

    public boolean allowsReadNodeProperty(Supplier<TokenSet> labels, int propertyKey) {
        return this.original.allowsReadNodeProperty(labels, propertyKey) && this.wrapping.allowsReadNodeProperty(labels, propertyKey);
    }

    public boolean allowsReadPropertyAllRelTypes(int propertyKey) {
        return this.original.allowsReadPropertyAllRelTypes(propertyKey) && this.wrapping.allowsReadPropertyAllRelTypes(propertyKey);
    }

    public boolean allowsReadRelProperty(RelTypeSupplier relType, int propertyKey) {
        return this.original.allowsReadRelProperty(relType, propertyKey) && this.wrapping.allowsReadRelProperty(relType, propertyKey);
    }

    public boolean allowsReadRelPropertiesWithPropertyRules(RelTypeSupplier relType, int[] propertyKeys, ReadSecurityPropertyProvider propertyProvider) {
        return this.original.allowsReadRelPropertiesWithPropertyRules(relType, propertyKeys, propertyProvider) && this.wrapping.allowsReadRelPropertiesWithPropertyRules(relType, propertyKeys, propertyProvider);
    }

    public boolean allowsReadRelProperties(RelTypeSupplier relType, int[] propertyKeys) {
        return this.original.allowsReadRelProperties(relType, propertyKeys) && this.wrapping.allowsReadRelProperties(relType, propertyKeys);
    }

    public boolean allowsReadRelPropertyWithPropertyRules(RelTypeSupplier relType, int propertyKey, ReadSecurityPropertyProvider propertyProvider) {
        return this.original.allowsReadRelPropertyWithPropertyRules(relType, propertyKey, propertyProvider) && this.wrapping.allowsReadRelPropertyWithPropertyRules(relType, propertyKey, propertyProvider);
    }

    public boolean allowsSeePropertyKeyToken(int propertyKey) {
        return this.original.allowsSeePropertyKeyToken(propertyKey) && this.wrapping.allowsSeePropertyKeyToken(propertyKey);
    }

    public boolean hasNodePropertyReadRules() {
        return this.original.hasNodePropertyReadRules() || this.wrapping.hasNodePropertyReadRules();
    }

    public boolean hasNodePropertyReadRules(int ... propertyKeys) {
        return this.original.hasNodePropertyReadRules(propertyKeys) || this.wrapping.hasNodePropertyReadRules(propertyKeys);
    }

    public IntSet getNodeReadSecurityProperties(int propertyKey) {
        return this.original.getNodeReadSecurityProperties(propertyKey).union(this.wrapping.getNodeReadSecurityProperties(propertyKey));
    }

    public IntSet getAllNodeReadSecurityProperties() {
        return this.original.getAllNodeReadSecurityProperties().union(this.wrapping.getAllNodeReadSecurityProperties());
    }

    public PropertySelection getNodeSecurityPropertySelection(PropertySelection selection) {
        PropertySelection originalSelection = this.original.getNodeSecurityPropertySelection(selection);
        PropertySelection wrappingSelection = this.wrapping.getNodeSecurityPropertySelection(selection);
        return RestrictedAccessMode.combinePropertySelections(originalSelection, wrappingSelection);
    }

    public boolean hasRelPropertyReadRules() {
        return this.original.hasRelPropertyReadRules() || this.wrapping.hasRelPropertyReadRules();
    }

    public boolean hasRelPropertyReadRules(int ... propertyKeys) {
        return this.original.hasRelPropertyReadRules(propertyKeys) || this.wrapping.hasRelPropertyReadRules(propertyKeys);
    }

    public IntSet getRelReadSecurityProperties(int propertyKey) {
        return this.original.getRelReadSecurityProperties(propertyKey).union(this.wrapping.getRelReadSecurityProperties(propertyKey));
    }

    public IntSet getAllRelReadSecurityProperties() {
        return this.original.getAllRelReadSecurityProperties().union(this.wrapping.getAllRelReadSecurityProperties());
    }

    public PropertySelection getRelSecurityPropertySelection(PropertySelection selection) {
        PropertySelection originalSelection = this.original.getRelSecurityPropertySelection(selection);
        PropertySelection wrappingSelection = this.wrapping.getRelSecurityPropertySelection(selection);
        return RestrictedAccessMode.combinePropertySelections(originalSelection, wrappingSelection);
    }

    public PermissionState allowsShowSetting(String setting) {
        return this.original.allowsShowSetting(setting).restrict(this.wrapping.allowsShowSetting(setting));
    }

    public boolean allowsSetLabel(int labelId) {
        return this.original.allowsSetLabel(labelId) && this.wrapping.allowsSetLabel(labelId);
    }

    public boolean allowsRemoveLabel(int labelId) {
        return this.original.allowsRemoveLabel(labelId) && this.wrapping.allowsRemoveLabel(labelId);
    }

    public boolean allowsCreateNode(int[] labelIds) {
        return this.original.allowsCreateNode(labelIds) && this.wrapping.allowsCreateNode(labelIds);
    }

    public boolean allowsDeleteNode(Supplier<TokenSet> labelSupplier) {
        return this.original.allowsDeleteNode(labelSupplier) && this.wrapping.allowsDeleteNode(labelSupplier);
    }

    public boolean allowsCreateRelationship(int relType) {
        return this.original.allowsCreateRelationship(relType) && this.wrapping.allowsCreateRelationship(relType);
    }

    public boolean allowsDeleteRelationship(int relType) {
        return this.original.allowsDeleteRelationship(relType) && this.wrapping.allowsDeleteRelationship(relType);
    }

    public boolean allowsSetProperty(Supplier<TokenSet> labels, int propertyKey) {
        return this.original.allowsSetProperty(labels, propertyKey) && this.wrapping.allowsSetProperty(labels, propertyKey);
    }

    public boolean allowsSetProperty(RelTypeSupplier relType, int propertyKey) {
        return this.original.allowsSetProperty(relType, propertyKey) && this.wrapping.allowsSetProperty(relType, propertyKey);
    }

    public PermissionState allowsLoadAllData() {
        return this.original.allowsLoadAllData().restrict(this.wrapping.allowsLoadAllData());
    }

    public PermissionState allowsLoadUri(URI url, InetAddress inetAddress) {
        return this.original.allowsLoadUri(url, inetAddress).restrict(this.wrapping.allowsLoadUri(url, inetAddress));
    }

    public String name() {
        return MessageUtil.restrictedMode((String)this.original.name(), (String)this.wrapping.name());
    }

    private static PropertySelection combinePropertySelections(PropertySelection originalSelection, PropertySelection wrappingSelection) {
        int i;
        MutableIntSet union = IntSets.mutable.empty();
        for (i = 0; i < originalSelection.numberOfKeys(); ++i) {
            union.add(originalSelection.key(i));
        }
        for (i = 0; i < wrappingSelection.numberOfKeys(); ++i) {
            union.add(wrappingSelection.key(i));
        }
        return PropertySelection.selection((int[])union.toArray());
    }
}

