/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.state;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.function.Consumer;
import org.eclipse.collections.api.block.function.Function0;
import org.eclipse.collections.api.block.procedure.Procedure2;
import org.eclipse.collections.api.block.procedure.primitive.IntProcedure;
import org.eclipse.collections.api.block.procedure.primitive.LongObjectProcedure;
import org.eclipse.collections.api.block.procedure.primitive.LongProcedure;
import org.eclipse.collections.api.map.MutableMap;
import org.eclipse.collections.api.map.primitive.MutableIntObjectMap;
import org.eclipse.collections.api.map.primitive.MutableLongObjectMap;
import org.eclipse.collections.api.set.primitive.LongSet;
import org.eclipse.collections.api.set.primitive.MutableIntSet;
import org.eclipse.collections.impl.UnmodifiableMap;
import org.neo4j.collection.diffset.ChangeCountingDiffSet;
import org.neo4j.collection.diffset.DiffSets;
import org.neo4j.collection.diffset.IntDiffSets;
import org.neo4j.collection.diffset.LongDiffSets;
import org.neo4j.collection.diffset.MutableDiffSets;
import org.neo4j.collection.diffset.MutableIntDiffSets;
import org.neo4j.collection.diffset.MutableLongDiffSets;
import org.neo4j.collection.diffset.RemovalsCountingDiffSets;
import org.neo4j.collection.diffset.TrackableDiffSets;
import org.neo4j.collection.factory.CollectionsFactory;
import org.neo4j.collection.factory.OnHeapCollectionsFactory;
import org.neo4j.collection.trackable.HeapTrackingArrayList;
import org.neo4j.collection.trackable.HeapTrackingCollections;
import org.neo4j.exceptions.KernelException;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.kernel.api.Upgrade;
import org.neo4j.internal.kernel.api.exceptions.DeletedNodeStillHasRelationshipsException;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptorPredicates;
import org.neo4j.internal.schema.SchemaDescriptors;
import org.neo4j.internal.schema.constraints.IndexBackedConstraintDescriptor;
import org.neo4j.kernel.api.txstate.TransactionState;
import org.neo4j.kernel.impl.api.chunk.ChunkedTransactionSink;
import org.neo4j.kernel.impl.api.state.NodeStateImpl;
import org.neo4j.kernel.impl.api.state.RelationshipStateImpl;
import org.neo4j.kernel.impl.api.state.StateNodeRelationshipIds;
import org.neo4j.kernel.impl.api.state.TokenState;
import org.neo4j.kernel.impl.transaction.tracing.TransactionEvent;
import org.neo4j.memory.DefaultScopedMemoryTracker;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.memory.ScopedMemoryTracker;
import org.neo4j.storageengine.api.RelationshipDirection;
import org.neo4j.storageengine.api.RelationshipVisitor;
import org.neo4j.storageengine.api.RelationshipVisitorWithProperties;
import org.neo4j.storageengine.api.enrichment.ApplyEnrichmentStrategy;
import org.neo4j.storageengine.api.enrichment.EnrichmentMode;
import org.neo4j.storageengine.api.txstate.EntityChange;
import org.neo4j.storageengine.api.txstate.NodeState;
import org.neo4j.storageengine.api.txstate.RelationshipModifications;
import org.neo4j.storageengine.api.txstate.RelationshipState;
import org.neo4j.storageengine.api.txstate.TransactionStateBehaviour;
import org.neo4j.storageengine.api.txstate.TxStateVisitor;
import org.neo4j.util.VisibleForTesting;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueTuple;
import org.neo4j.values.storable.Values;

public class TxState
implements TransactionState {
    private static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(TxState.class);
    private final CollectionsFactory collectionsFactory;
    private MutableIntObjectMap<MutableLongDiffSets> labelStatesMap;
    private MutableLongObjectMap<NodeStateImpl> nodeStatesMap;
    private MutableLongObjectMap<MutableLongDiffSets> relationshipTypeStatesMap;
    private MutableLongObjectMap<RelationshipStateImpl> relationshipStatesMap;
    private MutableLongObjectMap<TokenState> createdLabelTokens;
    private MutableLongObjectMap<TokenState> createdPropertyKeyTokens;
    private MutableLongObjectMap<TokenState> createdRelationshipTypeTokens;
    private MutableDiffSets<IndexDescriptor> indexChanges;
    private MutableDiffSets<ConstraintDescriptor> constraintsChanges;
    private RemovalsCountingDiffSets nodes;
    private ChangeCountingDiffSet relationships;
    private MutableMap<IndexBackedConstraintDescriptor, IndexDescriptor> createdConstraintIndexesByConstraint;
    private MutableMap<IndexDescriptor, Map<ValueTuple, MutableLongDiffSets>> indexUpdates;
    private Upgrade.KernelUpgrade upgrade;
    private final ScopedMemoryTracker stateMemoryTracker;
    private final TransactionStateBehaviour behaviour;
    private final ApplyEnrichmentStrategy enrichmentStrategy;
    private final ChunkedTransactionSink chunkWriter;
    private long revision;
    private long dataRevision;
    private final TransactionEvent transactionEvent;
    private boolean isMultiChunk;

    @VisibleForTesting
    public TxState() {
        this(OnHeapCollectionsFactory.INSTANCE, (MemoryTracker)EmptyMemoryTracker.INSTANCE, TransactionStateBehaviour.DEFAULT_BEHAVIOUR, ApplyEnrichmentStrategy.NO_ENRICHMENT, ChunkedTransactionSink.EMPTY, TransactionEvent.NULL);
    }

    public TxState(CollectionsFactory collectionsFactory, MemoryTracker transactionTracker, TransactionStateBehaviour behaviour, ApplyEnrichmentStrategy enrichmentStrategy, ChunkedTransactionSink chunkWriter, TransactionEvent transactionEvent) {
        transactionTracker.allocateHeap(SHALLOW_SIZE);
        this.chunkWriter = chunkWriter;
        this.collectionsFactory = collectionsFactory;
        this.stateMemoryTracker = new DefaultScopedMemoryTracker(transactionTracker);
        this.behaviour = behaviour;
        this.enrichmentStrategy = enrichmentStrategy;
        this.transactionEvent = transactionEvent;
    }

    public void accept(TxStateVisitor visitor) throws KernelException {
        if (this.nodes != null) {
            this.nodes.getAdded().each(arg_0 -> ((TxStateVisitor)visitor).visitCreatedNode(arg_0));
        }
        if (this.relationships != null) {
            try (final HeapTrackingArrayList sortedNodeRelState = HeapTrackingArrayList.newArrayList((int)this.nodeStatesMap.size(), (MemoryTracker)this.stateMemoryTracker);){
                for (NodeStateImpl nodeState : this.nodeStatesMap.values()) {
                    if (nodeState.isDeleted() && nodeState.hasAddedRelationships()) {
                        if (nodeState.isAddedInThisBatch()) {
                            throw DeletedNodeStillHasRelationshipsException.nodeCreatedInThisTxStillHasRelationships();
                        }
                        throw DeletedNodeStillHasRelationshipsException.nodeStillHasRelationships((long)nodeState.getId());
                    }
                    if (nodeState.isDeleted() && nodeState.isAddedInThisBatch() || !nodeState.hasRelationshipChanges()) continue;
                    sortedNodeRelState.add((Object)StateNodeRelationshipIds.createStateNodeRelationshipIds(nodeState, this::relationshipVisitWithProperties, (MemoryTracker)this.stateMemoryTracker));
                }
                sortedNodeRelState.sort(Comparator.comparingLong(RelationshipModifications.NodeRelationshipIds::nodeId));
                visitor.visitRelationshipModifications(new RelationshipModifications(){

                    public void forEachSplit(RelationshipModifications.IdsVisitor visitor) {
                        sortedNodeRelState.forEach((Consumer)visitor);
                    }

                    public RelationshipModifications.RelationshipBatch creations() {
                        return RelationshipModifications.idsAsBatch((LongSet)TxState.this.relationships.getAdded(), TxState.this::relationshipVisitWithProperties);
                    }

                    public RelationshipModifications.RelationshipBatch deletions() {
                        if (TxState.this.behaviour.keepMetaDataForDeletedRelationship()) {
                            return RelationshipModifications.idsAsBatch((LongSet)TxState.this.relationships.getRemoved(), TxState.this::deletedRelationshipVisit);
                        }
                        return RelationshipModifications.idsAsBatch((LongSet)TxState.this.relationships.getRemoved());
                    }

                    public RelationshipModifications.RelationshipBatch updates() {
                        return RelationshipModifications.idsAsBatch((LongSet)TxState.this.relationships.getChanged(), TxState.this::relationshipVisitWithProperties);
                    }
                });
            }
        }
        if (this.nodes != null) {
            this.nodes.getRemoved().each(arg_0 -> ((TxStateVisitor)visitor).visitDeletedNode(arg_0));
        }
        for (NodeState node : this.modifiedNodes()) {
            IntDiffSets labelDiffSets;
            if (node.hasPropertyChanges()) {
                visitor.visitNodePropertyChanges(node.getId(), node.addedProperties(), node.changedProperties(), node.removedProperties());
            }
            if ((labelDiffSets = node.labelDiffSets()).isEmpty()) continue;
            visitor.visitNodeLabelChanges(node.getId(), labelDiffSets.getAdded(), labelDiffSets.getRemoved());
        }
        if (this.indexChanges != null) {
            for (IndexDescriptor indexDescriptor2 : this.indexChanges.getAdded()) {
                visitor.visitAddedIndex(indexDescriptor2);
            }
            this.indexChanges.getRemoved().forEach(arg_0 -> ((TxStateVisitor)visitor).visitRemovedIndex(arg_0));
        }
        if (this.constraintsChanges != null) {
            for (ConstraintDescriptor added : this.constraintsChanges.getAdded()) {
                visitor.visitAddedConstraint(added);
            }
            this.constraintsChanges.getRemoved().forEach(arg_0 -> ((TxStateVisitor)visitor).visitRemovedConstraint(arg_0));
        }
        if (this.createdLabelTokens != null) {
            this.createdLabelTokens.forEachKeyValue((LongObjectProcedure & Serializable)(id, token) -> visitor.visitCreatedLabelToken(id, token.name, token.internal));
        }
        if (this.createdPropertyKeyTokens != null) {
            this.createdPropertyKeyTokens.forEachKeyValue((LongObjectProcedure & Serializable)(id, token) -> visitor.visitCreatedPropertyKeyToken(id, token.name, token.internal));
        }
        if (this.createdRelationshipTypeTokens != null) {
            this.createdRelationshipTypeTokens.forEachKeyValue((LongObjectProcedure & Serializable)(id, token) -> visitor.visitCreatedRelationshipTypeToken(id, token.name, token.internal));
        }
        if (this.behaviour.useIndexCommands() && this.indexUpdates != null) {
            this.indexUpdates.forEachKeyValue((Procedure2 & Serializable)(indexDescriptor, changes) -> changes.forEach((values, entityChanges) -> {
                entityChanges.getAdded().forEach((LongProcedure & Serializable)entityId -> visitor.visitValueIndexUpdate(indexDescriptor, entityId, values, EntityChange.ADDED));
                entityChanges.getRemoved().forEach((LongProcedure & Serializable)entityId -> visitor.visitValueIndexUpdate(indexDescriptor, entityId, values, EntityChange.REMOVED));
            }));
        }
        if (this.upgrade != null) {
            visitor.visitKernelUpgrade(this.upgrade);
        }
    }

    public boolean hasChanges() {
        return this.revision != 0L;
    }

    public boolean hasDataChanges() {
        return this.getDataRevision() != 0L;
    }

    public EnrichmentMode enrichmentMode() {
        return this.enrichmentStrategy.check();
    }

    public void reset() {
        this.labelStatesMap = null;
        this.nodeStatesMap = null;
        this.relationshipTypeStatesMap = null;
        this.relationshipStatesMap = null;
        this.createdLabelTokens = null;
        this.createdPropertyKeyTokens = null;
        this.createdRelationshipTypeTokens = null;
        this.indexChanges = null;
        this.constraintsChanges = null;
        this.nodes = null;
        this.relationships = null;
        this.createdConstraintIndexesByConstraint = null;
        this.indexUpdates = null;
        this.collectionsFactory.release();
        this.stateMemoryTracker.reset();
    }

    public Iterable<NodeState> modifiedNodes() {
        if (this.nodeStatesMap == null) {
            return Iterables.empty();
        }
        Collection nodeStates = this.nodeStatesMap.values();
        return Iterables.cast((Iterable)Iterables.filter(ns -> !ns.isDeleted(), (Iterable)nodeStates));
    }

    @VisibleForTesting
    MutableLongDiffSets getOrCreateLabelStateNodeDiffSets(int labelId) {
        if (this.labelStatesMap == null) {
            this.labelStatesMap = HeapTrackingCollections.newIntObjectHashMap((MemoryTracker)this.stateMemoryTracker);
        }
        return (MutableLongDiffSets)this.labelStatesMap.getIfAbsentPut(labelId, (Function0 & Serializable)() -> TrackableDiffSets.newMutableLongDiffSets((CollectionsFactory)this.collectionsFactory, (MemoryTracker)this.stateMemoryTracker));
    }

    private LongDiffSets getLabelStateNodeDiffSets(int labelId) {
        if (this.labelStatesMap == null) {
            return LongDiffSets.EMPTY;
        }
        LongDiffSets nodeDiffSets = (LongDiffSets)this.labelStatesMap.get(labelId);
        return nodeDiffSets == null ? LongDiffSets.EMPTY : nodeDiffSets;
    }

    @VisibleForTesting
    MutableLongDiffSets getOrCreateTypeStateRelationshipDiffSets(int relationshipType) {
        if (this.relationshipTypeStatesMap == null) {
            this.relationshipTypeStatesMap = HeapTrackingCollections.newLongObjectMap((MemoryTracker)this.stateMemoryTracker);
        }
        return (MutableLongDiffSets)this.relationshipTypeStatesMap.getIfAbsentPut((long)relationshipType, (Function0 & Serializable)() -> TrackableDiffSets.newMutableLongDiffSets((CollectionsFactory)this.collectionsFactory, (MemoryTracker)this.stateMemoryTracker));
    }

    public IntDiffSets nodeStateLabelDiffSets(long nodeId) {
        return this.getNodeState(nodeId).labelDiffSets();
    }

    private MutableIntDiffSets getOrCreateNodeStateLabelDiffSets(long nodeId) {
        return this.getOrCreateNodeState(nodeId).getOrCreateLabelDiffSets();
    }

    public boolean nodeIsAddedInThisBatch(long nodeId) {
        return this.nodes != null && this.nodes.isAdded(nodeId);
    }

    public boolean relationshipIsAddedInThisBatch(long relationshipId) {
        return this.relationships != null && this.relationships.isAdded(relationshipId);
    }

    private void changed() {
        ++this.revision;
    }

    private void dataChanged() {
        this.changed();
        this.dataRevision = this.revision;
        this.checkChunk();
    }

    private void checkChunk() {
        this.chunkWriter.write(this, this.transactionEvent);
    }

    public void nodeDoCreate(long id) {
        this.nodes().add(id);
        this.dataChanged();
    }

    public void nodeDoDelete(long nodeId) {
        NodeStateImpl nodeState;
        this.nodes().remove(nodeId);
        if (this.nodeStatesMap != null && (nodeState = (NodeStateImpl)this.nodeStatesMap.get(nodeId)) != null) {
            IntDiffSets diff = nodeState.labelDiffSets();
            diff.getAdded().each((IntProcedure & Serializable)label -> this.getOrCreateLabelStateNodeDiffSets(label).remove(nodeId));
            nodeState.markAsDeleted();
        }
        this.dataChanged();
    }

    public void relationshipDoCreate(long id, int relationshipTypeId, long startNodeId, long endNodeId) {
        this.relationships().add(id);
        if (startNodeId == endNodeId) {
            this.getOrCreateNodeState(startNodeId).addRelationship(id, relationshipTypeId, RelationshipDirection.LOOP);
        } else {
            this.getOrCreateNodeState(startNodeId).addRelationship(id, relationshipTypeId, RelationshipDirection.OUTGOING);
            this.getOrCreateNodeState(endNodeId).addRelationship(id, relationshipTypeId, RelationshipDirection.INCOMING);
        }
        this.getOrCreateRelationshipState(id, relationshipTypeId, startNodeId, endNodeId).setCreated();
        this.getOrCreateTypeStateRelationshipDiffSets(relationshipTypeId).add(id);
        this.dataChanged();
    }

    public boolean nodeIsModifiedInThisBatch(long nodeId) {
        if (this.nodeStatesMap == null) {
            return false;
        }
        NodeStateImpl nodeState = (NodeStateImpl)this.nodeStatesMap.get(nodeId);
        return nodeState != null && !nodeState.isAddedInThisBatch() && !nodeState.isDeleted() && (!nodeState.labelDiffSets().isEmpty() || nodeState.hasPropertyChanges());
    }

    public boolean nodeIsDeletedInThisBatch(long nodeId) {
        return this.nodes != null && this.nodes.wasRemoved(nodeId);
    }

    public void relationshipDoDelete(long id, int type, long startNodeId, long endNodeId) {
        ChangeCountingDiffSet relationships = this.relationships();
        boolean wasAddedInThisBatch = relationships.isAdded(id);
        relationships.remove(id);
        if (startNodeId == endNodeId) {
            this.getOrCreateNodeState(startNodeId).removeRelationship(id, type, RelationshipDirection.LOOP);
        } else {
            this.getOrCreateNodeState(startNodeId).removeRelationship(id, type, RelationshipDirection.OUTGOING);
            this.getOrCreateNodeState(endNodeId).removeRelationship(id, type, RelationshipDirection.INCOMING);
        }
        if (wasAddedInThisBatch || !this.behaviour.keepMetaDataForDeletedRelationship()) {
            RelationshipStateImpl removed;
            if (this.relationshipStatesMap != null && (removed = (RelationshipStateImpl)this.relationshipStatesMap.remove(id)) != null) {
                removed.clear();
            }
        } else {
            this.getOrCreateRelationshipState(id, type, startNodeId, endNodeId).setDeleted();
        }
        this.getOrCreateTypeStateRelationshipDiffSets(type).remove(id);
        this.dataChanged();
    }

    public void relationshipDoDeleteAddedInThisBatch(long relationshipId) {
        this.getRelationshipState(relationshipId).accept(this::relationshipDoDelete);
    }

    public boolean relationshipIsDeletedInThisBatch(long relationshipId) {
        return this.relationships != null && this.relationships.wasRemoved(relationshipId);
    }

    public void nodeDoAddProperty(long nodeId, int newPropertyKeyId, Value value) {
        NodeStateImpl nodeState = this.getOrCreateNodeState(nodeId);
        nodeState.addProperty(newPropertyKeyId, value);
        this.dataChanged();
    }

    public void nodeDoChangeProperty(long nodeId, int propertyKeyId, Value newValue) {
        this.getOrCreateNodeState(nodeId).changeProperty(propertyKeyId, newValue);
        this.dataChanged();
    }

    public void relationshipDoReplaceProperty(long relationshipId, int type, long startNode, long endNode, int propertyKeyId, Value replacedValue, Value newValue) {
        RelationshipStateImpl relationshipState = this.getOrCreateRelationshipState(relationshipId, type, startNode, endNode);
        if (replacedValue != Values.NO_VALUE) {
            relationshipState.changeProperty(propertyKeyId, newValue);
        } else {
            relationshipState.addProperty(propertyKeyId, newValue);
        }
        this.updateRelationship(relationshipId, type, startNode, endNode, relationshipState);
        this.dataChanged();
    }

    public void nodeDoRemoveProperty(long nodeId, int propertyKeyId) {
        this.getOrCreateNodeState(nodeId).removeProperty(propertyKeyId);
        this.dataChanged();
    }

    public void relationshipDoRemoveProperty(long relationshipId, int type, long startNode, long endNode, int propertyKeyId) {
        RelationshipStateImpl relationshipState = this.getOrCreateRelationshipState(relationshipId, type, startNode, endNode);
        relationshipState.removeProperty(propertyKeyId);
        this.updateRelationship(relationshipId, type, startNode, endNode, relationshipState);
        this.dataChanged();
    }

    private void updateRelationship(long relationshipId, int type, long startNode, long endNode, RelationshipStateImpl relationshipState) {
        if (!relationshipState.isCreated() && !relationshipState.isDeleted()) {
            boolean hasPropertyChanges = relationshipState.hasPropertyChanges();
            if (startNode == endNode) {
                this.getOrCreateNodeState(startNode).updateRelationship(relationshipId, type, RelationshipDirection.LOOP, hasPropertyChanges);
            } else {
                this.getOrCreateNodeState(startNode).updateRelationship(relationshipId, type, RelationshipDirection.OUTGOING, hasPropertyChanges);
                this.getOrCreateNodeState(endNode).updateRelationship(relationshipId, type, RelationshipDirection.INCOMING, hasPropertyChanges);
            }
            if (hasPropertyChanges) {
                this.relationships().change(relationshipId);
            } else {
                this.relationships().unchange(relationshipId);
                this.relationshipStatesMap.remove(relationshipId);
            }
        }
    }

    public void nodeDoAddLabel(int labelId, long nodeId) {
        this.getOrCreateLabelStateNodeDiffSets(labelId).add(nodeId);
        this.getOrCreateNodeStateLabelDiffSets(nodeId).add(labelId);
        this.dataChanged();
    }

    public void nodeDoRemoveLabel(int labelId, long nodeId) {
        this.getOrCreateLabelStateNodeDiffSets(labelId).remove(nodeId);
        this.getOrCreateNodeStateLabelDiffSets(nodeId).remove(labelId);
        this.dataChanged();
    }

    public void labelDoCreateForName(String labelName, boolean internal, long id) {
        if (this.createdLabelTokens == null) {
            this.createdLabelTokens = HeapTrackingCollections.newLongObjectMap((MemoryTracker)this.stateMemoryTracker);
        }
        this.createdLabelTokens.put(id, (Object)TokenState.createTokenState(labelName, internal, (MemoryTracker)this.stateMemoryTracker));
        this.changed();
    }

    public void propertyKeyDoCreateForName(String propertyKeyName, boolean internal, int id) {
        if (this.createdPropertyKeyTokens == null) {
            this.createdPropertyKeyTokens = HeapTrackingCollections.newLongObjectMap((MemoryTracker)this.stateMemoryTracker);
        }
        this.createdPropertyKeyTokens.put((long)id, (Object)TokenState.createTokenState(propertyKeyName, internal, (MemoryTracker)this.stateMemoryTracker));
        this.changed();
    }

    public void relationshipTypeDoCreateForName(String labelName, boolean internal, int id) {
        if (this.createdRelationshipTypeTokens == null) {
            this.createdRelationshipTypeTokens = HeapTrackingCollections.newLongObjectMap((MemoryTracker)this.stateMemoryTracker);
        }
        this.createdRelationshipTypeTokens.put((long)id, (Object)TokenState.createTokenState(labelName, internal, (MemoryTracker)this.stateMemoryTracker));
        this.changed();
    }

    public NodeState getNodeState(long id) {
        if (this.nodeStatesMap == null) {
            return NodeStateImpl.EMPTY;
        }
        NodeStateImpl nodeState = (NodeStateImpl)this.nodeStatesMap.get(id);
        return nodeState == null || nodeState.isDeleted() ? NodeStateImpl.EMPTY : nodeState;
    }

    public RelationshipState getRelationshipState(long id) {
        if (this.relationshipStatesMap == null) {
            return RelationshipStateImpl.EMPTY;
        }
        RelationshipStateImpl relationshipState = (RelationshipStateImpl)this.relationshipStatesMap.get(id);
        return relationshipState == null || relationshipState.isDeleted() ? RelationshipStateImpl.EMPTY : relationshipState;
    }

    public RelationshipState getRelationshipStateEvenDeleted(long id) {
        if (this.relationshipStatesMap == null) {
            return RelationshipStateImpl.EMPTY;
        }
        RelationshipStateImpl relationshipState = (RelationshipStateImpl)this.relationshipStatesMap.get(id);
        return relationshipState == null ? RelationshipStateImpl.EMPTY : relationshipState;
    }

    public MutableIntSet augmentLabels(MutableIntSet labels, NodeState nodeState) {
        IntDiffSets labelDiffSets = nodeState.labelDiffSets();
        if (!labelDiffSets.isEmpty()) {
            labelDiffSets.getRemoved().forEach(arg_0 -> ((MutableIntSet)labels).remove(arg_0));
            labelDiffSets.getAdded().forEach(arg_0 -> ((MutableIntSet)labels).add(arg_0));
        }
        return labels;
    }

    public LongDiffSets nodesWithLabelChanged(int label) {
        return this.getLabelStateNodeDiffSets(label);
    }

    public void indexDoAdd(IndexDescriptor descriptor) {
        MutableDiffSets<IndexDescriptor> diff = this.indexChangesDiffSets();
        if (!diff.unRemove((Object)descriptor)) {
            diff.add((Object)descriptor);
        }
        this.changed();
    }

    public void indexDoDrop(IndexDescriptor index) {
        this.indexChangesDiffSets().remove((Object)index);
        this.changed();
    }

    public DiffSets<IndexDescriptor> indexDiffSetsByLabel(int labelId) {
        return this.indexChangesDiffSets().filterAdded(SchemaDescriptorPredicates.hasLabel((int)labelId));
    }

    public DiffSets<IndexDescriptor> indexDiffSetsByRelationshipType(int relationshipType) {
        return this.indexChangesDiffSets().filterAdded(SchemaDescriptorPredicates.hasRelType((int)relationshipType));
    }

    public DiffSets<IndexDescriptor> indexDiffSetsBySchema(SchemaDescriptor schema) {
        return this.indexChangesDiffSets().filterAdded(indexDescriptor -> indexDescriptor.schema().equals((Object)schema));
    }

    public DiffSets<IndexDescriptor> indexChanges() {
        return DiffSets.Empty.ifNull(this.indexChanges);
    }

    private MutableDiffSets<IndexDescriptor> indexChangesDiffSets() {
        if (this.indexChanges == null) {
            this.indexChanges = TrackableDiffSets.newMutableDiffSets((MemoryTracker)this.stateMemoryTracker);
        }
        return this.indexChanges;
    }

    public LongDiffSets addedAndRemovedNodes() {
        return this.nodes == null ? LongDiffSets.EMPTY : this.nodes;
    }

    private RemovalsCountingDiffSets nodes() {
        if (this.nodes == null) {
            this.nodes = TrackableDiffSets.newRemovalsCountingDiffSets((CollectionsFactory)this.collectionsFactory, (MemoryTracker)this.stateMemoryTracker);
        }
        return this.nodes;
    }

    public LongDiffSets relationshipsWithTypeChanged(int type) {
        if (this.relationshipTypeStatesMap == null) {
            return LongDiffSets.EMPTY;
        }
        MutableLongDiffSets relationshipDiffSets = (MutableLongDiffSets)this.relationshipTypeStatesMap.get((long)type);
        return relationshipDiffSets == null ? LongDiffSets.EMPTY : relationshipDiffSets;
    }

    public LongDiffSets addedAndRemovedRelationships() {
        return this.relationships == null ? LongDiffSets.EMPTY : this.relationships;
    }

    private ChangeCountingDiffSet relationships() {
        if (this.relationships == null) {
            this.relationships = TrackableDiffSets.newChangeCountingDiffSets((CollectionsFactory)this.collectionsFactory, (MemoryTracker)this.stateMemoryTracker);
        }
        return this.relationships;
    }

    public Iterable<RelationshipState> modifiedRelationships() {
        return this.relationshipStatesMap == null ? Iterables.empty() : Iterables.cast((Iterable)Iterables.filter(rel -> !rel.isDeleted(), (Iterable)this.relationshipStatesMap.values()));
    }

    @VisibleForTesting
    NodeStateImpl getOrCreateNodeState(long nodeId) {
        if (this.nodeStatesMap == null) {
            this.nodeStatesMap = HeapTrackingCollections.newLongObjectMap((MemoryTracker)this.stateMemoryTracker);
        }
        return (NodeStateImpl)this.nodeStatesMap.getIfAbsentPut(nodeId, (Function0 & Serializable)() -> this.newNodeState(nodeId));
    }

    private RelationshipStateImpl getOrCreateRelationshipState(long relationshipId, int type, long startNode, long endNode) {
        if (this.relationshipStatesMap == null) {
            this.relationshipStatesMap = HeapTrackingCollections.newLongObjectMap((MemoryTracker)this.stateMemoryTracker);
        }
        return (RelationshipStateImpl)this.relationshipStatesMap.getIfAbsentPut(relationshipId, (Function0 & Serializable)() -> this.newRelationshipState(relationshipId, type, startNode, endNode));
    }

    private Iterable<RelationshipStateImpl> relState() {
        return this.relationshipStatesMap != null ? this.relationshipStatesMap.values() : Iterables.empty();
    }

    public void constraintDoAdd(IndexBackedConstraintDescriptor constraint, IndexDescriptor index) {
        this.constraintsChangesDiffSets().add((Object)constraint);
        if (index != null && index != IndexDescriptor.NO_INDEX) {
            this.createdConstraintIndexesByConstraint().put(constraint, index);
        }
        this.changed();
    }

    public void constraintDoAdd(ConstraintDescriptor constraint) {
        this.constraintsChangesDiffSets().add((Object)constraint);
        this.changed();
    }

    public DiffSets<ConstraintDescriptor> constraintsChangesForLabel(int labelId) {
        return this.constraintsChangesDiffSets().filterAdded(SchemaDescriptorPredicates.hasLabel((int)labelId));
    }

    public DiffSets<ConstraintDescriptor> constraintsChangesForSchema(SchemaDescriptor descriptor) {
        return this.constraintsChangesDiffSets().filterAdded(SchemaDescriptors.equalTo((SchemaDescriptor)descriptor));
    }

    public DiffSets<ConstraintDescriptor> constraintsChangesForRelationshipType(int relTypeId) {
        return this.constraintsChangesDiffSets().filterAdded(SchemaDescriptorPredicates.hasRelType((int)relTypeId));
    }

    public DiffSets<ConstraintDescriptor> constraintsChanges() {
        return DiffSets.Empty.ifNull(this.constraintsChanges);
    }

    private MutableDiffSets<ConstraintDescriptor> constraintsChangesDiffSets() {
        if (this.constraintsChanges == null) {
            this.constraintsChanges = TrackableDiffSets.newMutableDiffSets((MemoryTracker)this.stateMemoryTracker);
        }
        return this.constraintsChanges;
    }

    public void constraintDoDrop(ConstraintDescriptor constraint) {
        this.constraintsChangesDiffSets().remove((Object)constraint);
        this.changed();
    }

    public Iterator<IndexDescriptor> constraintIndexesCreatedInTx() {
        if (this.hasConstraintIndexesCreatedInTx()) {
            return this.createdConstraintIndexesByConstraint.values().iterator();
        }
        return Collections.emptyIterator();
    }

    public boolean hasConstraintIndexesCreatedInTx() {
        return this.createdConstraintIndexesByConstraint != null && !this.createdConstraintIndexesByConstraint.isEmpty();
    }

    public UnmodifiableMap<ValueTuple, ? extends LongDiffSets> getIndexUpdates(IndexDescriptor indexDescriptor) {
        if (this.indexUpdates == null) {
            return null;
        }
        Map updates = (Map)this.indexUpdates.get((Object)indexDescriptor);
        if (updates == null) {
            return null;
        }
        return new UnmodifiableMap(updates);
    }

    public NavigableMap<ValueTuple, ? extends LongDiffSets> getSortedIndexUpdates(IndexDescriptor descriptor) {
        TreeMap sortedUpdates;
        if (this.indexUpdates == null) {
            return null;
        }
        Map updates = (Map)this.indexUpdates.get((Object)descriptor);
        if (updates == null) {
            return null;
        }
        if (updates instanceof TreeMap) {
            sortedUpdates = (TreeMap)updates;
        } else {
            sortedUpdates = new TreeMap(ValueTuple.COMPARATOR);
            sortedUpdates.putAll(updates);
            this.indexUpdates.put((Object)descriptor, sortedUpdates);
        }
        return Collections.unmodifiableNavigableMap(sortedUpdates);
    }

    public void indexDoUpdateEntry(IndexDescriptor descriptor, long entityIdId, ValueTuple propertiesBefore, ValueTuple propertiesAfter) {
        Map<ValueTuple, MutableLongDiffSets> updates = this.getOrCreateIndexUpdatesByDescriptor(descriptor);
        if (propertiesBefore != null) {
            MutableLongDiffSets before = this.getOrCreateIndexUpdatesForSeek(updates, propertiesBefore);
            before.remove(entityIdId);
        }
        if (propertiesAfter != null) {
            MutableLongDiffSets after = this.getOrCreateIndexUpdatesForSeek(updates, propertiesAfter);
            after.add(entityIdId);
        }
    }

    public void kernelDoUpgrade(Upgrade.KernelUpgrade kernelUpgrade) {
        assert (this.upgrade == null);
        this.upgrade = kernelUpgrade;
        this.changed();
    }

    public MemoryTracker memoryTracker() {
        return this.stateMemoryTracker;
    }

    @VisibleForTesting
    MutableLongDiffSets getOrCreateIndexUpdatesForSeek(Map<ValueTuple, MutableLongDiffSets> updates, ValueTuple values) {
        return updates.computeIfAbsent(values, value -> TrackableDiffSets.newMutableLongDiffSets((CollectionsFactory)this.collectionsFactory, (MemoryTracker)this.stateMemoryTracker));
    }

    private Map<ValueTuple, MutableLongDiffSets> getOrCreateIndexUpdatesByDescriptor(IndexDescriptor indexDescriptor) {
        if (this.indexUpdates == null) {
            this.indexUpdates = HeapTrackingCollections.newMap((MemoryTracker)this.stateMemoryTracker);
        }
        return (Map)this.indexUpdates.getIfAbsentPut((Object)indexDescriptor, (Function0 & Serializable)() -> HeapTrackingCollections.newMap((MemoryTracker)this.stateMemoryTracker));
    }

    private Map<IndexBackedConstraintDescriptor, IndexDescriptor> createdConstraintIndexesByConstraint() {
        if (this.createdConstraintIndexesByConstraint == null) {
            this.createdConstraintIndexesByConstraint = HeapTrackingCollections.newMap((MemoryTracker)this.stateMemoryTracker);
        }
        return this.createdConstraintIndexesByConstraint;
    }

    public <EX extends Exception> boolean relationshipVisit(long relId, RelationshipVisitor<EX> visitor) throws EX {
        return this.getRelationshipState(relId).accept(visitor);
    }

    public <EX extends Exception> boolean relationshipVisitWithProperties(long relId, RelationshipVisitorWithProperties<EX> visitor) throws EX {
        return this.getRelationshipState(relId).accept(visitor);
    }

    public <EX extends Exception> boolean deletedRelationshipVisit(long relId, RelationshipVisitorWithProperties<EX> visitor) throws EX {
        return this.getRelationshipStateEvenDeleted(relId).accept(visitor);
    }

    public void markAsMultiChunk() {
        this.isMultiChunk = true;
    }

    public boolean isMultiChunk() {
        return this.isMultiChunk;
    }

    public long getDataRevision() {
        return this.dataRevision;
    }

    private NodeStateImpl newNodeState(long nodeId) {
        return NodeStateImpl.createNodeState(nodeId, this.nodeIsAddedInThisBatch(nodeId), this.collectionsFactory, (MemoryTracker)this.stateMemoryTracker);
    }

    private RelationshipStateImpl newRelationshipState(long relationshipId, int type, long startNode, long endNode) {
        return RelationshipStateImpl.createRelationshipStateImpl(relationshipId, type, startNode, endNode, this.collectionsFactory, (MemoryTracker)this.stateMemoryTracker);
    }
}

