/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.function.Supplier;
import org.eclipse.collections.api.factory.primitive.IntObjectMaps;
import org.eclipse.collections.api.map.primitive.IntObjectMap;
import org.eclipse.collections.api.map.primitive.MutableIntObjectMap;
import org.neo4j.internal.kernel.api.security.SelectedPropertiesProvider;
import org.neo4j.kernel.impl.newapi.InternalCursorFactory;
import org.neo4j.storageengine.api.PropertySelection;
import org.neo4j.storageengine.api.StorageEntityCursor;
import org.neo4j.storageengine.api.StorageProperty;
import org.neo4j.storageengine.api.StoragePropertyCursor;
import org.neo4j.values.storable.Value;

class AccessControlPropertiesProvider
implements SelectedPropertiesProvider,
AutoCloseable {
    private final StorageEntityCursor storeCursor;
    private final InternalCursorFactory internalCursors;
    private final boolean applyAccessModeToTxState;
    private final Supplier<Iterable<StorageProperty>> txStateProperties;
    private StoragePropertyCursor propertyCursor;

    public AccessControlPropertiesProvider(StorageEntityCursor storeCursor, InternalCursorFactory internalCursors, boolean applyAccessModeToTxState, Supplier<Iterable<StorageProperty>> txStateProperties) {
        this.storeCursor = storeCursor;
        this.internalCursors = internalCursors;
        this.applyAccessModeToTxState = applyAccessModeToTxState;
        this.txStateProperties = txStateProperties;
    }

    public IntObjectMap<Value> get(PropertySelection properties) {
        MutableIntObjectMap result = IntObjectMaps.mutable.empty();
        this.fillFromStorage(this.storeCursor, properties, (MutableIntObjectMap<Value>)result);
        this.fillFromTxState(properties, (MutableIntObjectMap<Value>)result);
        return result;
    }

    private void fillFromTxState(PropertySelection propertySelection, MutableIntObjectMap<Value> result) {
        if (this.applyAccessModeToTxState) {
            Iterable<StorageProperty> txStateChangedProperties = this.txStateProperties.get();
            for (StorageProperty changedProperty : txStateChangedProperties) {
                if (!propertySelection.test(changedProperty.propertyKeyId())) continue;
                result.put(changedProperty.propertyKeyId(), (Object)changedProperty.value());
            }
        }
    }

    private void fillFromStorage(StorageEntityCursor storageCursor, PropertySelection propertySelection, MutableIntObjectMap<Value> result) {
        StoragePropertyCursor propertyCursor = this.getPropertyCursor();
        storageCursor.properties(propertyCursor, propertySelection);
        while (propertyCursor.next()) {
            result.put(propertyCursor.propertyKey(), (Object)propertyCursor.propertyValue());
        }
    }

    private StoragePropertyCursor getPropertyCursor() {
        if (this.propertyCursor == null) {
            this.propertyCursor = this.internalCursors.allocateStoragePropertyCursor();
        }
        return this.propertyCursor;
    }

    @Override
    public void close() {
        if (this.propertyCursor != null) {
            this.propertyCursor.close();
            this.propertyCursor = null;
        }
    }
}

