/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import org.eclipse.collections.api.iterator.LongIterator;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.RelationshipCursor;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.internal.kernel.api.security.SelectedPropertiesProvider;
import org.neo4j.kernel.api.AccessModeProvider;
import org.neo4j.kernel.api.txstate.TxStateHolder;
import org.neo4j.kernel.impl.newapi.AccessControlPropertiesProvider;
import org.neo4j.kernel.impl.newapi.CursorPool;
import org.neo4j.kernel.impl.newapi.DefaultNodeCursor;
import org.neo4j.kernel.impl.newapi.DefaultPropertyCursor;
import org.neo4j.kernel.impl.newapi.InternalCursorFactory;
import org.neo4j.kernel.impl.newapi.TraceableCursorImpl;
import org.neo4j.storageengine.api.LongReference;
import org.neo4j.storageengine.api.PropertySelection;
import org.neo4j.storageengine.api.Reference;
import org.neo4j.storageengine.api.StorageEntityCursor;
import org.neo4j.storageengine.api.StorageProperty;
import org.neo4j.storageengine.api.StorageRelationshipCursor;

abstract class DefaultRelationshipCursor<SELF extends DefaultRelationshipCursor<?>>
extends TraceableCursorImpl<SELF>
implements RelationshipCursor {
    private final StorageRelationshipCursor storeCursor;
    protected final boolean applyAccessModeToTxState;
    private final InternalCursorFactory internalCursors;
    protected Read read;
    private TxStateHolder txStateHolder;
    private boolean hasChanges;
    private boolean checkHasChanges;
    private LongIterator addedRelationships;
    long currentAddedInTx = -1L;
    private int txStateTypeId;
    protected long txStateSourceNodeReference;
    protected long txStateTargetNodeReference;
    private AccessModeProvider accessModeProvider;
    private AccessMode accessMode;
    private boolean allowAllRelationships;
    protected boolean allowAllNodes;
    private AccessControlPropertiesProvider accessControlPropertiesProvider;
    private DefaultNodeCursor securityNodeCursor;

    DefaultRelationshipCursor(StorageRelationshipCursor storeCursor, CursorPool<SELF> pool, boolean applyAccessModeToTxState, InternalCursorFactory internalCursors) {
        super(pool);
        this.storeCursor = storeCursor;
        this.applyAccessModeToTxState = applyAccessModeToTxState;
        this.internalCursors = internalCursors;
    }

    protected void init(Read read, TxStateHolder txStateHolder, AccessModeProvider accessModeProvider) {
        this.currentAddedInTx = -1L;
        this.read = read;
        this.txStateHolder = txStateHolder;
        this.checkHasChanges = true;
        this.initAccessMode(accessModeProvider);
    }

    private void initAccessMode(AccessModeProvider accessModeProvider) {
        this.accessModeProvider = accessModeProvider;
        this.accessMode = accessModeProvider.getAccessMode();
        this.allowAllRelationships = this.accessMode.allowsTraverseAllRelTypes();
        this.allowAllNodes = this.accessMode.allowsTraverseAllLabels();
    }

    public boolean next() {
        boolean hasChanges = this.hasChanges();
        if (hasChanges) {
            while (this.addedRelationships.hasNext()) {
                long next = this.addedRelationships.next();
                this.collectTxStateData(next);
                if (this.applyAccessModeToTxState && !this.allowed() || this.filterOutTxStateRelationship()) continue;
                this.trace();
                return true;
            }
            this.currentAddedInTx = -1L;
        }
        while (this.storeCursor.next()) {
            if (this.deletedInThisBatch(hasChanges) || !this.allowed()) continue;
            this.maybeTraceStoreHit();
            return true;
        }
        return false;
    }

    protected void maybeTraceStoreHit() {
        this.trace();
    }

    private void collectTxStateData(long next) {
        this.txStateHolder.txState().relationshipVisit(next, (relationshipId, typeId, sourceNodeReference, targetNodeReference) -> {
            this.currentAddedInTx = relationshipId;
            this.txStateTypeId = typeId;
            this.txStateSourceNodeReference = sourceNodeReference;
            this.txStateTargetNodeReference = targetNodeReference;
        });
    }

    protected abstract boolean filterOutTxStateRelationship();

    private boolean deletedInThisBatch(boolean hasChanges) {
        return hasChanges && this.txStateHolder.txState().relationshipIsDeletedInThisBatch(this.storeCursor.entityReference());
    }

    private void trace() {
        if (this.tracer != null) {
            this.tracer.onRelationship(this.relationshipReference());
        }
    }

    protected boolean allowed() {
        assert (this.accessMode == this.accessModeProvider.getAccessMode()) : "access mode changed while cursor is in use";
        return this.allowedTraverseRelationship() && this.allowedToTraverseEndNodes();
    }

    private boolean allowedTraverseRelationship() {
        if (this.allowAllRelationships) {
            return true;
        }
        return this.accessMode.allowsTraverseRelationship(this.type(), (SelectedPropertiesProvider)this.getSelectedPropertiesProvider());
    }

    protected abstract boolean allowedToTraverseEndNodes();

    protected AccessControlPropertiesProvider getSelectedPropertiesProvider() {
        if (this.accessControlPropertiesProvider == null) {
            this.accessControlPropertiesProvider = new AccessControlPropertiesProvider((StorageEntityCursor)this.storeCursor, this.internalCursors, this.applyAccessModeToTxState, this::txStateProperties);
        }
        return this.accessControlPropertiesProvider;
    }

    private Iterable<StorageProperty> txStateProperties() {
        return this.txStateHolder.txState().getRelationshipState(this.relationshipReference()).addedAndChangedProperties();
    }

    protected DefaultNodeCursor getSecurityNodeCursor() {
        if (this.securityNodeCursor == null) {
            this.securityNodeCursor = this.internalCursors.allocateNodeCursor();
        }
        return this.securityNodeCursor;
    }

    public long relationshipReference() {
        return this.currentAddedInTx != -1L ? this.currentAddedInTx : this.storeCursor.entityReference();
    }

    public int type() {
        return this.currentAddedInTx != -1L ? this.txStateTypeId : this.storeCursor.type();
    }

    public void source(NodeCursor cursor) {
        this.read.singleNode(this.sourceNodeReference(), cursor);
    }

    public void target(NodeCursor cursor) {
        this.read.singleNode(this.targetNodeReference(), cursor);
    }

    public void properties(PropertyCursor cursor, PropertySelection selection) {
        ((DefaultPropertyCursor)cursor).initRelationship(selection, this.read, this.txStateHolder, this.accessModeProvider, this.storeCursor, this.currentRelationshipIsAddedInTx(), this.relationshipReference());
    }

    public long sourceNodeReference() {
        return this.currentAddedInTx != -1L ? this.txStateSourceNodeReference : this.storeCursor.sourceNodeReference();
    }

    public long targetNodeReference() {
        return this.currentAddedInTx != -1L ? this.txStateTargetNodeReference : this.storeCursor.targetNodeReference();
    }

    public Reference propertiesReference() {
        return this.currentAddedInTx != -1L ? LongReference.NULL_REFERENCE : this.storeCursor.propertiesReference();
    }

    protected boolean currentRelationshipIsAddedInTx() {
        return this.currentAddedInTx != -1L;
    }

    protected boolean hasChanges() {
        if (this.checkHasChanges) {
            this.hasChanges = this.txStateHolder.hasTxStateWithChanges();
            if (this.hasChanges) {
                this.addedRelationships = this.collectAddedTxStateSnapshot(this.txStateHolder);
            }
            this.checkHasChanges = false;
        }
        return this.hasChanges;
    }

    protected abstract LongIterator collectAddedTxStateSnapshot(TxStateHolder var1);

    protected void prepareChanges(LongIterator addedRelationships, boolean hasChanges) {
        this.addedRelationships = addedRelationships;
        this.hasChanges = hasChanges;
        this.checkHasChanges = false;
    }

    @Override
    public void release() {
        this.storeCursor.close();
        if (this.securityNodeCursor != null) {
            this.securityNodeCursor.close();
            this.securityNodeCursor.release();
            this.securityNodeCursor = null;
        }
        if (this.accessControlPropertiesProvider != null) {
            this.accessControlPropertiesProvider.close();
            this.accessControlPropertiesProvider = null;
        }
    }

    public boolean isClosed() {
        return this.read == null;
    }

    @Override
    public void closeInternal() {
        if (!this.isClosed()) {
            this.read = null;
            this.txStateHolder = null;
            this.accessModeProvider = null;
            this.storeCursor.reset();
            if (this.securityNodeCursor != null) {
                this.securityNodeCursor.close();
            }
            if (this.accessControlPropertiesProvider != null) {
                this.accessControlPropertiesProvider.close();
            }
        }
        super.closeInternal();
    }
}

