/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.Iterator;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.TokenRead;
import org.neo4j.internal.kernel.api.exceptions.LabelNotFoundKernelException;
import org.neo4j.internal.kernel.api.exceptions.PropertyKeyIdNotFoundKernelException;
import org.neo4j.internal.kernel.api.exceptions.RelationshipTypeIdNotFoundKernelException;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.kernel.api.AssertOpen;
import org.neo4j.kernel.impl.api.OverridableSecurityContext;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.token.TokenHolders;
import org.neo4j.token.api.NamedToken;
import org.neo4j.token.api.TokenNotFoundException;

public abstract class KernelTokenRead
implements TokenRead {
    private final StorageReader store;
    private final TokenHolders tokenHolders;

    KernelTokenRead(StorageReader store, TokenHolders tokenHolders) {
        this.store = store;
        this.tokenHolders = tokenHolders;
    }

    public String labelGetName(int labelId) {
        this.performCheckBeforeOperation();
        return this.tokenHolders.labelGetName(labelId);
    }

    public String relationshipTypeGetName(int relationshipTypeId) {
        this.performCheckBeforeOperation();
        return this.tokenHolders.relationshipTypeGetName(relationshipTypeId);
    }

    public String propertyKeyGetName(int propertyKeyId) {
        this.performCheckBeforeOperation();
        return this.tokenHolders.propertyKeyGetName(propertyKeyId);
    }

    public int nodeLabel(String name) {
        this.performCheckBeforeOperation();
        return this.tokenHolders.labelTokens().getIdByName(name);
    }

    public String nodeLabelName(int labelId) throws LabelNotFoundKernelException {
        this.performCheckBeforeOperation();
        try {
            return this.tokenHolders.labelTokens().getTokenById(labelId).name();
        }
        catch (TokenNotFoundException e) {
            throw LabelNotFoundKernelException.labelNotFound((int)labelId, (Exception)((Object)e));
        }
    }

    public int relationshipType(String name) {
        this.performCheckBeforeOperation();
        return this.tokenHolders.relationshipTypeTokens().getIdByName(name);
    }

    public String relationshipTypeName(int relationshipTypeId) throws RelationshipTypeIdNotFoundKernelException {
        this.performCheckBeforeOperation();
        try {
            return this.tokenHolders.relationshipTypeTokens().getTokenById(relationshipTypeId).name();
        }
        catch (TokenNotFoundException e) {
            throw RelationshipTypeIdNotFoundKernelException.relationshipTypeNotFound((int)relationshipTypeId, (Exception)((Object)e));
        }
    }

    public int propertyKey(String name) {
        this.performCheckBeforeOperation();
        return this.tokenHolders.propertyKeyTokens().getIdByName(name);
    }

    public String propertyKeyName(int propertyKeyId) throws PropertyKeyIdNotFoundKernelException {
        this.performCheckBeforeOperation();
        try {
            return this.tokenHolders.propertyKeyTokens().getTokenById(propertyKeyId).name();
        }
        catch (TokenNotFoundException e) {
            throw PropertyKeyIdNotFoundKernelException.propertyKeyIdNotFound((int)propertyKeyId, (Exception)((Object)e));
        }
    }

    public Iterator<NamedToken> labelsGetAllTokens() {
        this.performCheckBeforeOperation();
        return Iterators.stream(this.tokenHolders.labelTokens().getAllTokens().iterator()).filter(label -> this.getAccessMode().allowsTraverseNode(new int[]{label.id()}) || this.getAccessMode().hasApplicableTraverseNodeAllowPropertyRules(label.id())).iterator();
    }

    public Iterator<NamedToken> propertyKeyGetAllTokens() {
        this.performCheckBeforeOperation();
        return Iterators.stream(this.tokenHolders.propertyKeyTokens().getAllTokens().iterator()).filter(propKey -> this.getAccessMode().allowsSeePropertyKeyToken(propKey.id())).iterator();
    }

    public Iterator<NamedToken> relationshipTypesGetAllTokens() {
        this.performCheckBeforeOperation();
        return Iterators.stream(this.tokenHolders.relationshipTypeTokens().getAllTokens().iterator()).filter(relType -> this.getAccessMode().allowsTraverseRelType(relType.id())).iterator();
    }

    public int labelCount() {
        this.performCheckBeforeOperation();
        return this.store.labelCount();
    }

    public int propertyKeyCount() {
        this.performCheckBeforeOperation();
        return this.store.propertyKeyCount();
    }

    public int relationshipTypeCount() {
        this.performCheckBeforeOperation();
        return this.store.relationshipTypeCount();
    }

    abstract void performCheckBeforeOperation();

    abstract AccessMode getAccessMode();

    public static class ForThreadExecutionContextScope
    extends KernelTokenRead {
        private final OverridableSecurityContext overridableSecurityContext;
        private final AssertOpen assertOpen;

        public ForThreadExecutionContextScope(StorageReader store, TokenHolders tokenHolders, OverridableSecurityContext overridableSecurityContext, AssertOpen assertOpen) {
            super(store, tokenHolders);
            this.overridableSecurityContext = overridableSecurityContext;
            this.assertOpen = assertOpen;
        }

        @Override
        void performCheckBeforeOperation() {
            this.assertOpen.assertOpen();
        }

        @Override
        AccessMode getAccessMode() {
            return this.overridableSecurityContext.currentSecurityContext().mode();
        }
    }
}

