/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.entry;

import java.io.IOException;
import org.neo4j.io.fs.WritableChannel;
import org.neo4j.kernel.BinarySupportedKernelVersions;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.impl.transaction.CommittedCommandBatchRepresentation;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryFactory;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntrySerializationSet;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntrySerializationSets;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntrySerializer;
import org.neo4j.kernel.impl.transaction.log.entry.v57.LogEntryChunkEnd;
import org.neo4j.storageengine.api.CommandBatch;
import org.neo4j.storageengine.api.StorageCommand;
import org.neo4j.util.VisibleForTesting;

public class LogEntryWriter<T extends WritableChannel> {
    protected final T channel;
    private final BinarySupportedKernelVersions binarySupportedKernelVersions;
    private LogEntrySerializationSet logEntrySerializationSet;
    private KernelVersion currentVersion;

    public LogEntryWriter(T channel, BinarySupportedKernelVersions binarySupportedKernelVersions) {
        this.channel = channel;
        this.binarySupportedKernelVersions = binarySupportedKernelVersions;
    }

    public void writeStartEntry(KernelVersion kernelVersion, long timeWritten, long latestCommittedTxWhenStarted, long appendIndex, int previousChecksum, byte[] additionalHeaderData) throws IOException {
        this.updateSerializationSet(kernelVersion);
        this.logEntrySerializationSet.select((byte)1).write(this.channel, (LogEntry)LogEntryFactory.newStartEntry((KernelVersion)kernelVersion, (long)timeWritten, (long)latestCommittedTxWhenStarted, (long)appendIndex, (int)previousChecksum, (byte[])additionalHeaderData, null));
    }

    public void writeChunkStartEntry(KernelVersion kernelVersion, long timeWritten, long chunkId, long appendIndex, long previousBatchAppendIndex) throws IOException {
        this.updateSerializationSet(kernelVersion);
        this.logEntrySerializationSet.select((byte)10).write(this.channel, LogEntryFactory.newChunkStartEntry((KernelVersion)kernelVersion, (long)timeWritten, (long)chunkId, (long)appendIndex, (long)previousBatchAppendIndex));
    }

    public int writeChunkEndEntry(KernelVersion kernelVersion, long transactionId, long chunkId) throws IOException {
        this.updateSerializationSet(kernelVersion);
        return this.logEntrySerializationSet.select((byte)11).write(this.channel, (LogEntry)new LogEntryChunkEnd(kernelVersion, transactionId, chunkId, 0));
    }

    public int writeRollbackEntry(KernelVersion kernelVersion, long transactionId, long appendIndex, long timeWritten) throws IOException {
        this.updateSerializationSet(kernelVersion);
        return this.logEntrySerializationSet.select((byte)12).write(this.channel, (LogEntry)LogEntryFactory.newRollbackEntry((KernelVersion)kernelVersion, (long)transactionId, (long)appendIndex, (long)timeWritten));
    }

    public int writeCommitEntry(KernelVersion kernelVersion, long transactionId, long timeWritten) throws IOException {
        this.updateSerializationSet(kernelVersion);
        return this.logEntrySerializationSet.select((byte)5).write(this.channel, (LogEntry)LogEntryFactory.newCommitEntry((KernelVersion)kernelVersion, (long)transactionId, (long)timeWritten, (int)0));
    }

    public void serialize(CommandBatch batch) throws IOException {
        this.serialize((Iterable<StorageCommand>)batch, batch.kernelVersion());
    }

    public void serialize(CommittedCommandBatchRepresentation commandBatch) throws IOException {
        commandBatch.serialize(this);
    }

    public void serialize(Iterable<StorageCommand> commands, KernelVersion kernelVersion) throws IOException {
        this.updateSerializationSet(kernelVersion);
        this.logEntrySerializationSet.serialize(this.channel, commands, kernelVersion);
    }

    public void serialize(StorageCommand command, KernelVersion kernelVersion) throws IOException {
        this.updateSerializationSet(kernelVersion);
        LogEntrySerializer.writeLogEntryHeader((KernelVersion)kernelVersion, (byte)3, this.channel);
        assert (command.kernelVersion() == kernelVersion) : "Command serialization KernelVersion %s does not match tx KernelVersion %s".formatted(command.kernelVersion(), kernelVersion);
        command.serialize(this.channel);
    }

    @VisibleForTesting
    public T getChannel() {
        return this.channel;
    }

    private void updateSerializationSet(KernelVersion version) {
        if (version != this.currentVersion) {
            this.logEntrySerializationSet = LogEntrySerializationSets.serializationSet((KernelVersion)version, (BinarySupportedKernelVersions)this.binarySupportedKernelVersions);
            this.currentVersion = version;
        }
    }
}

