/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.query;

import org.neo4j.collection.Dependencies;
import org.neo4j.configuration.DatabaseConfig;
import org.neo4j.kernel.api.Kernel;
import org.neo4j.kernel.impl.query.NoQueryEngine;
import org.neo4j.kernel.impl.query.QueryExecutionEngine;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.monitoring.Monitors;
import org.neo4j.scheduler.JobScheduler;

public abstract class QueryEngineProvider {
    protected abstract QueryExecutionEngine createEngine(Dependencies var1, GraphDatabaseAPI var2, boolean var3, SPI var4);

    protected abstract int enginePriority();

    public static QueryExecutionEngine initialize(Dependencies deps, GraphDatabaseAPI graphAPI, QueryEngineProvider provider, boolean isSystemDatabase, SPI spi) {
        if (provider == null) {
            return QueryEngineProvider.noEngine();
        }
        QueryExecutionEngine engine = provider.createEngine(deps, graphAPI, isSystemDatabase, spi);
        return (QueryExecutionEngine)deps.satisfyDependency((Object)engine);
    }

    public static QueryExecutionEngine noEngine() {
        return NoQueryEngine.INSTANCE;
    }

    public static SPI spi(final InternalLogProvider logProvider, final Monitors monitors, final JobScheduler jobScheduler, final LifeSupport lifeSupport, final Kernel kernel, final DatabaseConfig databaseConfig) {
        return new SPI(){

            @Override
            public InternalLogProvider logProvider() {
                return logProvider;
            }

            @Override
            public Monitors monitors() {
                return monitors;
            }

            @Override
            public JobScheduler jobScheduler() {
                return jobScheduler;
            }

            @Override
            public LifeSupport lifeSupport() {
                return lifeSupport;
            }

            @Override
            public Kernel kernel() {
                return kernel;
            }

            @Override
            public DatabaseConfig databaseConfig() {
                return databaseConfig;
            }
        };
    }

    public static interface SPI {
        public InternalLogProvider logProvider();

        public Monitors monitors();

        public JobScheduler jobScheduler();

        public LifeSupport lifeSupport();

        public Kernel kernel();

        public DatabaseConfig databaseConfig();
    }
}

