/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.coreapi;

import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.kernel.impl.coreapi.DefaultTransactionExceptionMapper;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogAssertions;

class DefaultTransactionExceptionMapperTest {
    DefaultTransactionExceptionMapperTest() {
    }

    @Test
    void shouldUseCorrectGQLStatusForGenericFailure() {
        AssertableLogProvider assertableLogProvider = new AssertableLogProvider();
        RuntimeException exception = new RuntimeException("Generic failure");
        RuntimeException mappedException = DefaultTransactionExceptionMapper.INSTANCE.mapException((Exception)exception, (Log)assertableLogProvider.getLog("foo"));
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)mappedException).isInstanceOf(TransactionFailureException.class)).hasMessageContaining("Unable to complete transaction.");
        TransactionFailureException txFailureException = (TransactionFailureException)mappedException;
        Assertions.assertThat((String)txFailureException.gqlStatus()).isEqualTo("25N02");
        Assertions.assertThat((String)txFailureException.statusDescription()).isEqualTo("error: invalid transaction state - unable to complete transaction. Unable to complete transaction. See debug log for details.");
        LogAssertions.assertThat((AssertableLogProvider)assertableLogProvider).containsMessageWithException("Generic failure", (Throwable)exception);
    }
}

