/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.systemgraph;

import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.neo4j.configuration.helpers.RemoteUri;
import org.neo4j.configuration.helpers.SocketAddress;
import org.neo4j.configuration.helpers.SocketAddressParser;
import org.neo4j.dbms.systemgraph.DriverSettings;
import org.neo4j.dbms.systemgraph.ExternalDatabaseCredentials;
import org.neo4j.dbms.systemgraph.TopologyGraphDbmsModel;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.helpers.collection.Pair;
import org.neo4j.kernel.database.DatabaseIdFactory;
import org.neo4j.kernel.database.DatabaseReference;
import org.neo4j.kernel.database.DatabaseReferenceImpl;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.database.NormalizedDatabaseName;
import org.neo4j.logging.Level;
import org.neo4j.values.storable.DurationValue;

public final class CommunityTopologyGraphDbmsModelUtil {
    private CommunityTopologyGraphDbmsModelUtil() {
    }

    static Stream<DatabaseReferenceImpl.Internal> getAllPrimaryStandardDatabaseReferencesInRoot(Transaction tx) {
        return tx.findNodes(TopologyGraphDbmsModel.DATABASE_LABEL).stream().filter(node -> !node.hasProperty("virtual")).filter(node -> !node.hasLabel(TopologyGraphDbmsModel.SPD_LABEL)).filter(node -> !node.hasLabel(TopologyGraphDbmsModel.GRAPH_SHARD_LABEL)).filter(node -> !node.hasLabel(TopologyGraphDbmsModel.PROPERTY_SHARD_LABEL)).filter(node -> node.getDegree(TopologyGraphDbmsModel.IS_MIRROR_OF_RELATIONSHIP, Direction.OUTGOING) == 0).map(node -> new DatabaseReferenceImpl.Internal(new NormalizedDatabaseName(CommunityTopologyGraphDbmsModelUtil.getDatabaseId(node).name()), CommunityTopologyGraphDbmsModelUtil.getDatabaseId(node), true));
    }

    static NormalizedDatabaseName getNameProperty(String labelName, Node node) {
        return new NormalizedDatabaseName(CommunityTopologyGraphDbmsModelUtil.getPropertyOnNode(labelName, node, "name", String.class));
    }

    static TopologyGraphDbmsModel.DatabaseAccess getDatabaseAccess(Node databaseNode) {
        String accessString = (String)databaseNode.getProperty("access", (Object)TopologyGraphDbmsModel.DatabaseAccess.READ_WRITE.toString());
        return Enum.valueOf(TopologyGraphDbmsModel.DatabaseAccess.class, accessString);
    }

    public static Optional<DatabaseReferenceImpl.Internal> createInternalReference(Node alias, NamedDatabaseId targetedDatabase) {
        return CommunityTopologyGraphDbmsModelUtil.ignoreConcurrentDeletes(() -> {
            NormalizedDatabaseName aliasName = new NormalizedDatabaseName(CommunityTopologyGraphDbmsModelUtil.getPropertyOnNode(TopologyGraphDbmsModel.DATABASE_NAME, alias, "name", String.class));
            NormalizedDatabaseName namespace = new NormalizedDatabaseName(CommunityTopologyGraphDbmsModelUtil.getPropertyOnNode(TopologyGraphDbmsModel.DATABASE_NAME, alias, "namespace", String.class));
            Boolean primary = CommunityTopologyGraphDbmsModelUtil.getPropertyOnNode(TopologyGraphDbmsModel.DATABASE_NAME, alias, "primary", Boolean.class);
            return Optional.of(new DatabaseReferenceImpl.Internal(aliasName, namespace, targetedDatabase, primary));
        });
    }

    public static Optional<DatabaseReferenceImpl.GraphShard> createGraphShardReference(Node db, Map<Integer, DatabaseReferenceImpl.PropertyShard> propertyShards) {
        return CommunityTopologyGraphDbmsModelUtil.ignoreConcurrentDeletes(() -> CommunityTopologyGraphDbmsModelUtil.ignoreConcurrentDeletes(() -> {
            NamedDatabaseId databaseId = CommunityTopologyGraphDbmsModelUtil.getDatabaseId(db);
            String aliasName = (String)db.getProperty("name");
            String owningDatabase = CommunityTopologyGraphDbmsModelUtil.readGraphShardOwningDatabase(db).orElseThrow();
            return Optional.of(new DatabaseReferenceImpl.GraphShard(new NormalizedDatabaseName(aliasName), databaseId, owningDatabase, propertyShards));
        }));
    }

    public static Optional<DatabaseReferenceImpl.VirtualSPD> createVirtualSpdReference(Node alias, Node spdNode, NamedDatabaseId targetedDatabase) {
        return CommunityTopologyGraphDbmsModelUtil.ignoreConcurrentDeletes(() -> {
            NormalizedDatabaseName aliasName = new NormalizedDatabaseName(CommunityTopologyGraphDbmsModelUtil.getPropertyOnNode(TopologyGraphDbmsModel.DATABASE_NAME, alias, "name", String.class));
            NormalizedDatabaseName namespace = new NormalizedDatabaseName(CommunityTopologyGraphDbmsModelUtil.getPropertyOnNode(TopologyGraphDbmsModel.DATABASE_NAME, alias, "namespace", String.class));
            Boolean primary = CommunityTopologyGraphDbmsModelUtil.getPropertyOnNode(TopologyGraphDbmsModel.DATABASE_NAME, alias, "primary", Boolean.class);
            Node graphShardNode = spdNode.getSingleRelationship(TopologyGraphDbmsModel.HAS_GRAPH_SHARD, Direction.OUTGOING).getEndNode();
            Map<Integer, DatabaseReferenceImpl.PropertyShard> propertyShards = StreamSupport.stream(graphShardNode.getRelationships(Direction.OUTGOING, new RelationshipType[]{TopologyGraphDbmsModel.HAS_PROPERTY_SHARD}).spliterator(), false).flatMap(rel -> CommunityTopologyGraphDbmsModelUtil.createSPDPropertyShardReference(aliasName.name(), rel.getEndNode()).stream().map(ref -> Pair.of((Object)((Integer)rel.getProperty("index")), (Object)ref))).collect(Collectors.toMap(Pair::first, Pair::other));
            DatabaseReferenceImpl.GraphShard graphShard = CommunityTopologyGraphDbmsModelUtil.createGraphShardReference(graphShardNode, propertyShards).stream().toList().getFirst();
            return Optional.of(new DatabaseReferenceImpl.VirtualSPD(aliasName, namespace, targetedDatabase, graphShard, primary));
        });
    }

    public static Optional<DatabaseReferenceImpl.PropertyShard> createSPDPropertyShardReference(String owningDatabaseName, Node db) {
        return CommunityTopologyGraphDbmsModelUtil.ignoreConcurrentDeletes(() -> {
            NormalizedDatabaseName normalizedName = new NormalizedDatabaseName((String)db.getProperty("name"));
            NamedDatabaseId id = CommunityTopologyGraphDbmsModelUtil.getDatabaseId(db);
            return Optional.of(new DatabaseReferenceImpl.PropertyShard(normalizedName, id, owningDatabaseName));
        });
    }

    public static Optional<DatabaseReferenceImpl.External> createExternalReference(Node ref) {
        return CommunityTopologyGraphDbmsModelUtil.ignoreConcurrentDeletes(() -> {
            String uriString = CommunityTopologyGraphDbmsModelUtil.getPropertyOnNode("Remote Database alias", ref, "url", String.class);
            NormalizedDatabaseName targetName = new NormalizedDatabaseName(CommunityTopologyGraphDbmsModelUtil.getPropertyOnNode("Remote Database alias", ref, "target_name", String.class));
            NormalizedDatabaseName aliasName = new NormalizedDatabaseName(CommunityTopologyGraphDbmsModelUtil.getPropertyOnNode("Remote Database alias", ref, "name", String.class));
            NormalizedDatabaseName namespace = new NormalizedDatabaseName(CommunityTopologyGraphDbmsModelUtil.getPropertyOnNode("Remote Database alias", ref, "namespace", String.class));
            URI uri = URI.create(uriString);
            SocketAddress host = SocketAddressParser.socketAddress((URI)uri, (int)7687, SocketAddress::new);
            RemoteUri remoteUri = new RemoteUri(uri.getScheme(), List.of(host), uri.getQuery());
            String uuid = CommunityTopologyGraphDbmsModelUtil.getPropertyOnNode("Remote Database alias", ref, "version", String.class);
            return Optional.of(new DatabaseReferenceImpl.External(targetName, aliasName, namespace, remoteUri, UUID.fromString(uuid)));
        });
    }

    public static Optional<DriverSettings> getDriverSettings(Node aliasNode) {
        return CommunityTopologyGraphDbmsModelUtil.ignoreConcurrentDeletes(() -> {
            List connectsWith = StreamSupport.stream(aliasNode.getRelationships(Direction.OUTGOING, new RelationshipType[]{TopologyGraphDbmsModel.CONNECTS_WITH_RELATIONSHIP}).spliterator(), false).toList();
            return connectsWith.stream().findFirst().map(Relationship::getEndNode).map(CommunityTopologyGraphDbmsModelUtil::createDriverSettings);
        });
    }

    public static Optional<Map<String, Object>> getAliasProperties(Node aliasNode) {
        return CommunityTopologyGraphDbmsModelUtil.ignoreConcurrentDeletes(() -> {
            List propertiesRels = StreamSupport.stream(aliasNode.getRelationships(Direction.OUTGOING, new RelationshipType[]{TopologyGraphDbmsModel.PROPERTIES_RELATIONSHIP}).spliterator(), false).toList();
            return propertiesRels.stream().findFirst().map(Relationship::getEndNode).map(Entity::getAllProperties);
        });
    }

    public static Optional<ExternalDatabaseCredentials> getDatabaseCredentials(Node aliasNode) {
        return CommunityTopologyGraphDbmsModelUtil.ignoreConcurrentDeletes(() -> {
            String username = CommunityTopologyGraphDbmsModelUtil.getPropertyOnNode(TopologyGraphDbmsModel.REMOTE_DATABASE, aliasNode, "username", String.class);
            byte[] password = CommunityTopologyGraphDbmsModelUtil.getPropertyOnNode(TopologyGraphDbmsModel.REMOTE_DATABASE, aliasNode, "password", byte[].class);
            byte[] iv = CommunityTopologyGraphDbmsModelUtil.getPropertyOnNode(TopologyGraphDbmsModel.REMOTE_DATABASE, aliasNode, "iv", byte[].class);
            return Optional.of(new ExternalDatabaseCredentials(username, password, iv));
        });
    }

    private static DriverSettings createDriverSettings(Node driverSettingsNode) {
        DriverSettings.Builder builder = DriverSettings.builder();
        CommunityTopologyGraphDbmsModelUtil.getOptionalPropertyOnNode(TopologyGraphDbmsModel.DRIVER_SETTINGS, driverSettingsNode, "ssl_enforced", Boolean.class).ifPresent(builder::withSslEnforced);
        CommunityTopologyGraphDbmsModelUtil.getOptionalPropertyOnNode(TopologyGraphDbmsModel.DRIVER_SETTINGS, driverSettingsNode, "connection_timeout", DurationValue.class).ifPresent(builder::withConnectionTimeout);
        CommunityTopologyGraphDbmsModelUtil.getOptionalPropertyOnNode(TopologyGraphDbmsModel.DRIVER_SETTINGS, driverSettingsNode, "connection_max_lifetime", DurationValue.class).ifPresent(builder::withConnectionMaxLifeTime);
        CommunityTopologyGraphDbmsModelUtil.getOptionalPropertyOnNode(TopologyGraphDbmsModel.DRIVER_SETTINGS, driverSettingsNode, DriverSettings.Keys.CONNECTION_POOL_ACQUISITION_TIMEOUT.toString(), DurationValue.class).ifPresent(builder::withConnectionPoolAcquisitionTimeout);
        CommunityTopologyGraphDbmsModelUtil.getOptionalPropertyOnNode(TopologyGraphDbmsModel.DRIVER_SETTINGS, driverSettingsNode, "connection_pool_idle_test", DurationValue.class).ifPresent(builder::withConnectionPoolIdleTest);
        CommunityTopologyGraphDbmsModelUtil.getOptionalPropertyOnNode(TopologyGraphDbmsModel.DRIVER_SETTINGS, driverSettingsNode, "connection_pool_max_size", Number.class).ifPresent(value -> builder.withConnectionPoolMaxSize(value.intValue()));
        CommunityTopologyGraphDbmsModelUtil.getOptionalPropertyOnNode(TopologyGraphDbmsModel.DRIVER_SETTINGS, driverSettingsNode, "logging_level", String.class).ifPresent(level -> builder.withLoggingLevel(Level.valueOf((String)level)));
        return builder.build();
    }

    static Optional<DatabaseReference> getInternalDatabaseReferenceInRoot(Transaction tx, String databaseName) {
        return CommunityTopologyGraphDbmsModelUtil.getInternalDatabaseReference(tx, "system-root", databaseName);
    }

    static Optional<DatabaseReference> getInternalDatabaseReference(Transaction tx, String namespace, String databaseName) {
        return CommunityTopologyGraphDbmsModelUtil.findAliasNodeInNamespace(tx, namespace, databaseName).filter(node -> !node.hasLabel(TopologyGraphDbmsModel.REMOTE_DATABASE_LABEL)).flatMap(alias -> CommunityTopologyGraphDbmsModelUtil.getTargetedDatabase(alias).flatMap(db -> CommunityTopologyGraphDbmsModelUtil.createInternalReference(alias, db)));
    }

    static Optional<DatabaseReference> getInternalDatabaseReference(Transaction tx, String displayName) {
        return CommunityTopologyGraphDbmsModelUtil.findAliasNodeByDisplayName(tx, displayName).filter(node -> !node.hasLabel(TopologyGraphDbmsModel.REMOTE_DATABASE_LABEL)).flatMap(alias -> CommunityTopologyGraphDbmsModelUtil.getTargetedDatabase(alias).flatMap(db -> CommunityTopologyGraphDbmsModelUtil.createInternalReference(alias, db)));
    }

    static Optional<DatabaseReference> getExternalDatabaseReference(Transaction tx, String displayName) {
        return CommunityTopologyGraphDbmsModelUtil.findAliasNodeByDisplayName(tx, displayName).filter(node -> node.hasLabel(TopologyGraphDbmsModel.REMOTE_DATABASE_LABEL)).flatMap(CommunityTopologyGraphDbmsModelUtil::createExternalReference);
    }

    static Optional<DatabaseReference> getExternalDatabaseReferenceInRoot(Transaction tx, String databaseName) {
        return CommunityTopologyGraphDbmsModelUtil.getExternalDatabaseReferenceInRoot(tx, "system-root", databaseName);
    }

    static Optional<DatabaseReference> getExternalDatabaseReferenceInRoot(Transaction tx, String namespace, String databaseName) {
        return CommunityTopologyGraphDbmsModelUtil.findAliasNodeInNamespace(tx, namespace, databaseName).filter(node -> node.hasLabel(TopologyGraphDbmsModel.REMOTE_DATABASE_LABEL)).flatMap(CommunityTopologyGraphDbmsModelUtil::createExternalReference);
    }

    private static Optional<Node> findAliasNodeInNamespace(Transaction tx, String namespace, String databaseName) {
        try (ResourceIterator nodes = tx.findNodes(TopologyGraphDbmsModel.DATABASE_NAME_LABEL, "name", (Object)databaseName);){
            Optional<Node> optional = nodes.stream().filter(n -> CommunityTopologyGraphDbmsModelUtil.getOptionalPropertyOnNode(TopologyGraphDbmsModel.DATABASE_NAME, n, "namespace", String.class).orElse("system-root").equals(namespace)).findFirst();
            return optional;
        }
    }

    private static Optional<Node> findAliasNodeByDisplayName(Transaction tx, String displayName) {
        try (ResourceIterator nodes = tx.findNodes(TopologyGraphDbmsModel.DATABASE_NAME_LABEL, "displayName", (Object)displayName);){
            Optional<Node> optional = nodes.stream().findFirst();
            return optional;
        }
    }

    static Optional<NamedDatabaseId> getDatabaseIdByAliasInRoot(Transaction tx, String databaseName) {
        return CommunityTopologyGraphDbmsModelUtil.findAliasNodeInNamespace(tx, "system-root", databaseName).flatMap(CommunityTopologyGraphDbmsModelUtil::getTargetedDatabase);
    }

    static Optional<NamedDatabaseId> getDatabaseIdBy(Transaction tx, String propertyKey, String propertyValue) {
        try {
            Node node = tx.findNode(TopologyGraphDbmsModel.DATABASE_LABEL, propertyKey, (Object)propertyValue);
            if (node == null) {
                return Optional.empty();
            }
            String databaseName = CommunityTopologyGraphDbmsModelUtil.getPropertyOnNode(TopologyGraphDbmsModel.DATABASE_LABEL.name(), node, "name", String.class);
            String databaseUuid = CommunityTopologyGraphDbmsModelUtil.getPropertyOnNode(TopologyGraphDbmsModel.DATABASE_LABEL.name(), node, "uuid", String.class);
            return Optional.of(DatabaseIdFactory.from((String)databaseName, (UUID)UUID.fromString(databaseUuid)));
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static Optional<NamedDatabaseId> getTargetedDatabase(Node aliasNode) {
        return CommunityTopologyGraphDbmsModelUtil.ignoreConcurrentDeletes(() -> {
            try (Stream stream = aliasNode.getRelationships(Direction.OUTGOING, new RelationshipType[]{TopologyGraphDbmsModel.TARGETS_RELATIONSHIP}).stream();){
                Optional<NamedDatabaseId> optional = stream.findFirst().map(Relationship::getEndNode).map(CommunityTopologyGraphDbmsModelUtil::getDatabaseId);
                return optional;
            }
        });
    }

    public static Optional<Node> getTargetedDatabaseNode(Node aliasNode) {
        return CommunityTopologyGraphDbmsModelUtil.ignoreConcurrentDeletes(() -> {
            try (Stream stream = aliasNode.getRelationships(Direction.OUTGOING, new RelationshipType[]{TopologyGraphDbmsModel.TARGETS_RELATIONSHIP}).stream();){
                Optional<Node> optional = stream.findFirst().map(Relationship::getEndNode);
                return optional;
            }
        });
    }

    static NamedDatabaseId getDatabaseId(Node databaseNode) {
        String name = (String)databaseNode.getProperty("name");
        UUID uuid = UUID.fromString((String)databaseNode.getProperty("uuid"));
        return DatabaseIdFactory.from((String)name, (UUID)uuid);
    }

    private static <T> Optional<T> getOptionalPropertyOnNode(String labelName, Node node, String key, Class<T> type) {
        Object value;
        try {
            value = node.getProperty(key);
        }
        catch (NotFoundException e) {
            return Optional.empty();
        }
        if (value == null) {
            return Optional.empty();
        }
        if (!type.isInstance(value)) {
            throw new IllegalStateException(String.format("%s has non %s property %s.", labelName, type.getSimpleName(), key));
        }
        return Optional.of(type.cast(value));
    }

    private static <T> T getPropertyOnNode(String labelName, Node node, String key, Class<T> type) {
        Object value = node.getProperty(key);
        if (value == null) {
            throw new IllegalStateException(String.format("%s has no property %s.", labelName, key));
        }
        if (!type.isInstance(value)) {
            throw new IllegalStateException(String.format("%s has non %s property %s.", labelName, type.getSimpleName(), key));
        }
        return type.cast(value);
    }

    static <T> Optional<T> ignoreConcurrentDeletes(Supplier<Optional<T>> operation) {
        try {
            return operation.get();
        }
        catch (NotFoundException e) {
            return Optional.empty();
        }
    }

    public static Optional<String> readGraphShardOwningDatabase(Node graphShardDb) {
        return CommunityTopologyGraphDbmsModelUtil.ignoreConcurrentDeletes(() -> {
            List<Node> virtualSpd = graphShardDb.getRelationships(Direction.INCOMING, new RelationshipType[]{TopologyGraphDbmsModel.HAS_GRAPH_SHARD}).stream().map(Relationship::getStartNode).toList();
            if (virtualSpd.isEmpty()) {
                return Optional.empty();
            }
            return Optional.of(virtualSpd.getFirst().getProperty("name").toString());
        });
    }

    public static Optional<String> readPropertyShardOwningDatabase(Node propertyShardDb) {
        return CommunityTopologyGraphDbmsModelUtil.ignoreConcurrentDeletes(() -> {
            List<Node> graphShard = propertyShardDb.getRelationships(Direction.INCOMING, new RelationshipType[]{TopologyGraphDbmsModel.HAS_PROPERTY_SHARD}).stream().map(Relationship::getStartNode).toList();
            if (graphShard.isEmpty()) {
                return Optional.empty();
            }
            return CommunityTopologyGraphDbmsModelUtil.readGraphShardOwningDatabase(graphShard.getFirst());
        });
    }

    public static Optional<String> readUpstreamDatabase(Node aliasNode) {
        return CommunityTopologyGraphDbmsModelUtil.ignoreConcurrentDeletes(() -> {
            List<Node> relationships = aliasNode.getRelationships(Direction.OUTGOING, new RelationshipType[]{TopologyGraphDbmsModel.IS_MIRROR_OF_RELATIONSHIP}).stream().map(Relationship::getStartNode).toList();
            if (relationships.isEmpty()) {
                return Optional.of(aliasNode.getProperty("name").toString());
            }
            return Optional.of(relationships.getFirst().getProperty("name").toString());
        });
    }
}

