/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.ArrayUtils;
import org.neo4j.common.EntityType;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.exceptions.KernelException;
import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.graphdb.DatabaseShutdownException;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.NotInTransactionException;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.RelationshipCursor;
import org.neo4j.internal.kernel.api.RelationshipScanCursor;
import org.neo4j.internal.kernel.api.TokenRead;
import org.neo4j.internal.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.internal.kernel.api.exceptions.InvalidTransactionTypeKernelException;
import org.neo4j.internal.kernel.api.exceptions.PropertyKeyIdNotFoundKernelException;
import org.neo4j.internal.kernel.api.exceptions.schema.ConstraintValidationException;
import org.neo4j.internal.kernel.api.exceptions.schema.IllegalTokenNameException;
import org.neo4j.internal.kernel.api.exceptions.schema.TokenCapacityExceededKernelException;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.coreapi.DefaultTransactionExceptionMapper;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.storageengine.api.PropertySelection;
import org.neo4j.storageengine.api.RelationshipVisitor;
import org.neo4j.values.storable.Values;

public class RelationshipEntity
implements Relationship,
RelationshipVisitor<RuntimeException> {
    public static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(RelationshipEntity.class);
    private final InternalTransaction internalTransaction;
    private final RelationshipCursor cursor;
    private long id = -1L;
    private long startNode = -1L;
    private long endNode = -1L;
    private int type;

    public RelationshipEntity(InternalTransaction internalTransaction, RelationshipCursor cursor) {
        this.internalTransaction = internalTransaction;
        this.cursor = cursor;
        this.visit(cursor.relationshipReference(), cursor.type(), cursor.sourceNodeReference(), cursor.targetNodeReference());
    }

    public RelationshipEntity(InternalTransaction internalTransaction, long id, long startNode, int type, long endNode) {
        this.internalTransaction = internalTransaction;
        this.cursor = null;
        this.visit(id, type, startNode, endNode);
    }

    public RelationshipEntity(InternalTransaction internalTransaction, long id) {
        this.internalTransaction = internalTransaction;
        this.id = id;
        this.cursor = null;
    }

    public static boolean isDeletedInCurrentTransaction(Relationship relationship) {
        if (relationship instanceof RelationshipEntity) {
            RelationshipEntity proxy = (RelationshipEntity)relationship;
            KernelTransaction ktx = proxy.internalTransaction.kernelTransaction();
            return ktx.dataRead().relationshipDeletedInTransaction(proxy.id);
        }
        return false;
    }

    public final void visit(long id, int type, long startNode, long endNode) throws RuntimeException {
        this.id = id;
        this.type = type;
        this.startNode = startNode;
        this.endNode = endNode;
    }

    public boolean initializeData() {
        if (this.startNode == -1L) {
            KernelTransaction transaction = this.internalTransaction.kernelTransaction();
            RelationshipScanCursor relationships = transaction.ambientRelationshipCursor();
            return this.initializeData(relationships);
        }
        return true;
    }

    public boolean initializeData(RelationshipScanCursor relationships) {
        if (this.startNode == -1L) {
            KernelTransaction transaction = this.internalTransaction.kernelTransaction();
            transaction.dataRead().singleRelationship(this.id, relationships);
            boolean wasPresent = relationships.next();
            this.type = relationships.type();
            this.startNode = relationships.sourceNodeReference();
            this.endNode = relationships.targetNodeReference();
            return wasPresent;
        }
        return true;
    }

    public long getId() {
        return this.id;
    }

    public String getElementId() {
        return this.internalTransaction.elementIdMapper().relationshipElementId(this.id);
    }

    private int typeId() {
        this.initializeData();
        return this.type;
    }

    private long sourceId() {
        this.initializeData();
        return this.startNode;
    }

    private long targetId() {
        this.initializeData();
        return this.endNode;
    }

    public void delete() {
        KernelTransaction transaction = this.internalTransaction.kernelTransaction();
        try {
            boolean deleted = transaction.dataWrite().relationshipDelete(this.id);
            if (!deleted) {
                throw new NotFoundException("Unable to delete relationship[" + this.getId() + "] since it is already deleted.");
            }
        }
        catch (InvalidTransactionTypeKernelException e) {
            throw new ConstraintViolationException(e.getMessage(), (Throwable)e);
        }
    }

    public Node[] getNodes() {
        this.internalTransaction.checkInTransaction();
        return new Node[]{this.internalTransaction.newNodeEntity(this.sourceId()), this.internalTransaction.newNodeEntity(this.targetId())};
    }

    public Node getOtherNode(Node node) {
        this.internalTransaction.checkInTransaction();
        return this.internalTransaction.newNodeEntity(this.getOtherNodeId(node.getId()));
    }

    public Node getStartNode() {
        this.internalTransaction.checkInTransaction();
        return this.internalTransaction.newNodeEntity(this.sourceId());
    }

    public Node getEndNode() {
        this.internalTransaction.checkInTransaction();
        return this.internalTransaction.newNodeEntity(this.targetId());
    }

    public long getStartNodeId() {
        return this.sourceId();
    }

    public long getEndNodeId() {
        return this.targetId();
    }

    public long getOtherNodeId(long id) {
        long start = this.sourceId();
        long end = this.targetId();
        if (start == id) {
            return end;
        }
        if (end == id) {
            return start;
        }
        throw new NotFoundException("Node[" + id + "] not connected to this relationship[" + this.getId() + "]");
    }

    public RelationshipType getType() {
        this.internalTransaction.checkInTransaction();
        int typeId = this.typeId();
        if ((long)typeId == -1L) {
            throw new NotFoundException((Throwable)EntityNotFoundException.internalError((String)this.getClass().getSimpleName(), (EntityType)EntityType.NODE, (String)this.getElementId()));
        }
        return this.internalTransaction.getRelationshipTypeById(typeId);
    }

    private PropertyCursor initializePropertyCursor(PropertyCursor properties, KernelTransaction transaction, PropertySelection selection) {
        if (this.cursor != null && !this.cursor.isClosed() && this.cursor.relationshipReference() == this.id) {
            this.cursor.properties(properties, selection);
        } else {
            RelationshipScanCursor relationships = transaction.ambientRelationshipCursor();
            this.singleRelationship(transaction, relationships);
            relationships.properties(properties, selection);
        }
        return properties;
    }

    public Iterable<String> getPropertyKeys() {
        KernelTransaction transaction = this.internalTransaction.kernelTransaction();
        ArrayList<String> keys = new ArrayList<String>();
        try {
            PropertyCursor properties = this.initializePropertyCursor(transaction.ambientPropertyCursor(), transaction, PropertySelection.ALL_PROPERTIES);
            TokenRead token = transaction.tokenRead();
            while (properties.next()) {
                keys.add(token.propertyKeyName(properties.propertyKey()));
            }
        }
        catch (PropertyKeyIdNotFoundKernelException e) {
            throw new IllegalStateException("Property key retrieved through kernel API should exist.", e);
        }
        return keys;
    }

    public Map<String, Object> getProperties(String ... keys) {
        Objects.requireNonNull(keys, "Properties keys should be not null array.");
        if (keys.length == 0) {
            return Collections.emptyMap();
        }
        KernelTransaction transaction = this.internalTransaction.kernelTransaction();
        int itemsToReturn = keys.length;
        TokenRead token = transaction.tokenRead();
        int[] propertyIds = new int[itemsToReturn];
        for (int i = 0; i < itemsToReturn; ++i) {
            String key = keys[i];
            if (key == null) {
                throw new NullPointerException(String.format("Key %d was null", i));
            }
            propertyIds[i] = token.propertyKey(key);
        }
        HashMap<String, Object> properties = new HashMap<String, Object>(itemsToReturn);
        PropertyCursor propertyCursor = this.initializePropertyCursor(transaction.ambientPropertyCursor(), transaction, PropertySelection.selection((int[])propertyIds));
        while (propertyCursor.next()) {
            properties.put(keys[ArrayUtils.indexOf((int[])propertyIds, (int)propertyCursor.propertyKey())], propertyCursor.propertyValue().asObjectCopy());
        }
        return properties;
    }

    public Map<String, Object> getAllProperties() {
        KernelTransaction transaction = this.internalTransaction.kernelTransaction();
        PropertyCursor propertyCursor = transaction.ambientPropertyCursor();
        return this.getAllProperties(propertyCursor);
    }

    public Map<String, Object> getAllProperties(PropertyCursor propertyCursor) {
        KernelTransaction transaction = this.internalTransaction.kernelTransaction();
        HashMap<String, Object> properties = new HashMap<String, Object>();
        try {
            this.initializePropertyCursor(propertyCursor, transaction, PropertySelection.ALL_PROPERTIES);
            TokenRead token = transaction.tokenRead();
            while (propertyCursor.next()) {
                properties.put(token.propertyKeyName(propertyCursor.propertyKey()), propertyCursor.propertyValue().asObjectCopy());
            }
        }
        catch (PropertyKeyIdNotFoundKernelException e) {
            throw new IllegalStateException("Property key retrieved through kernel API should exist.", e);
        }
        return properties;
    }

    public Object getProperty(String key) {
        if (null == key) {
            throw new IllegalArgumentException("(null) property key is not allowed");
        }
        KernelTransaction transaction = this.internalTransaction.kernelTransaction();
        int propertyKey = transaction.tokenRead().propertyKey(key);
        if (propertyKey == -1) {
            throw new NotFoundException(String.format("No such property, '%s'.", key));
        }
        PropertyCursor properties = this.initializePropertyCursor(transaction.ambientPropertyCursor(), transaction, PropertySelection.selection((int)propertyKey));
        if (!properties.next()) {
            throw new NotFoundException(String.format("No such property, '%s'.", key));
        }
        return properties.propertyValue().asObjectCopy();
    }

    public Object getProperty(String key, Object defaultValue) {
        if (null == key) {
            throw new IllegalArgumentException("(null) property key is not allowed");
        }
        KernelTransaction transaction = this.internalTransaction.kernelTransaction();
        int propertyKey = transaction.tokenRead().propertyKey(key);
        if (propertyKey == -1) {
            return defaultValue;
        }
        PropertyCursor properties = this.initializePropertyCursor(transaction.ambientPropertyCursor(), transaction, PropertySelection.selection((int)propertyKey));
        return properties.next() ? properties.propertyValue().asObjectCopy() : defaultValue;
    }

    public boolean hasProperty(String key) {
        if (null == key) {
            return false;
        }
        KernelTransaction transaction = this.internalTransaction.kernelTransaction();
        int propertyKey = transaction.tokenRead().propertyKey(key);
        if (propertyKey == -1) {
            return false;
        }
        PropertyCursor properties = this.initializePropertyCursor(transaction.ambientPropertyCursor(), transaction, PropertySelection.selection((int)propertyKey));
        return properties.next();
    }

    public void setProperty(String key, Object value) {
        int propertyKeyId;
        KernelTransaction transaction = this.internalTransaction.kernelTransaction();
        try {
            propertyKeyId = transaction.tokenWrite().propertyKeyGetOrCreateForName(key);
        }
        catch (IllegalTokenNameException e) {
            throw new IllegalArgumentException(String.format("Invalid property key '%s'.", key), e);
        }
        catch (TokenCapacityExceededKernelException e) {
            throw new ConstraintViolationException(e.getMessage(), (Throwable)e);
        }
        catch (KernelException e) {
            throw DefaultTransactionExceptionMapper.mapStatusException("Unknown error trying to create property key token", e.status(), (Exception)((Object)e));
        }
        try {
            transaction.dataWrite().relationshipSetProperty(this.id, propertyKeyId, Values.of((Object)value, (boolean)false));
        }
        catch (ConstraintValidationException e) {
            throw new ConstraintViolationException(e.getUserMessage((TokenNameLookup)transaction.tokenRead()), (Throwable)e);
        }
        catch (EntityNotFoundException e) {
            throw new NotFoundException((Throwable)e);
        }
        catch (InvalidTransactionTypeKernelException e) {
            throw new ConstraintViolationException(e.getMessage(), (Throwable)e);
        }
    }

    public Object removeProperty(String key) {
        KernelTransaction transaction = this.internalTransaction.kernelTransaction();
        int propertyKeyId = transaction.tokenRead().propertyKey(key);
        if (propertyKeyId == -1) {
            return Values.NO_VALUE.asObjectCopy();
        }
        try {
            return transaction.dataWrite().relationshipRemoveProperty(this.id, propertyKeyId).asObjectCopy();
        }
        catch (InvalidTransactionTypeKernelException e) {
            throw new ConstraintViolationException(e.getMessage(), (Throwable)e);
        }
        catch (EntityNotFoundException e) {
            throw new NotFoundException((Throwable)e);
        }
    }

    public boolean isType(RelationshipType type) {
        this.internalTransaction.checkInTransaction();
        return this.internalTransaction.getRelationshipTypeById(this.typeId()).name().equals(type.name());
    }

    public boolean equals(Object o) {
        return o instanceof Relationship && this.getId() == ((Relationship)o).getId();
    }

    public int hashCode() {
        return (int)(this.getId() >>> 32 ^ this.getId());
    }

    public String toString() {
        try {
            String relType = this.internalTransaction.getRelationshipTypeById(this.typeId()).name();
            return String.format("(%d)-[%s,%d]->(%d)", this.sourceId(), relType, this.getId(), this.targetId());
        }
        catch (DatabaseShutdownException | NotInTransactionException throwable) {
            String relType = "RELTYPE(" + this.type + ")";
            return String.format("(?)-[%s,%d]->(?)", relType, this.getId());
        }
    }

    private void singleRelationship(KernelTransaction transaction, RelationshipScanCursor relationships) {
        if (this.startNode != -1L) {
            transaction.dataRead().singleRelationship(this.id, this.startNode, this.type, this.endNode, relationships);
        } else {
            transaction.dataRead().singleRelationship(this.id, relationships);
        }
        if (!relationships.next()) {
            throw new NotFoundException((Throwable)EntityNotFoundException.internalError((String)this.getClass().getSimpleName(), (EntityType)EntityType.RELATIONSHIP, (String)this.getElementId()));
        }
    }

    public InternalTransaction getTransaction() {
        return this.internalTransaction;
    }
}

