/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.checkpoint;

import java.io.IOException;
import java.time.Clock;
import java.util.concurrent.TimeUnit;
import java.util.function.BooleanSupplier;
import org.neo4j.graphdb.Resource;
import org.neo4j.internal.helpers.Format;
import org.neo4j.io.pagecache.IOController;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.io.pagecache.tracing.DatabaseFlushEvent;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.KernelVersionProvider;
import org.neo4j.kernel.database.DatabaseTracers;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointThreshold;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointer;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckpointAppender;
import org.neo4j.kernel.impl.transaction.log.checkpoint.LatestCheckpointInfo;
import org.neo4j.kernel.impl.transaction.log.checkpoint.StoreCopyCheckPointMutex;
import org.neo4j.kernel.impl.transaction.log.checkpoint.TriggerInfo;
import org.neo4j.kernel.impl.transaction.log.pruning.LogPruning;
import org.neo4j.kernel.impl.transaction.tracing.DatabaseTracer;
import org.neo4j.kernel.impl.transaction.tracing.LogCheckPointEvent;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.logging.InternalLog;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.monitoring.Panic;
import org.neo4j.storageengine.api.ClosedBatchMetadata;
import org.neo4j.storageengine.api.MetadataProvider;
import org.neo4j.storageengine.api.OpenTransactionMetadata;
import org.neo4j.storageengine.api.TransactionId;
import org.neo4j.time.Stopwatch;

public class CheckPointerImpl
extends LifecycleAdapter
implements CheckPointer {
    private static final String CHECKPOINT_TAG = "checkpoint";
    private static final long NO_APPEND_INDEX = -1L;
    private static final String IO_DETAILS_TEMPLATE = "Checkpoint flushed %d pages (%d%% of total available pages), in %d IOs. Checkpoint performed with IO limit: %s, paused in total %d times( %d millis).";
    private static final String UNLIMITED_IO_CONTROLLER_LIMIT = "unlimited";
    private final CheckpointAppender checkpointAppender;
    private final MetadataProvider metadataProvider;
    private final CheckPointThreshold threshold;
    private final ForceOperation forceOperation;
    private final LogPruning logPruning;
    private final Panic databasePanic;
    private final InternalLog log;
    private final DatabaseTracers tracers;
    private final StoreCopyCheckPointMutex mutex;
    private final CursorContextFactory cursorContextFactory;
    private final Clock clock;
    private final IOController ioController;
    private final KernelVersionProvider versionProvider;
    private volatile boolean shutdown;
    private volatile LatestCheckpointInfo latestCheckPointInfo = LatestCheckpointInfo.UNKNOWN_CHECKPOINT_INFO;

    public CheckPointerImpl(MetadataProvider metadataProvider, CheckPointThreshold threshold, ForceOperation forceOperation, LogPruning logPruning, CheckpointAppender checkpointAppender, Panic databasePanic, InternalLogProvider logProvider, DatabaseTracers tracers, StoreCopyCheckPointMutex mutex, CursorContextFactory cursorContextFactory, Clock clock, IOController ioController, KernelVersionProvider versionProvider) {
        this.checkpointAppender = checkpointAppender;
        this.metadataProvider = metadataProvider;
        this.threshold = threshold;
        this.forceOperation = forceOperation;
        this.logPruning = logPruning;
        this.databasePanic = databasePanic;
        this.log = logProvider.getLog(CheckPointerImpl.class);
        this.tracers = tracers;
        this.mutex = mutex;
        this.cursorContextFactory = cursorContextFactory;
        this.clock = clock;
        this.ioController = ioController;
        this.versionProvider = versionProvider;
    }

    public void start() {
        ClosedBatchMetadata lastClosedBatch = this.metadataProvider.getLastClosedBatch();
        this.threshold.initialize(lastClosedBatch.appendIndex(), lastClosedBatch.logPosition());
    }

    @Override
    public void shutdown() {
        try (Resource ignored = this.mutex.checkPoint();){
            this.shutdown = true;
        }
    }

    @Override
    public long forceCheckPoint(TriggerInfo info) throws IOException {
        try (Resource lock = this.mutex.checkPoint();){
            long l = this.checkpointByTrigger(info);
            return l;
        }
    }

    @Override
    public long forceCheckPoint(TransactionId transactionId, long appendIndex, LogPosition position, TriggerInfo triggerInfo) throws IOException {
        try (Resource lock = this.mutex.checkPoint();){
            long l = this.checkpointByExternalParams(transactionId, appendIndex, position, position, appendIndex, triggerInfo);
            return l;
        }
    }

    @Override
    public long tryCheckPoint(TriggerInfo info) throws IOException {
        return this.tryCheckPoint(info, () -> false);
    }

    @Override
    public long tryCheckPointNoWait(TriggerInfo info) throws IOException {
        return this.tryCheckPoint(info, () -> true);
    }

    @Override
    public long tryCheckPoint(TriggerInfo info, BooleanSupplier timeout) throws IOException {
        Resource lockAttempt = this.mutex.tryCheckPoint();
        if (lockAttempt != null) {
            try (Resource resource = lockAttempt;){
                long l = this.checkpointByTrigger(info);
                return l;
            }
        }
        try (Resource lock = this.mutex.tryCheckPoint(timeout);){
            if (lock != null) {
                LatestCheckpointInfo lastInfo = this.latestCheckPointInfo;
                this.log.info(info.describe(lastInfo) + " Check pointing was already running, completed now");
                long l = lastInfo.appendIndex();
                return l;
            }
            long l = -1L;
            return l;
        }
    }

    @Override
    public long checkPointIfNeeded(TriggerInfo info) throws IOException {
        ClosedBatchMetadata lastClosedBatch = this.metadataProvider.getLastClosedBatch();
        if (this.threshold.isCheckPointingNeeded(lastClosedBatch.appendIndex(), lastClosedBatch.logPosition(), info)) {
            try (Resource lock = this.mutex.checkPoint();){
                long l = this.checkpointByTrigger(info);
                return l;
            }
        }
        return -1L;
    }

    private long checkpointByTrigger(TriggerInfo triggerInfo) throws IOException {
        if (this.shutdown) {
            this.logShutdownMessage(triggerInfo);
            return -1L;
        }
        TransactionId highestTransactionEver = this.metadataProvider.getHighestEverClosedTransaction();
        ClosedBatchMetadata lastClosedBatch = this.metadataProvider.getLastClosedBatch();
        NotCompletedTransactionInfo oldestNotVisibleTransactionInfo = this.evaluateOldestNotVisibleTransactionInfo(lastClosedBatch);
        return this.checkpointByExternalParams(highestTransactionEver, oldestNotVisibleTransactionInfo.appendIndex(), oldestNotVisibleTransactionInfo.logPosition(), lastClosedBatch.logPosition(), lastClosedBatch.appendIndex(), triggerInfo);
    }

    private long checkpointByExternalParams(TransactionId transactionId, long oldestNotVisibleAppendIndex, LogPosition oldestNotCompletedPosition, LogPosition checkpointedLogPosition, long appendIndex, TriggerInfo triggerInfo) throws IOException {
        if (this.shutdown) {
            this.logShutdownMessage(triggerInfo);
            return -1L;
        }
        return this.doCheckpoint(transactionId, appendIndex, oldestNotVisibleAppendIndex, oldestNotCompletedPosition, checkpointedLogPosition, triggerInfo);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private long doCheckpoint(TransactionId transactionId, long appendIndex, long oldestNotVisibleAppendIndex, LogPosition oldestNotCompletedPosition, LogPosition checkpointedLogPosition, TriggerInfo triggerInfo) throws IOException {
        DatabaseTracer databaseTracer = this.tracers.getDatabaseTracer();
        try (CursorContext cursorContext = this.cursorContextFactory.create(CHECKPOINT_TAG);){
            LogCheckPointEvent checkPointEvent = databaseTracer.beginCheckPoint();
            try {
                long highestEverClosedTransactionId = transactionId.id();
                cursorContext.getVersionContext().initWrite(highestEverClosedTransactionId);
                cursorContext.getVersionContext().initAppendIndex(transactionId.appendIndex());
                KernelVersion kernelVersion = this.versionProvider.kernelVersion();
                LatestCheckpointInfo ongoingCheckpoint = new LatestCheckpointInfo(transactionId, oldestNotVisibleAppendIndex);
                String checkpointReason = triggerInfo.describe(ongoingCheckpoint);
                this.databasePanic.assertNoPanic(IOException.class);
                this.log.info(checkpointReason + " checkpoint started...");
                Stopwatch startTime = Stopwatch.start();
                try (DatabaseFlushEvent flushEvent = checkPointEvent.beginDatabaseFlush();){
                    this.forceOperation.flushAndForce(flushEvent, cursorContext);
                    flushEvent.ioControllerLimit(this.ioController.configuredLimit());
                }
                this.databasePanic.assertNoPanic(IOException.class);
                this.checkpointAppender.checkPoint(checkPointEvent, transactionId, appendIndex, kernelVersion, oldestNotCompletedPosition, checkpointedLogPosition, this.clock.instant(), checkpointReason);
                this.threshold.checkPointHappened(appendIndex, checkpointedLogPosition);
                long durationMillis = startTime.elapsed(TimeUnit.MILLISECONDS);
                checkPointEvent.checkpointCompleted(durationMillis);
                this.log.info(this.createCheckpointMessageDescription(checkPointEvent, checkpointReason, durationMillis));
                this.logPruning.pruneLogs(oldestNotCompletedPosition.getLogVersion());
                this.latestCheckPointInfo = ongoingCheckpoint;
                long l = this.latestCheckPointInfo.appendIndex();
                if (checkPointEvent != null) {
                    checkPointEvent.close();
                }
                return l;
            }
            catch (Throwable throwable) {
                if (checkPointEvent != null) {
                    try {
                        checkPointEvent.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        catch (Throwable t) {
            this.log.error("Checkpoint failed", t);
            throw t;
        }
    }

    private String createCheckpointMessageDescription(LogCheckPointEvent checkpointEvent, String checkpointReason, long durationMillis) {
        double flushRatio = checkpointEvent.flushRatio();
        long ioLimit = checkpointEvent.getConfiguredIOLimit();
        String ioDetails = IO_DETAILS_TEMPLATE.formatted(checkpointEvent.getPagesFlushed(), (int)(flushRatio * 100.0), checkpointEvent.getIOsPerformed(), this.ioLimitDescription(ioLimit), checkpointEvent.getTimesPaused(), checkpointEvent.getMillisPaused());
        return checkpointReason + " checkpoint completed in " + Format.duration((long)durationMillis) + ". " + ioDetails;
    }

    private String ioLimitDescription(long ioLimit) {
        return this.ioController.isEnabled() && ioLimit >= 0L ? String.valueOf(ioLimit) : UNLIMITED_IO_CONTROLLER_LIMIT;
    }

    private void logShutdownMessage(TriggerInfo triggerInfo) {
        this.log.warn("Checkpoint was requested on already shutdown checkpointer. Requester: " + triggerInfo.describe(LatestCheckpointInfo.UNKNOWN_CHECKPOINT_INFO));
    }

    private NotCompletedTransactionInfo evaluateOldestNotVisibleTransactionInfo(ClosedBatchMetadata lastClosedBatch) {
        OpenTransactionMetadata openTransactionMetadata = this.metadataProvider.getOldestOpenTransaction();
        if (openTransactionMetadata == null) {
            return new NotCompletedTransactionInfo(lastClosedBatch.appendIndex(), lastClosedBatch.logPosition());
        }
        long oldestBatchAppendIndex = openTransactionMetadata.appendIndex();
        if (oldestBatchAppendIndex > lastClosedBatch.appendIndex()) {
            return new NotCompletedTransactionInfo(lastClosedBatch.appendIndex(), lastClosedBatch.logPosition());
        }
        return new NotCompletedTransactionInfo(openTransactionMetadata.appendIndex() - 1L, openTransactionMetadata.logPosition());
    }

    @Override
    public LatestCheckpointInfo latestCheckPointInfo() {
        return this.latestCheckPointInfo;
    }

    @FunctionalInterface
    public static interface ForceOperation {
        public static final ForceOperation NO_OP = (flushEvent, cursorContext) -> {};

        public void flushAndForce(DatabaseFlushEvent var1, CursorContext var2) throws IOException;
    }

    private record NotCompletedTransactionInfo(long appendIndex, LogPosition logPosition) {
    }
}

