/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util.collection;

import java.util.function.Consumer;
import org.neo4j.collection.trackable.HeapTrackingConcurrentHashSet;
import org.neo4j.internal.kernel.api.DefaultCloseListenable;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.memory.Measurable;
import org.neo4j.memory.MemoryTracker;

public class ConcurrentDistinctSet<T extends Measurable>
extends DefaultCloseListenable {
    private static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(ConcurrentDistinctSet.class);
    private final MemoryTracker scopedMemoryTracker;
    private final HeapTrackingConcurrentHashSet<T> distinctSet;

    public static <T extends Measurable> ConcurrentDistinctSet<T> createDistinctSet(MemoryTracker memoryTracker) {
        MemoryTracker scopedMemoryTracker = memoryTracker.getScopedMemoryTracker();
        scopedMemoryTracker.allocateHeap(SHALLOW_SIZE + HeapEstimator.SCOPED_MEMORY_TRACKER_SHALLOW_SIZE);
        return new ConcurrentDistinctSet<T>(scopedMemoryTracker);
    }

    private ConcurrentDistinctSet(MemoryTracker scopedMemoryTracker) {
        this.scopedMemoryTracker = scopedMemoryTracker;
        this.distinctSet = HeapTrackingConcurrentHashSet.newSet((MemoryTracker)scopedMemoryTracker);
    }

    public boolean add(T element) {
        boolean wasAdded = this.distinctSet.add(element);
        if (wasAdded) {
            this.scopedMemoryTracker.allocateHeap(element.estimatedHeapUsage() + this.distinctSet.sizeOfWrapperObject());
        }
        return wasAdded;
    }

    public void forEach(Consumer<? super T> procedure) {
        this.distinctSet.forEach(procedure);
    }

    public void closeInternal() {
        this.scopedMemoryTracker.close();
    }

    public boolean isClosed() {
        return false;
    }
}

