/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.exceptions;

import java.util.List;
import java.util.stream.Collectors;
import org.neo4j.gqlstatus.ErrorGqlStatusObject;
import org.neo4j.gqlstatus.ErrorGqlStatusObjectImplementation;
import org.neo4j.gqlstatus.GqlException;
import org.neo4j.gqlstatus.GqlHelper;
import org.neo4j.gqlstatus.GqlParams;
import org.neo4j.gqlstatus.GqlStatusInfoCodes;
import org.neo4j.gqlstatus.PrivilegeGqlCodeEntity;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.values.AnyValue;
import org.neo4j.values.AnyValueWriter;
import org.neo4j.values.storable.DurationValue;
import org.neo4j.values.utils.PrettyPrinter;
import org.neo4j.values.virtual.MapValue;

public class InvalidArgumentsException
extends GqlException
implements Status.HasStatus {
    private final Status status = Status.General.InvalidArguments;

    @Deprecated
    public InvalidArgumentsException(String message) {
        this(message, null);
    }

    public InvalidArgumentsException(ErrorGqlStatusObject gqlStatusObject, String message) {
        this(gqlStatusObject, message, null);
    }

    @Deprecated
    public InvalidArgumentsException(String message, Throwable cause) {
        super(message, cause);
    }

    private InvalidArgumentsException(ErrorGqlStatusObject gqlStatusObject, String message, Throwable cause) {
        super(gqlStatusObject, message, cause);
    }

    public Status status() {
        return this.status;
    }

    public static InvalidArgumentsException internalError(String msgTitle, String message) {
        ErrorGqlStatusObject gql = GqlHelper.get50N00((String)msgTitle, (String)message);
        return new InvalidArgumentsException(gql, message);
    }

    public static InvalidArgumentsException databaseAlreadyExistsInSystemDb(String defaultName) {
        return new InvalidArgumentsException(PrivilegeGqlCodeEntity.databasesAlreadyExists(List.of(defaultName, "system")), "The specified database '" + defaultName + "' or 'system' already exists.");
    }

    public static InvalidArgumentsException invalidProcedureArgument(String providedInvalidArgument, String argumentName, String procedureName, String expectedFormat, String legacyMessage, Throwable cause) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_52N16).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_52N22).withParam(GqlParams.StringParam.field, providedInvalidArgument).withParam(GqlParams.StringParam.procParam, argumentName).withParam(GqlParams.StringParam.proc, procedureName).withParam(GqlParams.StringParam.procParam, argumentName).withParam(GqlParams.StringParam.procParamFmt, expectedFormat).build()).build();
        return new InvalidArgumentsException(gql, legacyMessage, cause);
    }

    public static InvalidArgumentsException requiresPositiveInteger(String option, int value) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22003).withParam(GqlParams.StringParam.value, String.valueOf(value)).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22N02).withParam(GqlParams.StringParam.option, option).withParam(GqlParams.NumberParam.value, (Number)value).build()).build();
        return new InvalidArgumentsException(gql, String.format("Option `%s` requires positive integer argument, got `%d`", option, value));
    }

    public static InvalidArgumentsException invalidResource(String typeString) {
        String gqlMsg = String.format("Found invalid resource (%s) in the system graph.", typeString);
        ErrorGqlStatusObject gql = GqlHelper.get50N00((String)InvalidArgumentsException.class.getSimpleName(), (String)gqlMsg);
        return new InvalidArgumentsException(gql, String.format("Found not valid resource (%s) in the system graph.", typeString));
    }

    public static InvalidArgumentsException entityResourceInvalidAction(String entity, String action, String legacyFormat) {
        String msg = String.format("%s resource cannot be combined with action %s%s%s", entity, legacyFormat, action, legacyFormat);
        ErrorGqlStatusObject gql = GqlHelper.get50N00((String)InvalidArgumentsException.class.getSimpleName(), (String)msg);
        return new InvalidArgumentsException(gql, msg);
    }

    public static InvalidArgumentsException internalAlterServer(String name) {
        String msg = String.format("Server '%s' can't be altered: must specify options", name);
        ErrorGqlStatusObject gql = GqlHelper.get50N00((String)InvalidArgumentsException.class.getSimpleName(), (String)msg);
        return new InvalidArgumentsException(gql, msg);
    }

    public static InvalidArgumentsException cannotAlterServer(String name, InvalidArgumentsException cause) {
        String msg = String.format("Server '%s' can't be altered: %s", name, cause.getMessage());
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_51N41).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_51N46).withParam(GqlParams.StringParam.server, name).build()).withParam(GqlParams.StringParam.msg, "argument error").build();
        return new InvalidArgumentsException(gql, msg, (Throwable)((Object)cause));
    }

    public static InvalidArgumentsException cannotEnableServer(String name, InvalidArgumentsException cause) {
        String msg = String.format("Server '%s' can't be enabled: %s", name, cause.getMessage());
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_51N41).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_51N48).withParam(GqlParams.StringParam.server, name).build()).withParam(GqlParams.StringParam.msg, "argument error").build();
        return new InvalidArgumentsException(gql, msg, (Throwable)((Object)cause));
    }

    public static InvalidArgumentsException providedFieldEmpty(String field) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22NB6).withParam(GqlParams.StringParam.item, field).build();
        return new InvalidArgumentsException(gql, String.format("The provided %s is empty.", field.toLowerCase()));
    }

    private static ErrorGqlStatusObject getIdxGql(MapValue itemsMap, List<String> validConfigSettingNames) {
        PrettyPrinter prettyVal = new PrettyPrinter();
        itemsMap.writeTo((AnyValueWriter)prettyVal);
        return GqlHelper.getGql42001_22N04((String)prettyVal.value(), (String)"index config", validConfigSettingNames);
    }

    private static String invalidConfigValueString(PrettyPrinter pp, AnyValue value, String schemaType) {
        value.writeTo((AnyValueWriter)pp);
        return InvalidArgumentsException.invalidConfigValueString(pp.value(), schemaType);
    }

    private static String invalidConfigValueString(String value, String schemaType) {
        return String.format("Could not create %s with specified index config '%s'", schemaType, value);
    }

    public static InvalidArgumentsException invalidIndexConfigExpectedMap(String schemaType, AnyValue input) {
        String oldMsg = String.format("Could not create %s with specified index config '%s'. Expected a map.", schemaType, input.prettify());
        return InvalidArgumentsException.invalidInput(input, GqlParams.StringParam.cmd.process((Object)"indexConfig"), List.of("MAP"), oldMsg);
    }

    public static InvalidArgumentsException invalidIndexConfig(String schemaType, String indexConfigOptions, String indexType) {
        ErrorGqlStatusObject gql = GqlHelper.getGql42001_22N04((String)indexConfigOptions, (String)"index config", List.of());
        return new InvalidArgumentsException(gql, String.format("Could not create %s with specified index config '%s': %s indexes have no valid config values.", schemaType, indexConfigOptions, indexType));
    }

    public static InvalidArgumentsException invalidIndexConfigExpectedMapWithDoubleArray(String schemaType, AnyValue input) {
        String oldMsg = String.format("Could not create %s with specified index config '%s'. Expected a map from String to Double[].", schemaType, input.prettify());
        return InvalidArgumentsException.invalidInput(input, GqlParams.StringParam.cmd.process((Object)"indexConfig"), List.of("MAP<STRING, LIST<FLOAT>>"), oldMsg);
    }

    public static InvalidArgumentsException invalidIndexConfigExpectedMapToStringAndBoolean(String schemaType, AnyValue input) {
        String oldMsg = String.format("Could not create %s with specified index config '%s'. Expected a map from String to Strings and Booleans.", schemaType, input.prettify());
        return InvalidArgumentsException.invalidInput(input, GqlParams.StringParam.cmd.process((Object)"indexConfig"), List.of("MAP<STRING, BOOLEAN | STRING>"), oldMsg);
    }

    public static InvalidArgumentsException invalidIndexOptionValue(String providedOption, List<String> validOptions, String errorMessageOverride) {
        ErrorGqlStatusObject gql = GqlHelper.getGql42001_22N04((String)providedOption, (String)GqlParams.StringParam.input.process((Object)"OPTIONS"), validOptions);
        return new InvalidArgumentsException(gql, errorMessageOverride == null ? GqlHelper.getCompleteMessage((ErrorGqlStatusObject)gql) : errorMessageOverride);
    }

    public static InvalidArgumentsException invalidIndexProviderSuggestIndex(String schemaDescription, String providerString, String indexDescription, String providerIndexType, List<String> indexProviders) {
        String indexProvidersString = "[" + indexProviders.stream().map(format -> "'" + format + "'").collect(Collectors.joining(", ")) + "]";
        ErrorGqlStatusObject gql = GqlHelper.getGql42001_22N04((String)providerString, (String)"index provider", indexProviders);
        return new InvalidArgumentsException(gql, String.format("Could not create %s with specified index provider '%s'.\nTo create %s index, please use 'CREATE %s INDEX ...'.\nThe available index providers for the given type: %s.", schemaDescription, providerString, indexDescription, providerIndexType, indexProvidersString));
    }

    public static InvalidArgumentsException invalidIndexProvider(String schemaType, AnyValue input) {
        String oldMsg = String.format("Could not create %s with specified index provider '%s'. Expected String value.", schemaType, input);
        return InvalidArgumentsException.invalidInput(input, GqlParams.StringParam.cmd.process((Object)"indexProvider"), List.of("STRING"), oldMsg);
    }

    public static InvalidArgumentsException invalidIndexProvider(Boolean correctCypherVersion, String schemaDescription, String providerString, List<String> indexProviders) {
        String indexProvidersString = "[" + indexProviders.stream().map(format -> "'" + format + "'").collect(Collectors.joining(", ")) + "]";
        ErrorGqlStatusObject gql = GqlHelper.getGql42001_22N04((String)providerString, (String)"index provider", indexProviders);
        String message = correctCypherVersion != false && (providerString.equalsIgnoreCase("native-btree-1.0") || providerString.equalsIgnoreCase("lucene+native-3.0")) ? String.format("Could not create %s with specified index provider '%s'.\nInvalid index type b-tree, use range, point or text index instead.\nThe available index providers for the given type: %s.", schemaDescription, providerString, indexProvidersString) : String.format("Could not create %s with specified index provider '%s'.\nThe available index providers for the given type: %s.", schemaDescription, providerString, indexProvidersString);
        return new InvalidArgumentsException(gql, message);
    }

    public static InvalidArgumentsException invalidVectorIndexConfig(String schemaType, AnyValue input) {
        String oldMsg = String.format("Could not create %s with specified index config '%s'. Expected a map from String to Strings, Integers and Booleans.", schemaType, input.prettify());
        return InvalidArgumentsException.invalidInput(input, GqlParams.StringParam.cmd.process((Object)"indexConfig"), List.of("MAP<STRING, BOOLEAN | STRING | INTEGER>"), oldMsg);
    }

    public static InvalidArgumentsException invalidVectorIndexConfigSetting(String schemaType, String settingName, String providedType, String validTypes, String validCypherTypes) {
        String oldMsg = String.format("Could not create %s with specified index config '%s'. Expected %s.", schemaType, settingName, validTypes);
        ErrorGqlStatusObject gql = GqlHelper.getGql22G03_22N27((String)("type " + providedType), (String)GqlParams.StringParam.cmd.process((Object)settingName), List.of(validCypherTypes));
        return new InvalidArgumentsException(gql, oldMsg);
    }

    public static InvalidArgumentsException invalidSeedRestoreOption(String operation, String key, AnyValue input) {
        String oldMsg = String.format("Could not %s with specified %s '%s', Integer or datetime expected.", operation, key, input);
        return InvalidArgumentsException.invalidInput(input, key, List.of("INTEGER", "DATETIME"), oldMsg);
    }

    public static InvalidArgumentsException invalidStringOption(String operation, String key, AnyValue input) {
        String oldMsg = String.format("Could not %s with specified %s '%s', String expected.", operation, key, input);
        return InvalidArgumentsException.invalidInput(input, key, List.of("STRING"), oldMsg);
    }

    public static InvalidArgumentsException pointOptionsInConfig(PrettyPrinter pp, MapValue itemsMap, String schemaType, List<String> validConfigSettingNames) {
        ErrorGqlStatusObject gql = InvalidArgumentsException.getIdxGql(itemsMap, validConfigSettingNames);
        return new InvalidArgumentsException(gql, String.format("%s, contains spatial config settings options.\nTo create point index, please use 'CREATE POINT INDEX ...'.", InvalidArgumentsException.invalidConfigValueString(pp, (AnyValue)itemsMap, schemaType)));
    }

    public static InvalidArgumentsException fulltextOptionsInConfig(PrettyPrinter pp, MapValue itemsMap, String schemaType, List<String> validConfigSettingNames) {
        ErrorGqlStatusObject gql = InvalidArgumentsException.getIdxGql(itemsMap, validConfigSettingNames);
        return new InvalidArgumentsException(gql, String.format("%s, contains fulltext config options.\nTo create fulltext index, please use 'CREATE FULLTEXT INDEX ...'.", InvalidArgumentsException.invalidConfigValueString(pp, (AnyValue)itemsMap, schemaType)));
    }

    public static InvalidArgumentsException vectorOptionsInConfig(PrettyPrinter pp, MapValue itemsMap, String schemaType, List<String> validConfigSettingNames) {
        ErrorGqlStatusObject gql = InvalidArgumentsException.getIdxGql(itemsMap, validConfigSettingNames);
        return new InvalidArgumentsException(gql, String.format("%s, contains vector config options.\nTo create vector index, please use 'CREATE VECTOR INDEX ...'.", InvalidArgumentsException.invalidConfigValueString(pp, (AnyValue)itemsMap, schemaType)));
    }

    public static InvalidArgumentsException expectedNonePrimarySecondary(String value, String modeConstraint, List<String> expected) {
        ErrorGqlStatusObject gql = GqlHelper.getGql42001_22N04((String)value, (String)modeConstraint, expected);
        return new InvalidArgumentsException(gql, String.format("%s expects 'NONE', 'PRIMARY' or 'SECONDARY' but got '%s'.", modeConstraint, value));
    }

    public static InvalidArgumentsException unrecognisedOptionGivenValue(String operation, String value, String key, String validValue, Boolean formatValidValuesForOld) {
        List<String> validValues = List.of(validValue);
        ErrorGqlStatusObject gql = GqlHelper.getGql42001_22N04((String)value, (String)key, validValues);
        if (formatValidValuesForOld.booleanValue()) {
            validValue = "'" + (String)validValue + "'";
        }
        return new InvalidArgumentsException(gql, String.format("Could not %s with specified %s '%s'. Expected %s.", operation, key, value, validValue));
    }

    public static InvalidArgumentsException unrecognisedOptionGivenValue(String operation, String key, String value, List<String> validValues) {
        ErrorGqlStatusObject gql = GqlHelper.getGql42001_22N04((String)value, (String)key, validValues);
        String validValuesString = validValues.stream().map(option -> "'" + option + "'").collect(Collectors.joining(", "));
        return new InvalidArgumentsException(gql, String.format("Could not %s with specified %s '%s', Expected one of %s.", operation, key, value, validValuesString));
    }

    public static InvalidArgumentsException unrecognisedOptionsOnlyKeys(String operation, String invalidKeys, List<String> permittedOptions) {
        String permittedOptionsString = String.join((CharSequence)", ", permittedOptions);
        ErrorGqlStatusObject gql = GqlHelper.getGql42001_22N04((String)invalidKeys, (String)GqlParams.StringParam.input.process((Object)"OPTIONS"), permittedOptions);
        return new InvalidArgumentsException(gql, String.format("Could not %s with unrecognised option(s): %s. Expected %s.", operation, invalidKeys, permittedOptionsString));
    }

    public static InvalidArgumentsException unrecognisedOptionsNoOperation(String invalidKey, List<String> permittedOptions) {
        String permittedOptionsString = permittedOptions.stream().map(option -> "'" + option + "'").collect(Collectors.joining(", "));
        ErrorGqlStatusObject gql = GqlHelper.getGql42001_22N04((String)invalidKey, (String)GqlParams.StringParam.input.process((Object)"OPTIONS"), permittedOptions);
        return new InvalidArgumentsException(gql, String.format("Unrecognised option '%s', expected %s.", invalidKey, permittedOptionsString));
    }

    public static InvalidArgumentsException unrecognisedCreateDbOptions(String operation, String invalidKeys, List<String> permittedOptions) {
        String permittedOptionsString = String.join((CharSequence)", ", permittedOptions);
        ErrorGqlStatusObject gql = GqlHelper.getGql42001_22N04((String)invalidKeys, (String)GqlParams.StringParam.input.process((Object)"OPTIONS"), permittedOptions);
        return new InvalidArgumentsException(gql, String.format("Could not %s with 'CREATE DATABASE' option(s): %s. Expected %s.", operation, invalidKeys, permittedOptionsString));
    }

    public static InvalidArgumentsException invalidDriverSettings(String operation, String invalidKeys, List<String> validKeys) {
        String validKeysString = String.join((CharSequence)", ", validKeys);
        ErrorGqlStatusObject gql = GqlHelper.getGql42001_22N04((String)invalidKeys, (String)GqlParams.StringParam.input.process((Object)"DRIVER"), validKeys);
        return new InvalidArgumentsException(gql, String.format("Failed to %s: Invalid driver setting(s) provided: %s. Valid driver settings are: %s", operation, invalidKeys, validKeysString));
    }

    public static InvalidArgumentsException invalidDriverSettingsValue(String operation, String key, String expectedType, String expectedCypherType, AnyValue input) {
        String oldMsg = String.format("Failed to %s: Invalid driver settings value for '%s'. Expected %s value.", operation, key, expectedType);
        return InvalidArgumentsException.invalidInput(input, key, List.of(expectedCypherType), oldMsg);
    }

    public static InvalidArgumentsException invalidDriverSettingsExpectedMap(String operation, AnyValue input) {
        String oldMsg = String.format("Failed to %s: Invalid driver settings '%s'. Expected a map value.", operation, input);
        return InvalidArgumentsException.invalidInput(input, GqlParams.StringParam.cmd.process((Object)"DRIVER"), List.of("MAP"), oldMsg);
    }

    public static InvalidArgumentsException invalidPropertiesExpectedMap(String operation, AnyValue input) {
        String oldMsg = String.format("Failed to %s: Invalid properties '%s'. Expected a map value.", operation, input);
        return InvalidArgumentsException.invalidInput(input, GqlParams.StringParam.cmd.process((Object)"PROPERTIES"), List.of("MAP"), oldMsg);
    }

    public static InvalidArgumentsException unexpectedDriverSettingValue(String operation, String value, String settingKey, List<String> validValues) {
        String validValuesString = String.join((CharSequence)", ", validValues);
        ErrorGqlStatusObject gql = GqlHelper.getGql42001_22N04((String)value, (String)GqlParams.StringParam.input.process((Object)"DRIVER"), validValues);
        return new InvalidArgumentsException(gql, String.format("Failed to %s: Invalid driver settings value for '%s'. Expected one of %s.", operation, settingKey, validValuesString));
    }

    public static InvalidArgumentsException invalidOptionFormat(String operation, String key, String value, List<String> validFormats) {
        ErrorGqlStatusObject gql = GqlHelper.getGql42001_22N04((String)value, (String)key, validFormats);
        String validFormatsString = validFormats.stream().map(format -> "'" + format + "'").collect(Collectors.joining(", "));
        return new InvalidArgumentsException(gql, String.format("Could not %s with specified %s '%s'. Unknown format, supported formats are %s", operation, key, value, validFormatsString));
    }

    public static InvalidArgumentsException missingOptionCreateSchema(String schemaType, List<String> option, String quotedOptions) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22N06).withParam(GqlParams.ListParam.inputList, option).build();
        return new InvalidArgumentsException(gql, String.format("Failed to create %s: Missing index config options %s.", schemaType, quotedOptions));
    }

    public static InvalidArgumentsException invalidOptionsExpectedMap(String operation, AnyValue input) {
        String oldMsg = String.format("Could not %s with options '%s'. Expected a map value.", operation, input);
        return InvalidArgumentsException.invalidInput(input, GqlParams.StringParam.cmd.process((Object)"OPTIONS"), List.of("MAP"), oldMsg);
    }

    public static InvalidArgumentsException compositeUsingOptions(String operation) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22N81((String)GqlParams.StringParam.cmd.process((Object)"OPTIONS"), (String)GqlParams.StringParam.cmd.process((Object)"CREATE COMPOSITE DATABASE"));
        return new InvalidArgumentsException(gql, String.format("Could not %s: composite databases have no valid options values.", operation));
    }

    public static InvalidArgumentsException noValidPropertyConstraintOptions(String entity, String constraintType) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22N81((String)GqlParams.StringParam.cmd.process((Object)"OPTIONS"), (String)String.format("%s property %s constraints", entity, constraintType));
        return new InvalidArgumentsException(gql, String.format("Could not create %s property %s constraint: property %s constraints have no valid options values.", entity, constraintType, constraintType));
    }

    public static InvalidArgumentsException connectionPoolSizeZeroNotAllowed(String operation, String pool_max_size) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22N05).withParam(GqlParams.StringParam.input, "0").withParam(GqlParams.StringParam.context, operation).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22N86).build()).build();
        return new InvalidArgumentsException(gql, String.format("Failed to %s: Invalid driver settings value for '%s'. Zero is not allowed.", operation, pool_max_size));
    }

    public static InvalidArgumentsException optionRequiresInteger(String option, Object value) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22G03_22N27((String)option, (String)value.getClass().getTypeName(), List.of("INTEGER"));
        return new InvalidArgumentsException(gql, String.format("Option `%s` requires integer argument, got `%s`", option, value));
    }

    public static InvalidArgumentsException inputContainsInvalidCharacters(String invalidInput, String context, String legacyMessage) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22N05).withParam(GqlParams.StringParam.input, invalidInput).withParam(GqlParams.StringParam.context, context).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22N82).withParam(GqlParams.StringParam.input, invalidInput).withParam(GqlParams.StringParam.context, context).build()).build();
        return new InvalidArgumentsException(gql, legacyMessage);
    }

    public static InvalidArgumentsException failedEvaluatingDriverSettings(Exception e) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42N89).withParam(GqlParams.StringParam.cause, e.getMessage()).build();
        return new InvalidArgumentsException(gql, "Failed evaluating the given driver settings.", e);
    }

    public static InvalidArgumentsException cannotAlterImmutableCompositeDb(String dbName) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42N90).withParam(GqlParams.StringParam.db, dbName).build();
        return new InvalidArgumentsException(gql, String.format("Failed to alter the specified database '%s': Composite databases cannot be altered.", dbName));
    }

    public static InvalidArgumentsException dbNameIsNotWellDefined(AnyValue input) {
        String oldMsg = "Could not create database - name is not well defined";
        return InvalidArgumentsException.invalidInput(input, "database name", List.of("STRING"), oldMsg);
    }

    public static InvalidArgumentsException expectedListOfTags(String key, AnyValue input, String listString) {
        String oldMsg = String.format("%s expects a list of tags but got '%s'.", key, listString);
        return InvalidArgumentsException.invalidInput(input, key, List.of("LIST<STRING>"), oldMsg);
    }

    public static InvalidArgumentsException expectedListOfTagsNames(String key, AnyValue input) {
        String oldMsg = String.format("%s expects a list of tags names but got '%s'.", key, input);
        return InvalidArgumentsException.invalidInput(input, key, List.of("LIST<STRING>"), oldMsg);
    }

    public static InvalidArgumentsException expectedListOfDatabaseNames(String action, String list, AnyValue input) {
        String oldMsg = String.format("%s expects a list of database names but got '%s'.", action, list);
        return InvalidArgumentsException.invalidInput(input, action, List.of("LIST<STRING>"), oldMsg);
    }

    public static InvalidArgumentsException driverSettingDurationNotPositive(String operation, String key, DurationValue duration) {
        String legacyMessage = "Failed to %s: Invalid driver settings value for '%s'. Negative duration is not allowed.".formatted(operation, key);
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22003).withParam(GqlParams.StringParam.value, duration.prettyPrint()).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22N03).withParam(GqlParams.StringParam.component, key).withParam(GqlParams.StringParam.valueType, "DURATION").withParam(GqlParams.StringParam.lower, DurationValue.ZERO.prettyPrint()).withParam(GqlParams.StringParam.upper, DurationValue.MAX_VALUE.prettyPrint()).withParam(GqlParams.StringParam.value, duration.prettyPrint()).build()).build();
        return new InvalidArgumentsException(gql, legacyMessage);
    }

    private static InvalidArgumentsException invalidInput(AnyValue input, String context, List<String> validTypes, String oldMessage) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22G03_22N27((String)input.prettify(), (String)context, validTypes);
        return new InvalidArgumentsException(gql, oldMessage);
    }
}

