/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.coreapi;

import org.neo4j.gqlstatus.ErrorGqlStatusObject;
import org.neo4j.gqlstatus.ErrorGqlStatusObjectImplementation;
import org.neo4j.gqlstatus.GqlStatusInfoCodes;
import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.graphdb.TransactionFailureHelper;
import org.neo4j.graphdb.TransientFailureException;
import org.neo4j.graphdb.TransientTransactionFailureException;
import org.neo4j.internal.kernel.api.exceptions.ConstraintViolationTransactionFailureException;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.impl.coreapi.TransactionExceptionMapper;
import org.neo4j.logging.Log;
import org.neo4j.monitoring.ExceptionHandlerService;

public class DefaultTransactionExceptionMapper
implements TransactionExceptionMapper {
    public static final DefaultTransactionExceptionMapper INSTANCE = new DefaultTransactionExceptionMapper();

    private DefaultTransactionExceptionMapper() {
    }

    @Override
    public RuntimeException mapException(Exception e, Log log, ExceptionHandlerService exceptionHandlerService) {
        if (e instanceof TransientFailureException) {
            TransientFailureException tfe = (TransientFailureException)e;
            return tfe;
        }
        if (e instanceof ConstraintViolationTransactionFailureException) {
            return new ConstraintViolationException(e.getMessage(), (Throwable)e);
        }
        if (e instanceof Status.HasStatus) {
            Status status = ((Status.HasStatus)e).status();
            return DefaultTransactionExceptionMapper.mapStatusException("Unable to complete transaction.: " + status.code().description(), status, e, exceptionHandlerService);
        }
        log.error(e.getMessage(), (Throwable)e);
        exceptionHandlerService.raiseException(e.getMessage(), (Throwable)e);
        if (e instanceof ErrorGqlStatusObject) {
            ErrorGqlStatusObject statusObject = (ErrorGqlStatusObject)e;
            return TransactionFailureHelper.genericFailure((ErrorGqlStatusObject)statusObject, (Throwable)e);
        }
        return TransactionFailureHelper.genericFailure((Throwable)e);
    }

    public static RuntimeException mapStatusException(String message, Status status, Exception cause, ExceptionHandlerService exceptionHandlerService) {
        ErrorGqlStatusObject gql;
        if (cause instanceof ErrorGqlStatusObject) {
            ErrorGqlStatusObject statusObject = (ErrorGqlStatusObject)cause;
            v0 = statusObject.gqlStatusObject();
        } else {
            v0 = gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_25N02).build();
        }
        if (status.code().classification() == Status.Classification.TransientError) {
            return new TransientTransactionFailureException(gql, status, message, (Throwable)cause);
        }
        exceptionHandlerService.raiseException(cause.getMessage(), (Throwable)cause);
        return new TransactionFailureException(gql, message, (Throwable)cause, status);
    }
}

