/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.Iterator;
import org.neo4j.internal.kernel.api.TokenRead;
import org.neo4j.internal.kernel.api.exceptions.LabelNotFoundKernelException;
import org.neo4j.internal.kernel.api.exceptions.PropertyKeyIdNotFoundKernelException;
import org.neo4j.internal.kernel.api.exceptions.RelationshipTypeIdNotFoundKernelException;
import org.neo4j.token.TokenHolders;
import org.neo4j.token.api.NamedToken;
import org.neo4j.token.api.TokenNotFoundException;

public class ReadOnlyTokenRead
implements TokenRead {
    private final TokenHolders tokenHolders;

    public ReadOnlyTokenRead(TokenHolders tokenHolders) {
        this.tokenHolders = tokenHolders;
    }

    public int nodeLabel(String name) {
        return this.tokenHolders.labelTokens().getIdByName(name);
    }

    public String nodeLabelName(int labelId) throws LabelNotFoundKernelException {
        try {
            return this.tokenHolders.labelTokens().getTokenById(labelId).name();
        }
        catch (TokenNotFoundException e) {
            throw LabelNotFoundKernelException.labelNotFound((int)labelId, (Exception)((Object)e));
        }
    }

    public int relationshipType(String name) {
        return this.tokenHolders.relationshipTypeTokens().getIdByName(name);
    }

    public String relationshipTypeName(int relationshipTypeId) throws RelationshipTypeIdNotFoundKernelException {
        try {
            return this.tokenHolders.relationshipTypeTokens().getTokenById(relationshipTypeId).name();
        }
        catch (TokenNotFoundException e) {
            throw RelationshipTypeIdNotFoundKernelException.relationshipTypeNotFound((int)relationshipTypeId, (Exception)((Object)e));
        }
    }

    public int propertyKey(String name) {
        return this.tokenHolders.propertyKeyTokens().getIdByName(name);
    }

    public String propertyKeyName(int propertyKeyId) throws PropertyKeyIdNotFoundKernelException {
        try {
            return this.tokenHolders.propertyKeyTokens().getTokenById(propertyKeyId).name();
        }
        catch (TokenNotFoundException e) {
            throw PropertyKeyIdNotFoundKernelException.propertyKeyIdNotFound((int)propertyKeyId, (Exception)((Object)e));
        }
    }

    public Iterator<NamedToken> labelsGetAllTokens() {
        return this.tokenHolders.labelTokens().getAllTokens().iterator();
    }

    public Iterator<NamedToken> propertyKeyGetAllTokens() {
        return this.tokenHolders.propertyKeyTokens().getAllTokens().iterator();
    }

    public Iterator<NamedToken> relationshipTypesGetAllTokens() {
        return this.tokenHolders.relationshipTypeTokens().getAllTokens().iterator();
    }

    public int labelCount() {
        return this.tokenHolders.labelTokens().size();
    }

    public int propertyKeyCount() {
        return this.tokenHolders.propertyKeyTokens().size();
    }

    public int relationshipTypeCount() {
        return this.tokenHolders.relationshipTypeTokens().size();
    }

    public String labelGetName(int labelId) {
        return this.tokenHolders.labelGetName(labelId);
    }

    public String relationshipTypeGetName(int relationshipTypeId) {
        return this.tokenHolders.relationshipTypeGetName(relationshipTypeId);
    }

    public String propertyKeyGetName(int propertyKeyId) {
        return this.tokenHolders.propertyKeyGetName(propertyKeyId);
    }
}

