/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Optional;
import java.util.stream.Stream;
import org.neo4j.function.ThrowingAction;
import org.neo4j.graphdb.Resource;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.io.IOUtils;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.database.Database;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointer;
import org.neo4j.kernel.impl.transaction.log.checkpoint.LatestCheckpointInfo;
import org.neo4j.kernel.impl.transaction.log.checkpoint.SimpleTriggerInfo;
import org.neo4j.kernel.impl.transaction.log.entry.LogFormat;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.logging.InternalLog;
import org.neo4j.storageengine.api.StoreResource;
import org.neo4j.storageengine.api.StoreSnapshot;
import org.neo4j.storageengine.api.TransactionId;

public class DefaultStoreSnapshotFactory
implements StoreSnapshot.Factory {
    private final Database database;
    private final FileSystemAbstraction fs;
    private final InternalLog log;

    public DefaultStoreSnapshotFactory(Database database, FileSystemAbstraction fs) {
        this.database = database;
        this.fs = fs;
        this.log = database.getInternalLogProvider().getLog(this.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<StoreSnapshot> createStoreSnapshot() throws IOException {
        Optional<StoreSnapshot> optional;
        boolean success;
        block4: {
            this.log.debug("Starting creating store snapshot");
            if (!this.database.getDatabaseAvailabilityGuard().isAvailable()) {
                this.log.warn("Unable to prepare a store snapshot because database '" + this.database.getNamedDatabaseId().name() + "' is unavailable");
                return Optional.empty();
            }
            CheckPointer checkPointer = (CheckPointer)this.database.getDependencyResolver().resolveDependency(CheckPointer.class);
            Resource checkpointMutex = this.tryCheckpointAndAcquireMutex(checkPointer);
            success = false;
            Stream<StoreResource> unrecoverableFiles = null;
            try {
                LatestCheckpointInfo latestCheckpointInfo = checkPointer.latestCheckPointInfo();
                TransactionId lastCommittedTransactionId = latestCheckpointInfo.highestObservedClosedTransactionId();
                long appendIndex = latestCheckpointInfo.appendIndex();
                LogFiles logFiles = (LogFiles)this.database.getDependencyResolver().resolveDependency(LogFiles.class);
                LogFormat logFormatAtCheckpoint = logFiles.getLogFile().extractHeader(latestCheckpointInfo.checkpointedLogPosition().getLogVersion()).getLogFormatVersion();
                unrecoverableFiles = this.unrecoverableFiles(this.database);
                Path[] recoverableFiles = this.recoverableFiles(this.database);
                StoreSnapshot snapshot = new StoreSnapshot(unrecoverableFiles, recoverableFiles, lastCommittedTransactionId, appendIndex, this.database.getStoreId(), checkpointMutex, logFormatAtCheckpoint);
                Optional<StoreSnapshot> result = Optional.of(snapshot);
                success = true;
                optional = result;
                if (success) break block4;
            }
            catch (Throwable throwable) {
                if (!success) {
                    IOUtils.closeAll((AutoCloseable[])new AutoCloseable[]{unrecoverableFiles, checkpointMutex});
                }
                this.log.debug("Creating store snapshot complete, success=%s", new Object[]{success});
                throw throwable;
            }
            IOUtils.closeAll((AutoCloseable[])new AutoCloseable[]{unrecoverableFiles, checkpointMutex});
        }
        this.log.debug("Creating store snapshot complete, success=%s", new Object[]{success});
        return optional;
    }

    protected Stream<StoreResource> unrecoverableFiles(Database database) throws IOException {
        Path databaseDirectory = database.getDatabaseLayout().databaseDirectory();
        return database.getStoreFileListing().builder().excludeAll().includeAtomicStorageFiles().includeAdditionalProviders().includeSchemaIndexStoreFiles().includeIdFiles().build().stream().map(metadata -> this.toStoreResource(databaseDirectory, (Path)metadata));
    }

    private Path[] recoverableFiles(Database database) throws IOException {
        try (ResourceIterator<Path> recoverableFiles = database.getStoreFileListing().builder().excludeAll().includeReplayableStorageFiles().build();){
            Path[] pathArray = (Path[])recoverableFiles.stream().toArray(Path[]::new);
            return pathArray;
        }
    }

    private Resource tryCheckpointAndAcquireMutex(CheckPointer checkPointer) throws IOException {
        return this.database.getStoreCopyCheckPointMutex().storeCopy((ThrowingAction<IOException>)((ThrowingAction)() -> checkPointer.tryCheckPoint(new SimpleTriggerInfo("Store copy"))));
    }

    private StoreResource toStoreResource(Path databaseDirectory, Path storeFile) {
        String relativePath = databaseDirectory.relativize(storeFile).toString();
        return new StoreResource(storeFile, relativePath, this.fs);
    }
}

