/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.files;

import java.io.IOException;
import java.nio.file.Path;
import java.time.Instant;
import java.util.Collections;
import org.neo4j.common.Subject;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.exceptions.UnderlyingStorageException;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.KernelVersionProvider;
import org.neo4j.kernel.database.MetadataCache;
import org.neo4j.kernel.impl.transaction.log.CompleteCommandBatch;
import org.neo4j.kernel.impl.transaction.log.LogAppendEvent;
import org.neo4j.kernel.impl.transaction.log.LogForceEvents;
import org.neo4j.kernel.impl.transaction.log.LogFormatVersionProvider;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.TransactionLogWriter;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckpointAppender;
import org.neo4j.kernel.impl.transaction.log.files.LogFile;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.LogFilesBuilder;
import org.neo4j.kernel.impl.transaction.log.files.LogFilesSpan;
import org.neo4j.kernel.impl.transaction.log.files.LogRangeInfo;
import org.neo4j.kernel.impl.transaction.log.files.checkpoint.CheckpointFile;
import org.neo4j.kernel.impl.transaction.tracing.LogCheckPointEvent;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.Lifespan;
import org.neo4j.logging.InternalLog;
import org.neo4j.logging.NullLog;
import org.neo4j.monitoring.DatabaseHealth;
import org.neo4j.monitoring.HealthEventGenerator;
import org.neo4j.storageengine.AppendIndexProvider;
import org.neo4j.storageengine.api.LogFilesInitializer;
import org.neo4j.storageengine.api.LogVersionRepository;
import org.neo4j.storageengine.api.MetadataProvider;
import org.neo4j.storageengine.api.StorageEngineFactory;
import org.neo4j.storageengine.api.TransactionId;
import org.neo4j.storageengine.api.TransactionIdStore;

public class TransactionLogInitializer {
    private final FileSystemAbstraction fs;
    private final MetadataProvider metadataProvider;
    private final StorageEngineFactory storageEngineFactory;
    private final MetadataCache metadataCache;

    public static LogFilesInitializer getLogFilesInitializer() {
        return new LogFilesInitializer(){

            public void initializeLogFiles(DatabaseLayout databaseLayout, MetadataProvider metadataProvider, MetadataCache metadataCache, FileSystemAbstraction fileSystem, String checkpointReason, Config config) {
                try {
                    TransactionLogInitializer initializer = new TransactionLogInitializer(fileSystem, metadataProvider, (StorageEngineFactory)StorageEngineFactory.selectStorageEngine((FileSystemAbstraction)fileSystem, (DatabaseLayout)databaseLayout).orElseThrow(), metadataCache);
                    initializer.initializeEmptyLogFile(databaseLayout, databaseLayout.getTransactionLogsDirectory(), checkpointReason, config);
                }
                catch (IOException e) {
                    throw new UnderlyingStorageException("Failed to initialize transaction log files.", (Throwable)e);
                }
            }

            public void clearHistoryAndInitializeLogFiles(DatabaseLayout databaseLayout, MetadataProvider metadataProvider, MetadataCache metadataCache, FileSystemAbstraction fileSystem, String checkpointReason) {
                try {
                    TransactionLogInitializer initializer = new TransactionLogInitializer(fileSystem, metadataProvider, (StorageEngineFactory)StorageEngineFactory.selectStorageEngine((FileSystemAbstraction)fileSystem, (DatabaseLayout)databaseLayout).orElseThrow(), metadataCache);
                    initializer.migrateExistingLogFiles(databaseLayout, databaseLayout.getTransactionLogsDirectory(), checkpointReason, Config.defaults());
                }
                catch (Exception e) {
                    throw new UnderlyingStorageException("Failed to clear history and initialize transaction log files.", (Throwable)e);
                }
            }
        };
    }

    public TransactionLogInitializer(FileSystemAbstraction fs, MetadataProvider metadataProvider, StorageEngineFactory storageEngineFactory, MetadataCache metadataCache) {
        this.fs = fs;
        this.metadataProvider = metadataProvider;
        this.storageEngineFactory = storageEngineFactory;
        this.metadataCache = metadataCache;
    }

    public long initializeEmptyLogFile(DatabaseLayout layout, Path transactionLogsDirectory, String checkpointReason, Config config) throws IOException {
        try (LogFilesSpan span = this.buildLogFiles(layout, transactionLogsDirectory, config);){
            LogFiles logFiles = span.getLogFiles();
            long l = this.appendEmptyTransactionAndCheckPoint(logFiles, checkpointReason);
            return l;
        }
    }

    public long migrateExistingLogFiles(DatabaseLayout layout, Path transactionLogsDirectory, String checkpointReason, Config config) throws Exception {
        try (LogFilesSpan span = this.buildLogFiles(layout, transactionLogsDirectory, config);){
            LogFiles logFiles = span.getLogFiles();
            LogFile logFile = logFiles.getLogFile();
            LogRangeInfo logRangeInfo = logFile.getLogRangeInfo();
            for (long version = logRangeInfo.lowestVersion(); version <= logRangeInfo.highestVersion(); ++version) {
                this.fs.deleteFile(logFile.getLogFileForVersion(version));
            }
            CheckpointFile checkpointFile = logFiles.getCheckpointFile();
            LogRangeInfo checkpointLogVersionRange = checkpointFile.getLogRangeInfo();
            for (long version = checkpointLogVersionRange.lowestVersion(); version <= checkpointLogVersionRange.highestVersion(); ++version) {
                this.fs.deleteFile(checkpointFile.getLogFileForVersion(version));
            }
            logFile.rotate();
            checkpointFile.rotate();
            long l = this.appendEmptyTransactionAndCheckPoint(logFiles, checkpointReason);
            return l;
        }
    }

    private LogFilesSpan buildLogFiles(DatabaseLayout layout, Path transactionLogsDirectory, Config config) throws IOException {
        LogFilesBuilder builder = LogFilesBuilder.builder(layout, this.fs, (KernelVersionProvider)this.metadataCache, (LogFormatVersionProvider)this.metadataCache).withLogVersionRepository((LogVersionRepository)this.metadataProvider).withTransactionIdStore((TransactionIdStore)this.metadataProvider).withAppendIndexProvider((AppendIndexProvider)this.metadataProvider).withStoreId(this.metadataProvider.getStoreId()).withLogsDirectory(transactionLogsDirectory).withStorageEngineFactory(this.storageEngineFactory).withConfig(config).withDatabaseHealth(new DatabaseHealth(HealthEventGenerator.NO_OP, (InternalLog)NullLog.getInstance()));
        if (this.metadataCache.kernelVersion() == KernelVersion.GLORIOUS_FUTURE) {
            builder.withConfig(Config.defaults((Setting)GraphDatabaseInternalSettings.latest_kernel_version, (Object)this.metadataCache.kernelVersion().version()));
        }
        LogFiles logFiles = builder.build();
        return new LogFilesSpan(new Lifespan(new Lifecycle[]{logFiles}), logFiles);
    }

    private long appendEmptyTransactionAndCheckPoint(LogFiles logFiles, String reason) throws IOException {
        TransactionId committedTx = this.metadataProvider.getLastCommittedTransaction();
        long consensusIndex = -1L;
        long timestamp = committedTx.commitTimestamp();
        long upgradeTransactionId = this.metadataProvider.nextCommittingTransactionId();
        long appendIndex = this.metadataProvider.nextAppendIndex();
        KernelVersion kernelVersion = this.metadataCache.kernelVersion();
        LogFile logFile = logFiles.getLogFile();
        TransactionLogWriter transactionLogWriter = logFile.getTransactionLogWriter();
        CompleteCommandBatch emptyTx = TransactionLogInitializer.emptyTransaction(timestamp, upgradeTransactionId, kernelVersion, consensusIndex);
        int checksum = transactionLogWriter.append(emptyTx, upgradeTransactionId, 0L, appendIndex, -559063315, 0L, LogAppendEvent.NULL);
        logFile.forceAfterAppend((LogForceEvents)LogAppendEvent.NULL);
        LogPosition position = transactionLogWriter.getCurrentPosition();
        TransactionLogInitializer.appendCheckpoint(logFiles, reason, position, new TransactionId(upgradeTransactionId, appendIndex, kernelVersion, checksum, timestamp, consensusIndex), appendIndex, kernelVersion);
        this.metadataProvider.transactionCommitted(upgradeTransactionId, appendIndex, kernelVersion, checksum, timestamp, consensusIndex);
        return upgradeTransactionId;
    }

    private static CompleteCommandBatch emptyTransaction(long timestamp, long txId, KernelVersion kernelVersion, long consensusIndex) {
        return new CompleteCommandBatch(Collections.emptyList(), consensusIndex, timestamp, txId, timestamp, -1, kernelVersion, Subject.ANONYMOUS);
    }

    private static void appendCheckpoint(LogFiles logFiles, String reason, LogPosition position, TransactionId transactionId, long appendIndex, KernelVersion version) throws IOException {
        CheckpointAppender checkpointAppender = logFiles.getCheckpointFile().getCheckpointAppender();
        checkpointAppender.checkPoint(LogCheckPointEvent.NULL, transactionId, appendIndex, version, position, position, Instant.now(), reason);
    }
}

