/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.logging.internal;

import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.logging.AbstractLogProvider;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.logging.internal.DatabaseLog;

public class DatabaseLogProvider
extends AbstractLogProvider<DatabaseLog> {
    private final InternalLogProvider logProvider;
    private final String prefix;
    private final String databaseName;
    private final String databaseId;

    public DatabaseLogProvider(NamedDatabaseId namedDatabaseId, InternalLogProvider logProvider) {
        this.logProvider = logProvider;
        this.prefix = namedDatabaseId.logPrefix();
        this.databaseName = namedDatabaseId.name();
        this.databaseId = namedDatabaseId.databaseId().uuid().toString();
    }

    private DatabaseLogProvider() {
        this.logProvider = NullLogProvider.getInstance();
        this.prefix = "";
        this.databaseName = "";
        this.databaseId = "";
    }

    public static DatabaseLogProvider nullDatabaseLogProvider() {
        return new DatabaseLogProvider();
    }

    protected DatabaseLog buildLog(Class<?> loggingClass) {
        return new DatabaseLog(this.prefix, this.databaseName, this.databaseId, this.logProvider.getLog(loggingClass));
    }

    protected DatabaseLog buildLog(String name) {
        return new DatabaseLog(this.prefix, this.databaseName, this.databaseId, this.logProvider.getLog(name));
    }
}

