/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.function.Supplier;
import org.neo4j.exceptions.KernelException;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.kernel.api.Kernel;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.storageengine.VectorStoreCreator;
import org.neo4j.values.storable.Vector;

public final class IsolatedTransactionVectorStoreCreator
implements VectorStoreCreator {
    private final Supplier<Kernel> kernelSupplier;

    public IsolatedTransactionVectorStoreCreator(Supplier<Kernel> kernelSupplier) {
        this.kernelSupplier = kernelSupplier;
    }

    public synchronized void createVectorStore(Vector.CoordinateType coordinateType, int dimensions) throws KernelException {
        Kernel kernel = this.kernelSupplier.get();
        try (KernelTransaction tx = kernel.beginTransaction(KernelTransaction.Type.IMPLICIT, LoginContext.AUTH_DISABLED);){
            tx.dataWrite().createVectorStore(coordinateType, dimensions);
            tx.commit();
        }
    }
}

