/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.neo4j.io.fs.ReadableChannel;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogPositionMarker;
import org.neo4j.kernel.impl.transaction.log.ReadableLogPositionAwareChannel;
import org.neo4j.util.Preconditions;

public class DelegateReadableChannel
implements ReadableLogPositionAwareChannel {
    private ReadableChannel delegate;

    public DelegateReadableChannel() {
    }

    public DelegateReadableChannel(ReadableChannel delegate) {
        this.delegate = delegate;
    }

    public void delegateTo(ReadableChannel delegate) {
        this.delegate = delegate;
    }

    public byte get() throws IOException {
        this.assertAssigned();
        return this.delegate.get();
    }

    public short getShort() throws IOException {
        this.assertAssigned();
        return this.delegate.getShort();
    }

    public int getInt() throws IOException {
        this.assertAssigned();
        return this.delegate.getInt();
    }

    public long getLong() throws IOException {
        this.assertAssigned();
        return this.delegate.getLong();
    }

    public float getFloat() throws IOException {
        this.assertAssigned();
        return this.delegate.getFloat();
    }

    public double getDouble() throws IOException {
        this.assertAssigned();
        return this.delegate.getDouble();
    }

    public void get(byte[] bytes, int length) throws IOException {
        this.assertAssigned();
        this.delegate.get(bytes, length);
    }

    public byte getVersion() throws IOException {
        return this.delegate.getVersion();
    }

    public long getAppendIndex() throws IOException {
        return this.delegate.getAppendIndex();
    }

    public byte markAndGetVersion(LogPositionMarker marker) throws IOException {
        ReadableChannel readableChannel = this.delegate;
        if (readableChannel instanceof ReadableLogPositionAwareChannel) {
            ReadableLogPositionAwareChannel posChannel = (ReadableLogPositionAwareChannel)readableChannel;
            return posChannel.markAndGetVersion(marker);
        }
        return super.markAndGetVersion(marker);
    }

    public boolean rewindAfterMarkAndGetVersion() {
        return false;
    }

    public LogPositionMarker getCurrentLogPosition(LogPositionMarker positionMarker) {
        positionMarker.unspecified();
        return positionMarker;
    }

    public LogPosition getCurrentLogPosition() {
        return LogPosition.UNSPECIFIED;
    }

    public void setLogPosition(LogPositionMarker positionMarker) {
        this.assertAssigned();
    }

    public boolean isOpen() {
        this.assertAssigned();
        return this.delegate.isOpen();
    }

    public void close() {
    }

    public void beginChecksum() {
    }

    public int getChecksum() {
        return 0;
    }

    public int endChecksumAndValidate() {
        return 0;
    }

    public int read(ByteBuffer dst) throws IOException {
        this.assertAssigned();
        return this.delegate.read(dst);
    }

    public long position() throws IOException {
        this.assertAssigned();
        return this.delegate.position();
    }

    public void position(long byteOffset) throws IOException {
        this.assertAssigned();
        this.delegate.position(byteOffset);
    }

    private void assertAssigned() {
        Preconditions.checkArgument((this.delegate != null ? 1 : 0) != 0, (String)"No assigned channel to delegate reads");
    }
}

