/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.recovery;

import java.io.IOException;
import org.neo4j.configuration.Config;
import org.neo4j.graphdb.config.Configuration;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.KernelVersionProvider;
import org.neo4j.kernel.KernelVersionProviders;
import org.neo4j.kernel.database.DatabaseTracers;
import org.neo4j.kernel.impl.transaction.log.LogFormatVersionProvider;
import org.neo4j.kernel.impl.transaction.log.LogTailMetadata;
import org.neo4j.kernel.impl.transaction.log.entry.LogFormat;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.LogFilesBuilder;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.StorageEngineFactory;

public class LogTailExtractor {
    private final FileSystemAbstraction fs;
    private final Config config;
    private final StorageEngineFactory storageEngineFactory;
    private final DatabaseTracers databaseTracers;
    private final boolean readOnly;

    public LogTailExtractor(FileSystemAbstraction fs, Config config, StorageEngineFactory storageEngineFactory, DatabaseTracers databaseTracers) {
        this(fs, config, storageEngineFactory, databaseTracers, true);
    }

    public LogTailExtractor(FileSystemAbstraction fs, Config config, StorageEngineFactory storageEngineFactory, DatabaseTracers databaseTracers, boolean readOnly) {
        this.fs = fs;
        this.config = config;
        this.storageEngineFactory = storageEngineFactory;
        this.databaseTracers = databaseTracers;
        this.readOnly = readOnly;
    }

    public LogTailMetadata getTailMetadata(DatabaseLayout databaseLayout, MemoryTracker memoryTracker) throws IOException {
        return this.buildLogFiles(databaseLayout, memoryTracker, KernelVersionProviders.latestFromConfig((Configuration)this.config)).getTailMetadata();
    }

    public LogTailMetadata getTailMetadata(DatabaseLayout databaseLayout, MemoryTracker memoryTracker, KernelVersionProvider emptyLogsFallbackKernelVersionProvider) throws IOException {
        return this.buildLogFiles(databaseLayout, memoryTracker, emptyLogsFallbackKernelVersionProvider).getTailMetadata();
    }

    private LogFiles buildLogFiles(DatabaseLayout databaseLayout, MemoryTracker memoryTracker, KernelVersionProvider kernelVersionProvider) throws IOException {
        LogFormatVersionProvider emptyLogsFormatProvider = () -> LogFormat.fromConfigAndKernelVersion((Config)this.config, (KernelVersion)kernelVersionProvider.kernelVersion());
        LogFilesBuilder builder = this.readOnly ? LogFilesBuilder.readOnlyBuilder(databaseLayout, this.fs, kernelVersionProvider, emptyLogsFormatProvider) : LogFilesBuilder.activeFilesBuilder(databaseLayout, this.fs, kernelVersionProvider, emptyLogsFormatProvider);
        return builder.withConfig(this.config).withMemoryTracker(memoryTracker).withDatabaseTracers(this.databaseTracers).withStorageEngineFactory(this.storageEngineFactory).build();
    }
}

