/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.database;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.neo4j.kernel.database.DatabaseId;
import org.neo4j.kernel.database.DatabaseIdRepository;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.database.NormalizedDatabaseName;

public class MapCachingDatabaseIdRepository
implements DatabaseIdRepository.Caching {
    private volatile DatabaseIdRepository delegate;
    private volatile Map<NormalizedDatabaseName, NamedDatabaseId> databaseIdsByName;
    private volatile Map<DatabaseId, NamedDatabaseId> databaseIdsByUuid;
    private volatile Map<DatabaseId, NamedDatabaseId> owningDatabaseIdsByUuid;

    public MapCachingDatabaseIdRepository(DatabaseIdRepository delegate) {
        this.delegate = delegate;
        this.databaseIdsByName = new ConcurrentHashMap<NormalizedDatabaseName, NamedDatabaseId>();
        this.databaseIdsByUuid = new ConcurrentHashMap<DatabaseId, NamedDatabaseId>();
        this.owningDatabaseIdsByUuid = new ConcurrentHashMap<DatabaseId, NamedDatabaseId>();
    }

    public MapCachingDatabaseIdRepository() {
        this(null);
    }

    public void setDelegate(DatabaseIdRepository databaseIdRepository) {
        this.delegate = databaseIdRepository;
    }

    public Optional<NamedDatabaseId> getByName(NormalizedDatabaseName databaseName) {
        Optional<NamedDatabaseId> dbId = Optional.ofNullable(this.databaseIdsByName.computeIfAbsent(databaseName, name -> this.delegate.getByName(name).orElse(null)));
        dbId.ifPresent(id -> this.databaseIdsByUuid.put(id.databaseId(), (NamedDatabaseId)id));
        return dbId;
    }

    public Optional<NamedDatabaseId> getById(DatabaseId uuid) {
        Optional<NamedDatabaseId> dbId = Optional.ofNullable(this.databaseIdsByUuid.computeIfAbsent(uuid, id -> this.delegate.getById(id).orElse(null)));
        dbId.ifPresent(id -> this.databaseIdsByName.put(id.normalizedName(), (NamedDatabaseId)id));
        return dbId;
    }

    public Optional<NamedDatabaseId> getOwningDatabaseId(DatabaseId uuid) {
        return Optional.ofNullable(this.owningDatabaseIdsByUuid.computeIfAbsent(uuid, id -> this.delegate.getOwningDatabaseId(id).orElse(null)));
    }

    public void invalidateAll() {
        this.databaseIdsByName = new ConcurrentHashMap<NormalizedDatabaseName, NamedDatabaseId>();
        this.databaseIdsByUuid = new ConcurrentHashMap<DatabaseId, NamedDatabaseId>();
        this.owningDatabaseIdsByUuid = new ConcurrentHashMap<DatabaseId, NamedDatabaseId>();
    }
}

