/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import org.neo4j.storageengine.api.StorageEngineTransaction;

public class TransactionQueue {
    private final int maxSize;
    private final Applier applier;
    private StorageEngineTransaction tail;
    private StorageEngineTransaction head;
    private int size;

    public TransactionQueue(int maxSize, Applier applier) {
        this.maxSize = maxSize;
        this.applier = applier;
    }

    public boolean willQueueWithCurrentBatch(StorageEngineTransaction transaction) {
        return this.isEmpty() || transaction.commandBatch().kernelVersion() == this.tail.commandBatch().kernelVersion();
    }

    public void queue(StorageEngineTransaction transaction) throws Exception {
        if (this.isNotEmpty()) {
            if (transaction.commandBatch().kernelVersion() != this.tail.commandBatch().kernelVersion()) {
                this.applyTransactions();
                this.queue(transaction);
                return;
            }
            this.tail.next(transaction);
        } else {
            this.head = transaction;
        }
        this.tail = transaction;
        if (++this.size == this.maxSize) {
            this.applyTransactions();
        }
    }

    public void applyTransactions() throws Exception {
        if (this.isNotEmpty()) {
            this.applier.apply(this.head);
            this.tail = null;
            this.head = null;
            this.size = 0;
        }
    }

    private boolean isEmpty() {
        return this.size == 0;
    }

    private boolean isNotEmpty() {
        return !this.isEmpty();
    }

    @FunctionalInterface
    public static interface Applier {
        public void apply(StorageEngineTransaction var1) throws Exception;
    }
}

