/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.api.set.primitive.LongSet;
import org.eclipse.collections.impl.factory.primitive.LongSets;
import org.eclipse.collections.impl.iterator.ImmutableEmptyLongIterator;
import org.neo4j.internal.kernel.api.EntityIndexCursor;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.kernel.api.KernelReadTracer;
import org.neo4j.internal.kernel.api.PropertyIndexQuery;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.ValueIndexCursor;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexOrder;
import org.neo4j.internal.schema.IndexQuery;
import org.neo4j.kernel.api.AccessModeProvider;
import org.neo4j.kernel.api.index.IndexProgressor;
import org.neo4j.kernel.api.txstate.TransactionState;
import org.neo4j.kernel.api.txstate.TxStateHolder;
import org.neo4j.kernel.impl.newapi.CursorPool;
import org.neo4j.kernel.impl.newapi.EntityIndexSeekClient;
import org.neo4j.kernel.impl.newapi.EntityWithPropertyValues;
import org.neo4j.kernel.impl.newapi.IndexCursor;
import org.neo4j.kernel.impl.newapi.SortedMergeJoin;
import org.neo4j.kernel.impl.newapi.TxStateIndexChanges;
import org.neo4j.storageengine.api.PropertySelection;
import org.neo4j.storageengine.api.txstate.ReadableTransactionState;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueTuple;

public abstract class DefaultEntityValueIndexCursor<CURSOR>
extends IndexCursor<IndexProgressor, CURSOR>
implements ValueIndexCursor,
EntityIndexSeekClient,
SortedMergeJoin.Sink,
EntityIndexCursor {
    protected Read read;
    protected TxStateHolder txStateHolder;
    protected AccessModeProvider accessModeProvider;
    protected AccessMode accessMode;
    protected long entity = -1L;
    private float score;
    private PropertyIndexQuery[] query;
    private Value[] values;
    private LongIterator added = ImmutableEmptyLongIterator.INSTANCE;
    private Iterator<EntityWithPropertyValues> addedWithValues = Collections.emptyIterator();
    private LongSet removed = LongSets.immutable.empty();
    private boolean needsValues;
    private IndexOrder indexOrder;
    private final SortedMergeJoin sortedMergeJoin = new SortedMergeJoin();
    private boolean shortcutSecurity;
    private boolean needStoreFilter;
    private PropertySelection propertySelection;
    protected final boolean applyAccessModeToTxState;
    private int numberOfProperties;

    DefaultEntityValueIndexCursor(CursorPool<CURSOR> pool, boolean applyAccessModeToTxState) {
        super(pool);
        this.score = Float.NaN;
        this.indexOrder = IndexOrder.NONE;
        this.applyAccessModeToTxState = applyAccessModeToTxState;
    }

    public final void initializeQuery(IndexDescriptor descriptor, IndexProgressor progressor, boolean indexIncludesTransactionState, boolean needStoreFilter, IndexQueryConstraints constraints, PropertyIndexQuery ... query) {
        assert (query != null);
        super.initialize(progressor);
        this.indexOrder = constraints.order();
        this.needsValues = constraints.needsValues();
        this.needStoreFilter = needStoreFilter;
        this.propertySelection = PropertySelection.selection((int[])DefaultEntityValueIndexCursor.indexQueryKeys(query));
        this.sortedMergeJoin.initialize(this.indexOrder);
        this.numberOfProperties = descriptor.schema().getPropertyIds().length;
        this.query = query;
        if (this.tracer != null) {
            this.tracer.onIndexSeek(descriptor);
        }
        this.shortcutSecurity = this.canAccessAllDescribedEntities(descriptor);
        if (!indexIncludesTransactionState && this.txStateHolder.hasTxStateWithChanges() && query.length > 0) {
            int i;
            ArrayList<Value> exactQueryValues = new ArrayList<Value>(query.length);
            for (i = 0; i < query.length && query[i].type() == IndexQuery.IndexQueryType.EXACT; ++i) {
                exactQueryValues.add(((PropertyIndexQuery.ExactPredicate)query[i]).value());
            }
            Value[] exactValues = exactQueryValues.toArray(new Value[0]);
            if (i == query.length) {
                this.indexOrder = IndexOrder.NONE;
                this.seekQuery(descriptor, exactValues);
            } else {
                PropertyIndexQuery nextQuery = query[i];
                switch (nextQuery.type()) {
                    case ALL_ENTRIES: 
                    case EXISTS: {
                        this.setNeedsValuesIfRequiresOrder();
                        if (exactQueryValues.isEmpty()) {
                            this.scanQuery(descriptor);
                            break;
                        }
                        this.rangeQuery(descriptor, exactValues, null);
                        break;
                    }
                    case RANGE: {
                        this.setNeedsValuesIfRequiresOrder();
                        this.rangeQuery(descriptor, exactValues, (PropertyIndexQuery.RangePredicate)nextQuery);
                        break;
                    }
                    case BOUNDING_BOX: {
                        this.setNeedsValuesIfRequiresOrder();
                        this.boundingBoxQuery(descriptor, exactValues, (PropertyIndexQuery.BoundingBoxPredicate)nextQuery);
                        break;
                    }
                    case STRING_PREFIX: {
                        this.setNeedsValuesIfRequiresOrder();
                        this.prefixQuery(descriptor, exactValues, (PropertyIndexQuery.StringPrefixPredicate)nextQuery);
                        break;
                    }
                    case STRING_SUFFIX: 
                    case STRING_CONTAINS: {
                        assert (query.length == 1);
                        this.suffixOrContainsQuery(descriptor, nextQuery);
                        break;
                    }
                    case NEAREST_NEIGHBORS: {
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("Query not supported: " + Arrays.toString(query));
                    }
                }
            }
        }
    }

    private void setNeedsValuesIfRequiresOrder() {
        if (this.indexOrder != IndexOrder.NONE) {
            this.needsValues = true;
        }
    }

    private boolean isRemoved(long reference) {
        return this.removed.contains(reference);
    }

    public final boolean acceptEntity(long reference, float score, Value ... values) {
        if (this.isRemoved(reference) || !this.allowed(reference) || !this.storeValuePassesQueryFilter(reference)) {
            return false;
        }
        this.entity = reference;
        this.score = score;
        this.values = values;
        return true;
    }

    private boolean storeValuePassesQueryFilter(long reference) {
        if (!this.needStoreFilter) {
            return true;
        }
        return this.doStoreValuePassesQueryFilter(reference, this.propertySelection, this.query);
    }

    protected abstract boolean doStoreValuePassesQueryFilter(long var1, PropertySelection var3, PropertyIndexQuery[] var4);

    public final boolean needsValues() {
        return this.needsValues;
    }

    public boolean next() {
        if (this.indexOrder == IndexOrder.NONE) {
            return this.nextWithoutOrder();
        }
        return this.nextWithOrdering();
    }

    private boolean nextWithoutOrder() {
        if (!this.needsValues && this.added.hasNext()) {
            while (this.added.hasNext()) {
                long next = this.added.next();
                if (this.applyAccessModeToTxState && !this.allowed(next)) continue;
                this.entity = next;
                this.values = null;
                if (this.tracer != null) {
                    this.traceOnEntity(this.tracer, this.entity);
                }
                return true;
            }
        }
        if (this.needsValues && this.addedWithValues.hasNext()) {
            while (this.addedWithValues.hasNext()) {
                EntityWithPropertyValues entityWithPropertyValues = this.addedWithValues.next();
                long entityId = entityWithPropertyValues.getEntityId();
                if (this.applyAccessModeToTxState && !this.allowed(entityId)) continue;
                this.entity = entityId;
                this.values = entityWithPropertyValues.getValues();
                if (this.tracer != null) {
                    this.traceOnEntity(this.tracer, this.entity);
                }
                return true;
            }
        }
        if (this.added.hasNext() || this.addedWithValues.hasNext()) {
            throw new IllegalStateException("Index cursor cannot have transaction state with values and without values simultaneously");
        }
        boolean next = this.indexNext();
        if (this.tracer != null && next) {
            this.traceOnEntity(this.tracer, this.entity);
        }
        return next;
    }

    private boolean nextWithOrdering() {
        if (this.sortedMergeJoin.needsA() && this.addedWithValues.hasNext()) {
            while (this.addedWithValues.hasNext()) {
                EntityWithPropertyValues entityWithPropertyValues = this.addedWithValues.next();
                if (this.applyAccessModeToTxState && !this.allowed(entityWithPropertyValues.getEntityId())) continue;
                this.sortedMergeJoin.setA(entityWithPropertyValues.getEntityId(), entityWithPropertyValues.getValues());
                break;
            }
        }
        if (this.sortedMergeJoin.needsB()) {
            while (this.indexNext()) {
                if (this.applyAccessModeToTxState && !this.allowed(this.entity)) continue;
                this.sortedMergeJoin.setB(this.entity, this.values);
                break;
            }
        }
        boolean next = this.sortedMergeJoin.next(this);
        if (this.tracer != null && next) {
            this.traceOnEntity(this.tracer, this.entity);
        }
        return next;
    }

    @Override
    public final void acceptSortedMergeJoin(long entityId, Value[] values) {
        this.entity = entityId;
        this.values = values;
    }

    @Override
    public final void initState(Read read, TxStateHolder txStateHolder, AccessModeProvider accessModeProvider) {
        this.read = read;
        this.txStateHolder = txStateHolder;
        this.accessModeProvider = accessModeProvider;
        this.accessMode = accessModeProvider.getAccessMode();
    }

    public final int numberOfProperties() {
        return this.numberOfProperties;
    }

    public final boolean hasValue() {
        return this.values != null;
    }

    public final float score() {
        return this.score;
    }

    public final Value propertyValue(int offset) {
        return this.values[offset];
    }

    @Override
    public final void closeInternal() {
        if (!this.isClosed()) {
            this.closeProgressor();
            this.entity = -1L;
            this.score = Float.NaN;
            this.query = null;
            this.values = null;
            this.read = null;
            this.txStateHolder = null;
            this.accessModeProvider = null;
            this.accessMode = null;
            this.added = ImmutableEmptyLongIterator.INSTANCE;
            this.addedWithValues = Collections.emptyIterator();
            this.removed = LongSets.immutable.empty();
            this.numberOfProperties = 0;
        }
        super.closeInternal();
    }

    public final boolean isClosed() {
        return this.isProgressorClosed();
    }

    public String toString() {
        if (this.isClosed()) {
            return this.implementationName() + "[closed state]";
        }
        String keys = this.query == null ? "unknown" : Arrays.toString(Arrays.stream(this.query).map(PropertyIndexQuery::propertyKeyId).toArray(Integer[]::new));
        return this.implementationName() + "[entity=" + this.entity + ", open state with: keys=" + keys + ", values=" + Arrays.toString(this.values) + "]";
    }

    private void prefixQuery(IndexDescriptor descriptor, Value[] equalityPrefix, PropertyIndexQuery.StringPrefixPredicate predicate) {
        TransactionState txState = this.txStateHolder.txState();
        if (this.needsValues) {
            TxStateIndexChanges.AddedWithValuesAndRemoved changes = TxStateIndexChanges.indexUpdatesWithValuesForRangeSeekByPrefix((ReadableTransactionState)txState, descriptor, equalityPrefix, predicate.prefix(), this.indexOrder);
            this.addedWithValues = changes.added().iterator();
            this.removed = this.removed(txState, changes.removed());
        } else {
            TxStateIndexChanges.AddedAndRemoved changes = TxStateIndexChanges.indexUpdatesForRangeSeekByPrefix((ReadableTransactionState)txState, descriptor, equalityPrefix, predicate.prefix(), this.indexOrder);
            this.added = changes.added().longIterator();
            this.removed = this.removed(txState, changes.removed());
        }
    }

    private void rangeQuery(IndexDescriptor descriptor, Value[] equalityPrefix, PropertyIndexQuery.RangePredicate<?> predicate) {
        TransactionState txState = this.txStateHolder.txState();
        if (this.needsValues) {
            TxStateIndexChanges.AddedWithValuesAndRemoved changes = TxStateIndexChanges.indexUpdatesWithValuesForRangeSeek((ReadableTransactionState)txState, descriptor, equalityPrefix, predicate, this.indexOrder);
            this.addedWithValues = changes.added().iterator();
            this.removed = this.removed(txState, changes.removed());
        } else {
            TxStateIndexChanges.AddedAndRemoved changes = TxStateIndexChanges.indexUpdatesForRangeSeek((ReadableTransactionState)txState, descriptor, equalityPrefix, predicate, this.indexOrder);
            this.added = changes.added().longIterator();
            this.removed = this.removed(txState, changes.removed());
        }
    }

    private void boundingBoxQuery(IndexDescriptor descriptor, Value[] equalityPrefix, PropertyIndexQuery.BoundingBoxPredicate predicate) {
        TransactionState txState = this.txStateHolder.txState();
        if (this.needsValues) {
            TxStateIndexChanges.AddedWithValuesAndRemoved changes = TxStateIndexChanges.indexUpdatesWithValuesForBoundingBoxSeek((ReadableTransactionState)txState, descriptor, equalityPrefix, predicate);
            this.addedWithValues = changes.added().iterator();
            this.removed = this.removed(txState, changes.removed());
        } else {
            TxStateIndexChanges.AddedAndRemoved changes = TxStateIndexChanges.indexUpdatesForBoundingBoxSeek((ReadableTransactionState)txState, descriptor, equalityPrefix, predicate);
            this.added = changes.added().longIterator();
            this.removed = this.removed(txState, changes.removed());
        }
    }

    private void scanQuery(IndexDescriptor descriptor) {
        TransactionState txState = this.txStateHolder.txState();
        if (this.needsValues) {
            TxStateIndexChanges.AddedWithValuesAndRemoved changes = TxStateIndexChanges.indexUpdatesWithValuesForScan((ReadableTransactionState)txState, descriptor, this.indexOrder);
            this.addedWithValues = changes.added().iterator();
            this.removed = this.removed(txState, changes.removed());
        } else {
            TxStateIndexChanges.AddedAndRemoved changes = TxStateIndexChanges.indexUpdatesForScan((ReadableTransactionState)txState, descriptor, this.indexOrder);
            this.added = changes.added().longIterator();
            this.removed = this.removed(txState, changes.removed());
        }
    }

    private void suffixOrContainsQuery(IndexDescriptor descriptor, PropertyIndexQuery query) {
        TransactionState txState = this.txStateHolder.txState();
        if (this.needsValues) {
            TxStateIndexChanges.AddedWithValuesAndRemoved changes = TxStateIndexChanges.indexUpdatesWithValuesForSuffixOrContains((ReadableTransactionState)txState, descriptor, query, this.indexOrder);
            this.addedWithValues = changes.added().iterator();
            this.removed = this.removed(txState, changes.removed());
        } else {
            TxStateIndexChanges.AddedAndRemoved changes = TxStateIndexChanges.indexUpdatesForSuffixOrContains((ReadableTransactionState)txState, descriptor, query, this.indexOrder);
            this.added = changes.added().longIterator();
            this.removed = this.removed(txState, changes.removed());
        }
    }

    private void seekQuery(IndexDescriptor descriptor, Value[] values) {
        TransactionState txState = this.txStateHolder.txState();
        if (this.needsValues) {
            TxStateIndexChanges.AddedWithValuesAndRemoved changes = TxStateIndexChanges.indexUpdatesWithValuesForSeek((ReadableTransactionState)txState, descriptor, ValueTuple.of((Value[])values));
            this.addedWithValues = changes.added().iterator();
            this.removed = this.removed(txState, changes.removed());
        } else {
            TxStateIndexChanges.AddedAndRemoved changes = TxStateIndexChanges.indexUpdatesForSeek((ReadableTransactionState)txState, descriptor, ValueTuple.of((Value[])values));
            this.added = changes.added().longIterator();
            this.removed = this.removed(txState, changes.removed());
        }
    }

    final long entityReference() {
        return this.entity;
    }

    private static int[] indexQueryKeys(PropertyIndexQuery[] query) {
        int[] keys = new int[query.length];
        for (int i = 0; i < query.length; ++i) {
            keys[i] = query[i].propertyKeyId();
        }
        return keys;
    }

    final boolean allowed(long reference) {
        return this.shortcutSecurity || this.canAccessEntityAndProperties(reference);
    }

    abstract boolean canAccessAllDescribedEntities(IndexDescriptor var1);

    abstract LongSet removed(TransactionState var1, LongSet var2);

    protected abstract boolean canAccessEntityAndProperties(long var1);

    abstract void traceOnEntity(KernelReadTracer var1, long var2);

    abstract String implementationName();
}

