/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.neo4j.common.DependencyResolver;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.internal.schema.StorageEngineIndexingBehaviour;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.impl.api.index.IndexProviderMap;
import org.neo4j.kernel.impl.api.index.IndexProviderNotFoundException;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;

public class StaticIndexProviderMap
extends LifecycleAdapter
implements IndexProviderMap {
    private static final Comparator<IndexProvider> DESCENDING_MINIMUM_KERNEL_VERSION = Comparator.comparing(IndexProvider::getMinimumRequiredVersion).reversed();
    private final Map<IndexProviderDescriptor, IndexProvider> indexProvidersByDescriptor = new HashMap<IndexProviderDescriptor, IndexProvider>();
    private final Map<String, IndexProvider> indexProvidersByName = new HashMap<String, IndexProvider>();
    private final EnumMap<IndexType, List<IndexProvider>> indexProvidersByType = new EnumMap(IndexType.class);
    private final DependencyResolver dependencies;

    public StaticIndexProviderMap(DependencyResolver dependencies, IndexProvider ... indexProviders) {
        this.dependencies = dependencies;
        for (IndexProvider provider : indexProviders) {
            this.add(provider);
        }
    }

    public void init() throws Exception {
        this.dependencies.resolveTypeDependencies(IndexProvider.class).forEach(this::add);
    }

    public IndexProvider getTokenIndexProvider(KernelVersion kernelVersion) {
        return this.getIndexProvider(IndexType.LOOKUP, kernelVersion);
    }

    public IndexProvider getDefaultProvider(KernelVersion kernelVersion) {
        return this.getIndexProvider(IndexType.RANGE, kernelVersion);
    }

    public IndexProvider getPointIndexProvider(KernelVersion kernelVersion) {
        return this.getIndexProvider(IndexType.POINT, kernelVersion);
    }

    public IndexProvider getTextIndexProvider(KernelVersion kernelVersion) {
        return this.getIndexProvider(IndexType.TEXT, kernelVersion);
    }

    public IndexProvider getFulltextProvider(KernelVersion kernelVersion) {
        return this.getIndexProvider(IndexType.FULLTEXT, kernelVersion);
    }

    public IndexProvider getVectorIndexProvider(KernelVersion kernelVersion) {
        return this.getIndexProvider(IndexType.VECTOR, kernelVersion);
    }

    public IndexProvider lookup(IndexProviderDescriptor providerDescriptor) {
        IndexProvider provider = this.indexProvidersByDescriptor.get(providerDescriptor);
        this.assertProviderFound(provider, providerDescriptor.name());
        return provider;
    }

    public IndexProvider lookup(String providerDescriptorName) {
        IndexProvider provider = this.indexProvidersByName.get(providerDescriptorName);
        this.assertProviderFound(provider, providerDescriptorName);
        return provider;
    }

    public List<IndexProvider> lookup(IndexType indexType) {
        List<IndexProvider> indexProviders = this.indexProvidersByType.get(indexType);
        this.assertProviderFoundByType(indexProviders, indexType);
        return indexProviders;
    }

    public void accept(Consumer<IndexProvider> visitor) {
        this.indexProvidersByDescriptor.values().forEach(visitor);
    }

    private IndexProvider getIndexProvider(IndexType indexType, KernelVersion kernelVersion) {
        List<IndexProvider> providers = this.indexProvidersByType.get(indexType);
        for (IndexProvider provider : providers) {
            if (!kernelVersion.isAtLeast(provider.getMinimumRequiredVersion())) continue;
            return provider;
        }
        throw new IndexProviderNotFoundException("No provider for type " + String.valueOf(indexType) + " and version " + String.valueOf(kernelVersion) + " found.");
    }

    private void assertProviderFound(IndexProvider provider, String providerDescriptorName) {
        if (provider == null) {
            throw new IndexProviderNotFoundException("Tried to get index provider with name %s whereas available providers in this session being %s.".formatted(providerDescriptorName, this.indexProvidersByName.keySet()));
        }
    }

    private void assertProviderFoundByType(List<IndexProvider> indexProviders, IndexType indexType) {
        if (indexProviders == null) {
            List<String> providerNamesByType = this.indexProvidersByType.entrySet().stream().map(entry -> {
                IndexType type = (IndexType)entry.getKey();
                List providers = (List)entry.getValue();
                return String.valueOf(type) + "=" + String.valueOf(providers.stream().map(provider -> provider.getProviderDescriptor().name()).toList());
            }).toList();
            throw new IndexProviderNotFoundException("Tried to get index providers for index type " + String.valueOf(indexType) + " but could not find any. Available index providers per type are " + String.valueOf(providerNamesByType));
        }
    }

    public IndexDescriptor completeConfiguration(IndexDescriptor index, StorageEngineIndexingBehaviour indexingBehaviour) {
        IndexProviderDescriptor providerDescriptor = index.getIndexProvider();
        IndexProvider provider = this.lookup(providerDescriptor);
        return provider.completeConfiguration(index, indexingBehaviour);
    }

    private void add(IndexProvider provider) {
        if (provider == null) {
            return;
        }
        IndexProviderDescriptor providerDescriptor = Objects.requireNonNull(provider.getProviderDescriptor());
        IndexProvider existing = this.indexProvidersByDescriptor.putIfAbsent(providerDescriptor, provider);
        if (existing != null) {
            throw new IllegalArgumentException("Tried to load multiple schema index providers with the same provider descriptor " + String.valueOf(providerDescriptor) + ". First loaded " + String.valueOf(existing) + " then " + String.valueOf(provider));
        }
        this.indexProvidersByName.putIfAbsent(providerDescriptor.name(), provider);
        List providersForType = this.indexProvidersByType.computeIfAbsent(provider.getIndexType(), it -> new ArrayList());
        providersForType.add(provider);
        providersForType.sort(DESCENDING_MINIMUM_KERNEL_VERSION);
    }
}

