/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Optional;
import org.neo4j.configuration.Config;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.ReadPastEndException;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.kernel.BinarySupportedKernelVersions;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.KernelVersionProvider;
import org.neo4j.kernel.impl.transaction.log.LogFormatVersionProvider;
import org.neo4j.kernel.impl.transaction.log.LogVersionBridge;
import org.neo4j.kernel.impl.transaction.log.LogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableLogChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableLogPositionAwareChannel;
import org.neo4j.kernel.impl.transaction.log.entry.AbstractDetachedCheckpointLogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.AbstractVersionAwareLogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommit;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryStart;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeader;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeaderReader;
import org.neo4j.kernel.impl.transaction.log.entry.VersionAwareLogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.v42.LogEntryStartV4_2;
import org.neo4j.kernel.impl.transaction.log.entry.v57.LogEntryChunkStart;
import org.neo4j.kernel.impl.transaction.log.entry.v57.LogEntryRollback;
import org.neo4j.kernel.impl.transaction.log.enveloped.EnvelopeReadChannel;
import org.neo4j.kernel.impl.transaction.log.enveloped.InvalidEndOfFileReadException;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.LogFilesBuilder;
import org.neo4j.kernel.impl.transaction.log.files.LogRangeInfo;
import org.neo4j.kernel.impl.transaction.log.files.VersionedFile;
import org.neo4j.kernel.impl.util.InconsistentTransactionLogException;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.CommandReaderFactory;
import org.neo4j.storageengine.api.StorageEngineFactory;

public class TransactionLogChecker {
    private TransactionLogChecker() {
    }

    public static void verifyCorrectTransactionLogUpgrades(FileSystemAbstraction fs, DatabaseLayout layout, Config config) throws IOException, InconsistentTransactionLogException {
        LogFiles logFiles = LogFilesBuilder.readOnlyBuilder(layout, fs, KernelVersionProvider.THROWING_PROVIDER, LogFormatVersionProvider.THROWING_PROVIDER).build();
        Optional storageEngineFactory = StorageEngineFactory.selectStorageEngine((FileSystemAbstraction)fs, (DatabaseLayout)layout);
        CommandReaderFactory commandReaderFactory = ((StorageEngineFactory)storageEngineFactory.orElseThrow(() -> new IllegalStateException("Couldn't figure out storage engine from store files"))).commandReaderFactory();
        MultipleVersionInOneLogFileAcceptanceChecker txLogFileAcceptanceChecker = upgradeTxId -> logFiles.getCheckpointFile().reachableCheckpoints().stream().map(c -> c.transactionId().id()).anyMatch(id -> id == upgradeTxId);
        MultipleVersionInOneLogFileAcceptanceChecker checkpointFileAcceptanceChecker = ignored -> false;
        TransactionLogChecker.verifyLogFiles(fs, config, logFiles.getLogFile(), commandReaderFactory, FileType.TX_LOG, txLogFileAcceptanceChecker);
        TransactionLogChecker.verifyLogFiles(fs, config, logFiles.getCheckpointFile(), commandReaderFactory, FileType.CHECKPOINT_LOG, checkpointFileAcceptanceChecker);
    }

    private static void verifyLogFiles(FileSystemAbstraction fs, Config config, VersionedFile logFile, CommandReaderFactory commandReaderFactory, FileType fileType, MultipleVersionInOneLogFileAcceptanceChecker acceptanceChecker) throws IOException {
        LastFileInfo lastFileInfo = new LastFileInfo(KernelVersion.EARLIEST, 1L);
        LogRangeInfo logRangeInfo = logFile.getLogRangeInfo();
        for (long i = logRangeInfo.lowestVersion(); i <= logRangeInfo.highestVersion(); ++i) {
            LogHeader logHeader = LogHeaderReader.readLogHeader((FileSystemAbstraction)fs, (Path)logFile.getLogFileForVersion(i), (MemoryTracker)EmptyMemoryTracker.INSTANCE);
            if (logHeader == null) {
                throw new InconsistentTransactionLogException("Could not read log header of %s file version %d".formatted(fileType.lowerCase, i));
            }
            KernelVersion logHeaderKernelVersion = logHeader.getKernelVersion();
            if (TransactionLogChecker.versionLessThan(logHeaderKernelVersion, lastFileInfo.lastSeenKernelVersion)) {
                throw new InconsistentTransactionLogException("%s file version %d contains entry with lower kernel version (%s) than version seen in file with version %d (%s)".formatted(fileType.capitalized, i, logHeaderKernelVersion.name(), i - 1L, lastFileInfo.lastSeenKernelVersion.name()));
            }
            if (TransactionLogChecker.lastSeenIndexDoesntMatchExpected(lastFileInfo, logHeader, fileType)) {
                throw new InconsistentTransactionLogException("%s file version %d header says last append index should be '%s' but the last append index seen in file with version %d was '%s'".formatted(fileType.capitalized, i, logHeader.getLastAppendIndex(), i - 1L, lastFileInfo.lastSeenAppendIndex));
            }
            lastFileInfo = TransactionLogChecker.verifyVersionInOneFile(logHeader, logFile, logHeaderKernelVersion, lastFileInfo.lastSeenKernelVersion, logHeader.getLastAppendIndex(), commandReaderFactory, config, fileType, acceptanceChecker);
        }
    }

    private static boolean lastSeenIndexDoesntMatchExpected(LastFileInfo lastFileInfo, LogHeader logHeader, FileType fileType) {
        return switch (fileType.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                if (lastFileInfo.lastSeenAppendIndex != 1L) {
                    if (lastFileInfo.lastSeenAppendIndex != logHeader.getLastAppendIndex()) {
                        yield true;
                    }
                    yield false;
                }
                if (logHeader.getLastAppendIndex() < 1L) {
                    yield true;
                }
                yield false;
            }
            case 1 -> logHeader.getLastAppendIndex() != 0L;
        };
    }

    private static LastFileInfo verifyVersionInOneFile(LogHeader logHeader, VersionedFile logFile, KernelVersion logHeaderKernelVersion, KernelVersion previouslySeenVersion, long previouslySeenAppendIndex, CommandReaderFactory commandReaderFactory, Config config, FileType fileType, MultipleVersionInOneLogFileAcceptanceChecker acceptanceChecker) throws IOException {
        LastFileInfo versionSeenInFile;
        LastFileInfo lastFileInfo = versionSeenInFile = logHeader.getLogFormatVersion().usesSegments() ? TransactionLogChecker.verifyVersionInSegmentedFile(logFile, logHeader, logHeaderKernelVersion, previouslySeenAppendIndex, fileType) : TransactionLogChecker.verifyVersionInOldFile(logFile, logHeader, logHeaderKernelVersion, previouslySeenAppendIndex, commandReaderFactory, config, fileType, acceptanceChecker);
        if (logHeaderKernelVersion == null && TransactionLogChecker.versionLessThan(versionSeenInFile.lastSeenKernelVersion, previouslySeenVersion)) {
            throw new InconsistentTransactionLogException("%s file version %d contains entry with lower kernel version (%s) than version seen in previous file (%s)".formatted(fileType.capitalized, logHeader.getLogVersion(), versionSeenInFile.lastSeenKernelVersion.name(), previouslySeenVersion.name()));
        }
        if (versionSeenInFile.lastSeenKernelVersion == null) {
            versionSeenInFile = new LastFileInfo(logHeaderKernelVersion != null ? logHeaderKernelVersion : previouslySeenVersion, versionSeenInFile.lastSeenAppendIndex);
        }
        return versionSeenInFile;
    }

    private static boolean versionLessThan(KernelVersion version, KernelVersion comparable) {
        return version != null && comparable != null && version.isLessThan(comparable);
    }

    private static LastFileInfo verifyVersionInSegmentedFile(VersionedFile logFile, LogHeader logHeader, KernelVersion expectedVersion, long previouslySeenAppendIndex, FileType fileType) throws IOException {
        PhysicalLogVersionedStoreChannel logChannel = logFile.openForVersion(logHeader.getLogVersion());
        logChannel.position(logHeader.getStartPosition().getByteOffset());
        try (VersionCheckingEnvelopeReadChannel versionCheckingEnvelopeReadChannel = new VersionCheckingEnvelopeReadChannel((LogVersionedStoreChannel)logChannel, logHeader.getSegmentBlockSize(), LogVersionBridge.NO_MORE_CHANNELS, (MemoryTracker)EmptyMemoryTracker.INSTANCE, false, expectedVersion, previouslySeenAppendIndex, fileType);){
            if (TransactionLogChecker.findEnvelopeVersionErrors(versionCheckingEnvelopeReadChannel)) {
                throw new InconsistentTransactionLogException("%s file version %d malformed, could not read until end".formatted(fileType.capitalized, logHeader.getLogVersion()));
            }
            LastFileInfo lastFileInfo = new LastFileInfo(versionCheckingEnvelopeReadChannel.expectedVersion, versionCheckingEnvelopeReadChannel.previouslySeenAppendIndex);
            return lastFileInfo;
        }
    }

    private static boolean findEnvelopeVersionErrors(VersionCheckingEnvelopeReadChannel versionCheckingEnvelopeReadChannel) throws IOException {
        long prevPos = -1L;
        try {
            long pos;
            while (prevPos < (pos = versionCheckingEnvelopeReadChannel.goToNextEntry())) {
                prevPos = pos;
            }
        }
        catch (ReadPastEndException | InvalidEndOfFileReadException e) {
            return false;
        }
        return true;
    }

    private static LastFileInfo verifyVersionInOldFile(VersionedFile logFile, LogHeader logHeader, KernelVersion expectedVersion, long previouslySeenAppendIndex, CommandReaderFactory commandReaderFactory, Config config, FileType fileType, MultipleVersionInOneLogFileAcceptanceChecker acceptanceChecker) throws IOException {
        KernelVersion seenVersion = expectedVersion;
        try (ReadableLogChannel reader = logFile.getReader(logHeader.getStartPosition(), LogVersionBridge.NO_MORE_CHANNELS);){
            LogEntry entry;
            VersionAwareLogEntryReader entryReader = new VersionAwareLogEntryReader(commandReaderFactory, new BinarySupportedKernelVersions(config), (MemoryTracker)EmptyMemoryTracker.INSTANCE);
            long lastSeenTxId = -1L;
            boolean getIndexFromCommitEntry = false;
            while ((entry = entryReader.readLogEntry((ReadableLogPositionAwareChannel)reader)) != null) {
                if (entry instanceof AbstractVersionAwareLogEntry) {
                    AbstractVersionAwareLogEntry versionedEntry = (AbstractVersionAwareLogEntry)entry;
                    KernelVersion startVersion = versionedEntry.kernelVersion();
                    if (seenVersion == null) {
                        seenVersion = startVersion;
                    } else if (seenVersion != startVersion) {
                        if (startVersion.isLessThan(seenVersion)) {
                            throw new InconsistentTransactionLogException("%s file version %d contains entry with lower kernel version (%s) than version seen earlier in the file (%s)".formatted(fileType.capitalized, logHeader.getLogVersion(), startVersion.name(), seenVersion.name()));
                        }
                        long upgradeTxId = lastSeenTxId;
                        if (!acceptanceChecker.areMultipleVersionsAccepted(upgradeTxId)) {
                            throw new InconsistentTransactionLogException("%s file version %d contains entry with other kernel version (%s) than version seen earlier in the file (%s)".formatted(fileType.capitalized, logHeader.getLogVersion(), startVersion.name(), seenVersion.name()));
                        }
                        seenVersion = startVersion;
                    }
                }
                if (entry instanceof LogEntryCommit) {
                    LogEntryCommit commit = (LogEntryCommit)entry;
                    lastSeenTxId = commit.getTxId();
                }
                if (entry instanceof LogEntryStart) {
                    LogEntryStart startEntry = (LogEntryStart)entry;
                    if (startEntry instanceof LogEntryStartV4_2) {
                        getIndexFromCommitEntry = true;
                        continue;
                    }
                    previouslySeenAppendIndex = TransactionLogChecker.validateExpectedAppendIndex(startEntry.getAppendIndex(), logHeader, previouslySeenAppendIndex, fileType);
                    continue;
                }
                if (getIndexFromCommitEntry && entry instanceof LogEntryCommit) {
                    LogEntryCommit commitEntry = (LogEntryCommit)entry;
                    previouslySeenAppendIndex = TransactionLogChecker.validateExpectedAppendIndex(commitEntry.getTxId(), logHeader, previouslySeenAppendIndex, fileType);
                    getIndexFromCommitEntry = false;
                    continue;
                }
                if (entry instanceof LogEntryChunkStart) {
                    LogEntryChunkStart chunkStart = (LogEntryChunkStart)entry;
                    previouslySeenAppendIndex = TransactionLogChecker.validateExpectedAppendIndex(chunkStart.getAppendIndex(), logHeader, previouslySeenAppendIndex, fileType);
                    continue;
                }
                if (entry instanceof LogEntryRollback) {
                    LogEntryRollback rollback = (LogEntryRollback)entry;
                    previouslySeenAppendIndex = TransactionLogChecker.validateExpectedAppendIndex(rollback.getAppendIndex(), logHeader, previouslySeenAppendIndex, fileType);
                    continue;
                }
                if (!(entry instanceof AbstractDetachedCheckpointLogEntry)) continue;
                ++previouslySeenAppendIndex;
            }
        }
        return new LastFileInfo(seenVersion, previouslySeenAppendIndex);
    }

    private static long validateExpectedAppendIndex(long currentAppendIndex, LogHeader logHeader, long previouslySeenAppendIndex, FileType fileType) {
        if (currentAppendIndex != previouslySeenAppendIndex + 1L) {
            throw new InconsistentTransactionLogException("%s file version %d contains entry with out of order append index '%d' seen after '%d'".formatted(fileType.capitalized, logHeader.getLogVersion(), currentAppendIndex, previouslySeenAppendIndex));
        }
        return previouslySeenAppendIndex + 1L;
    }

    @FunctionalInterface
    static interface MultipleVersionInOneLogFileAcceptanceChecker {
        public boolean areMultipleVersionsAccepted(long var1) throws IOException;
    }

    static enum FileType {
        TX_LOG("Log", "log"),
        CHECKPOINT_LOG("Checkpoint", "checkpoint");

        final String capitalized;
        final String lowerCase;

        private FileType(String capitalized, String lowerCase) {
            this.capitalized = capitalized;
            this.lowerCase = lowerCase;
        }
    }

    private record LastFileInfo(KernelVersion lastSeenKernelVersion, long lastSeenAppendIndex) {
    }

    static class VersionCheckingEnvelopeReadChannel
    extends EnvelopeReadChannel {
        private final long logVersion;
        private KernelVersion expectedVersion;
        private byte expectedVersionByte;
        private long previouslySeenAppendIndex;
        private final FileType fileType;

        protected VersionCheckingEnvelopeReadChannel(LogVersionedStoreChannel startingChannel, int segmentBlockSize, LogVersionBridge bridge, MemoryTracker memoryTracker, boolean raw, KernelVersion expectedVersion, long previouslySeenAppendIndex, FileType fileType) throws IOException {
            super(startingChannel, segmentBlockSize, bridge, memoryTracker, raw);
            this.logVersion = startingChannel.getLogVersion();
            this.expectedVersion = expectedVersion;
            this.expectedVersionByte = (byte)(expectedVersion != null ? (int)expectedVersion.version() : -1);
            this.previouslySeenAppendIndex = previouslySeenAppendIndex;
            this.fileType = fileType;
        }

        protected void readEnvelopeHeader() throws IOException {
            super.readEnvelopeHeader();
            if (this.expectedVersion == null) {
                this.expectedVersion = KernelVersion.getForVersion((byte)this.payloadVersion);
                this.expectedVersionByte = this.payloadVersion;
            } else if (this.expectedVersionByte != this.payloadVersion) {
                throw new InconsistentTransactionLogException("%s file version %d contains entry with other kernel version (%s) than version seen earlier in the file (%s)".formatted(this.fileType.capitalized, this.logVersion, KernelVersion.getForVersion((byte)this.payloadVersion).name(), this.expectedVersion.name()));
            }
            this.checkExpectedAppendIndex();
        }

        void checkExpectedAppendIndex() throws IOException {
            if (this.previouslySeenAppendIndex == 0L) {
                this.previouslySeenAppendIndex = this.getAppendIndex();
                return;
            }
            switch (this.payloadType) {
                case FULL: 
                case BEGIN: {
                    long currentAppendIndex = this.getAppendIndex();
                    if (currentAppendIndex != this.previouslySeenAppendIndex + 1L) {
                        throw new InconsistentTransactionLogException("%s file version %d contains entry with out of order append index '%d' seen after '%d'".formatted(this.fileType.capitalized, this.logVersion, currentAppendIndex, this.previouslySeenAppendIndex));
                    }
                    ++this.previouslySeenAppendIndex;
                    break;
                }
                case MIDDLE: 
                case END: {
                    long currentAppendIndex = this.getAppendIndex();
                    if (currentAppendIndex == this.previouslySeenAppendIndex) break;
                    throw new InconsistentTransactionLogException("%s file version %d contains continuation entry (MIDDLE/END) with different append index '%d' than start '%d'".formatted(this.fileType.capitalized, this.logVersion, currentAppendIndex, this.previouslySeenAppendIndex));
                }
            }
        }
    }
}

