/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index.sampling;

import org.neo4j.helpers.collection.MultiSet;
import org.neo4j.storageengine.api.schema.IndexSample;

public class NonUniqueIndexSampler {
    private static final int INITIAL_SIZE = 65536;
    private final int bufferSizeLimit;
    private final MultiSet<String> values;
    private int sampledSteps = 0;
    private long accumulatedUniqueValues = 0L;
    private long accumulatedSampledSize = 0L;
    private long bufferSize = 0L;

    public NonUniqueIndexSampler(int bufferSizeLimit) {
        this.bufferSizeLimit = bufferSizeLimit;
        this.values = new MultiSet(65536);
    }

    public void include(String value) {
        this.include(value, 1L);
    }

    public void include(String value, long increment) {
        assert (increment > 0L);
        if (this.bufferSize >= (long)this.bufferSizeLimit) {
            this.nextStep();
        }
        if (this.values.increment((Object)value, increment) == increment) {
            this.bufferSize += (long)value.length();
        }
    }

    public void exclude(String value) {
        this.exclude(value, 1L);
    }

    public void exclude(String value, long decrement) {
        assert (decrement > 0L);
        if (this.values.increment((Object)value, -decrement) == 0L) {
            this.bufferSize -= (long)value.length();
        }
    }

    public IndexSample result() {
        if (!this.values.isEmpty()) {
            this.nextStep();
        }
        long uniqueValues = this.sampledSteps != 0 ? this.accumulatedUniqueValues / (long)this.sampledSteps : 0L;
        long sampledSize = this.sampledSteps != 0 ? this.accumulatedSampledSize / (long)this.sampledSteps : 0L;
        return new IndexSample(this.accumulatedSampledSize, uniqueValues, sampledSize);
    }

    private void nextStep() {
        this.accumulatedUniqueValues += (long)this.values.uniqueSize();
        this.accumulatedSampledSize += (long)this.values.size();
        this.bufferSize = 0L;
        ++this.sampledSteps;
        this.values.clear();
    }
}

