/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.scan;

import java.util.Arrays;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.cursor.Cursor;
import org.neo4j.helpers.collection.PrefetchingResourceIterator;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.ReadOperations;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.kernel.api.labelscan.NodeLabelUpdate;
import org.neo4j.storageengine.api.LabelItem;
import org.neo4j.storageengine.api.NodeItem;

public class LabelStoreScanIterator
extends PrefetchingResourceIterator<NodeLabelUpdate> {
    private long current;
    private final KernelTransaction tx;
    private final Statement statement;
    private final PrimitiveLongIterator nodeIds;
    private final ReadOperations readOperations;
    private final long[] tempArray = new long[10];

    public LabelStoreScanIterator(KernelTransaction tx) {
        this.tx = tx;
        this.statement = tx.acquireStatement();
        this.readOperations = this.statement.readOperations();
        this.nodeIds = this.readOperations.nodesGetAll();
    }

    protected NodeLabelUpdate fetchNextOrNull() {
        while (this.nodeIds.hasNext()) {
            long nodeId = this.nodeIds.next();
            Cursor<NodeItem> nodeCursor = this.readOperations.nodeCursor(nodeId);
            Throwable throwable = null;
            try {
                Cursor<LabelItem> labelCursor;
                long[] labels;
                if (!nodeCursor.next() || (labels = this.allLabels(labelCursor = ((NodeItem)nodeCursor.get()).labels())).length <= 0) continue;
                NodeLabelUpdate nodeLabelUpdate = NodeLabelUpdate.labelChanges(nodeId, PrimitiveLongCollections.EMPTY_LONG_ARRAY, labels);
                return nodeLabelUpdate;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (nodeCursor == null) continue;
                if (throwable != null) {
                    try {
                        nodeCursor.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                nodeCursor.close();
            }
        }
        return null;
    }

    private long[] allLabels(Cursor<LabelItem> labelCursor) {
        int index = 0;
        while (labelCursor.next()) {
            this.tempArray[index++] = ((LabelItem)labelCursor.get()).getAsInt();
        }
        return index == 0 ? PrimitiveLongCollections.EMPTY_LONG_ARRAY : Arrays.copyOf(this.tempArray, index);
    }

    public void close() {
        this.statement.close();
        try {
            this.tx.close();
        }
        catch (TransactionFailureException e) {
            throw new RuntimeException(e);
        }
    }
}

