/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.store;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.kernel.api.constraints.NodePropertyConstraint;
import org.neo4j.kernel.api.constraints.PropertyConstraint;
import org.neo4j.kernel.api.constraints.RelationshipPropertyConstraint;
import org.neo4j.kernel.api.index.IndexDescriptor;
import org.neo4j.kernel.impl.constraints.ConstraintSemantics;
import org.neo4j.kernel.impl.store.record.IndexRule;
import org.neo4j.kernel.impl.store.record.NodePropertyConstraintRule;
import org.neo4j.kernel.impl.store.record.PropertyConstraintRule;
import org.neo4j.kernel.impl.store.record.RelationshipPropertyConstraintRule;
import org.neo4j.storageengine.api.schema.SchemaRule;

public class SchemaCache {
    private final Map<Long, SchemaRule> rulesByIdMap = new HashMap<Long, SchemaRule>();
    private final Collection<NodePropertyConstraint> nodeConstraints = new HashSet<NodePropertyConstraint>();
    private final Collection<RelationshipPropertyConstraint> relationshipConstraints = new HashSet<RelationshipPropertyConstraint>();
    private final Map<Integer, Map<Integer, CommittedIndexDescriptor>> indexDescriptors = new HashMap<Integer, Map<Integer, CommittedIndexDescriptor>>();
    private final ConstraintSemantics constraintSemantics;

    public SchemaCache(ConstraintSemantics constraintSemantics, Iterable<SchemaRule> initialRules) {
        this.constraintSemantics = constraintSemantics;
        this.splitUpInitialRules(initialRules);
    }

    private void splitUpInitialRules(Iterable<SchemaRule> initialRules) {
        for (SchemaRule rule : initialRules) {
            this.addSchemaRule(rule);
        }
    }

    public Iterable<SchemaRule> schemaRules() {
        return this.rulesByIdMap.values();
    }

    public Iterable<SchemaRule> schemaRulesForLabel(int label) {
        return Iterables.filter(schemaRule -> schemaRule.getKind() != SchemaRule.Kind.RELATIONSHIP_PROPERTY_EXISTENCE_CONSTRAINT && schemaRule.getLabel() == label, this.schemaRules());
    }

    public Iterable<SchemaRule> schemaRulesForRelationshipType(int typeId) {
        return Iterables.filter(schemaRule -> schemaRule.getKind() == SchemaRule.Kind.RELATIONSHIP_PROPERTY_EXISTENCE_CONSTRAINT && schemaRule.getRelationshipType() == typeId, this.schemaRules());
    }

    public Iterator<PropertyConstraint> constraints() {
        return Iterators.concat((Iterator[])new Iterator[]{this.nodeConstraints.iterator(), this.relationshipConstraints.iterator()});
    }

    public Iterator<NodePropertyConstraint> constraintsForLabel(int label) {
        return Iterators.filter(constraint -> constraint.label() == label, this.nodeConstraints.iterator());
    }

    public Iterator<NodePropertyConstraint> constraintsForLabelAndProperty(int label, int property) {
        return Iterators.filter(constraint -> constraint.label() == label && constraint.propertyKey() == property, this.nodeConstraints.iterator());
    }

    public Iterator<RelationshipPropertyConstraint> constraintsForRelationshipType(int typeId) {
        return Iterators.filter(constraint -> constraint.relationshipType() == typeId, this.relationshipConstraints.iterator());
    }

    public Iterator<RelationshipPropertyConstraint> constraintsForRelationshipTypeAndProperty(int typeId, int propertyKeyId) {
        return Iterators.filter(constraint -> constraint.relationshipType() == typeId && constraint.propertyKey() == propertyKeyId, this.relationshipConstraints.iterator());
    }

    public void addSchemaRule(SchemaRule rule) {
        this.rulesByIdMap.put(rule.getId(), rule);
        if (rule instanceof PropertyConstraintRule) {
            PropertyConstraint constraint = this.constraintSemantics.readConstraint((PropertyConstraintRule)rule);
            if (constraint instanceof NodePropertyConstraint) {
                this.nodeConstraints.add((NodePropertyConstraint)constraint);
            } else if (constraint instanceof RelationshipPropertyConstraint) {
                this.relationshipConstraints.add((RelationshipPropertyConstraint)constraint);
            }
        } else if (rule instanceof IndexRule) {
            IndexRule indexRule = (IndexRule)rule;
            Map<Integer, CommittedIndexDescriptor> byLabel = this.indexDescriptors.get(indexRule.getLabel());
            if (byLabel == null) {
                byLabel = new HashMap<Integer, CommittedIndexDescriptor>();
                this.indexDescriptors.put(indexRule.getLabel(), byLabel);
            }
            byLabel.put(indexRule.getPropertyKey(), new CommittedIndexDescriptor(indexRule.getLabel(), indexRule.getPropertyKey(), indexRule.getId()));
        }
    }

    public void clear() {
        this.rulesByIdMap.clear();
        this.nodeConstraints.clear();
        this.relationshipConstraints.clear();
        this.indexDescriptors.clear();
    }

    public void load(List<SchemaRule> schemaRuleIterator) {
        this.clear();
        for (SchemaRule schemaRule : schemaRuleIterator) {
            this.addSchemaRule(schemaRule);
        }
    }

    public void removeSchemaRule(long id) {
        SchemaRule rule = this.rulesByIdMap.remove(id);
        if (rule == null) {
            return;
        }
        if (rule instanceof NodePropertyConstraintRule) {
            this.nodeConstraints.remove(((NodePropertyConstraintRule)rule).toConstraint());
        } else if (rule instanceof RelationshipPropertyConstraintRule) {
            this.relationshipConstraints.remove(((RelationshipPropertyConstraintRule)rule).toConstraint());
        } else if (rule instanceof IndexRule) {
            IndexRule indexRule = (IndexRule)rule;
            Map<Integer, CommittedIndexDescriptor> byLabel = this.indexDescriptors.get(indexRule.getLabel());
            byLabel.remove(indexRule.getPropertyKey());
            if (byLabel.isEmpty()) {
                this.indexDescriptors.remove(indexRule.getLabel());
            }
        }
    }

    public IndexDescriptor indexDescriptor(int labelId, int propertyKey) {
        CommittedIndexDescriptor committed;
        Map<Integer, CommittedIndexDescriptor> byLabel = this.indexDescriptors.get(labelId);
        if (byLabel != null && (committed = byLabel.get(propertyKey)) != null) {
            return committed.getDescriptor();
        }
        return null;
    }

    private static class CommittedIndexDescriptor {
        private final IndexDescriptor descriptor;
        private final long id;

        public CommittedIndexDescriptor(int labelId, int propertyKey, long id) {
            this.descriptor = new IndexDescriptor(labelId, propertyKey);
            this.id = id;
        }

        public IndexDescriptor getDescriptor() {
            return this.descriptor;
        }

        public long getId() {
            return this.id;
        }
    }
}

