/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.format.lowlimit;

import java.io.IOException;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.kernel.impl.store.format.BaseOneByteHeaderRecordFormat;
import org.neo4j.kernel.impl.store.format.BaseRecordFormat;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;

public class RelationshipRecordFormat
extends BaseOneByteHeaderRecordFormat<RelationshipRecord> {
    public static final int RECORD_SIZE = 34;

    public RelationshipRecordFormat() {
        super(RelationshipRecordFormat.fixedRecordSize(34), 0, 1, 35);
    }

    @Override
    public RelationshipRecord newRecord() {
        return new RelationshipRecord(-1L);
    }

    @Override
    public void read(RelationshipRecord record, PageCursor cursor, RecordLoad mode, int recordSize, PagedFile storeFile) throws IOException {
        byte headerByte = cursor.getByte();
        boolean inUse = this.isInUse(headerByte);
        if (mode.shouldLoad(inUse)) {
            long firstNode = (long)cursor.getInt() & 0xFFFFFFFFL;
            long firstNodeMod = ((long)headerByte & 0xEL) << 31;
            long secondNode = (long)cursor.getInt() & 0xFFFFFFFFL;
            long typeInt = cursor.getInt();
            long secondNodeMod = (typeInt & 0x70000000L) << 4;
            int type = (int)(typeInt & 0xFFFFL);
            long firstPrevRel = (long)cursor.getInt() & 0xFFFFFFFFL;
            long firstPrevRelMod = (typeInt & 0xE000000L) << 7;
            long firstNextRel = (long)cursor.getInt() & 0xFFFFFFFFL;
            long firstNextRelMod = (typeInt & 0x1C00000L) << 10;
            long secondPrevRel = (long)cursor.getInt() & 0xFFFFFFFFL;
            long secondPrevRelMod = (typeInt & 0x380000L) << 13;
            long secondNextRel = (long)cursor.getInt() & 0xFFFFFFFFL;
            long secondNextRelMod = (typeInt & 0x70000L) << 16;
            long nextProp = (long)cursor.getInt() & 0xFFFFFFFFL;
            long nextPropMod = ((long)headerByte & 0xF0L) << 28;
            byte extraByte = cursor.getByte();
            record.initialize(inUse, BaseRecordFormat.longFromIntAndMod(nextProp, nextPropMod), BaseRecordFormat.longFromIntAndMod(firstNode, firstNodeMod), BaseRecordFormat.longFromIntAndMod(secondNode, secondNodeMod), type, BaseRecordFormat.longFromIntAndMod(firstPrevRel, firstPrevRelMod), BaseRecordFormat.longFromIntAndMod(firstNextRel, firstNextRelMod), BaseRecordFormat.longFromIntAndMod(secondPrevRel, secondPrevRelMod), BaseRecordFormat.longFromIntAndMod(secondNextRel, secondNextRelMod), (extraByte & 1) != 0, (extraByte & 2) != 0);
        }
    }

    @Override
    public void write(RelationshipRecord record, PageCursor cursor, int recordSize, PagedFile storeFile) throws IOException {
        if (record.inUse()) {
            long firstNode = record.getFirstNode();
            short firstNodeMod = (short)((firstNode & 0x700000000L) >> 31);
            long secondNode = record.getSecondNode();
            long secondNodeMod = (secondNode & 0x700000000L) >> 4;
            long firstPrevRel = record.getFirstPrevRel();
            long firstPrevRelMod = firstPrevRel == (long)Record.NO_NEXT_RELATIONSHIP.intValue() ? 0L : (firstPrevRel & 0x700000000L) >> 7;
            long firstNextRel = record.getFirstNextRel();
            long firstNextRelMod = firstNextRel == (long)Record.NO_NEXT_RELATIONSHIP.intValue() ? 0L : (firstNextRel & 0x700000000L) >> 10;
            long secondPrevRel = record.getSecondPrevRel();
            long secondPrevRelMod = secondPrevRel == (long)Record.NO_NEXT_RELATIONSHIP.intValue() ? 0L : (secondPrevRel & 0x700000000L) >> 13;
            long secondNextRel = record.getSecondNextRel();
            long secondNextRelMod = secondNextRel == (long)Record.NO_NEXT_RELATIONSHIP.intValue() ? 0L : (secondNextRel & 0x700000000L) >> 16;
            long nextProp = record.getNextProp();
            long nextPropMod = nextProp == (long)Record.NO_NEXT_PROPERTY.intValue() ? 0L : (nextProp & 0xF00000000L) >> 28;
            short inUseUnsignedByte = (short)((long)((record.inUse() ? Record.IN_USE : Record.NOT_IN_USE).byteValue() | firstNodeMod) | nextPropMod);
            int typeInt = (int)((long)record.getType() | secondNodeMod | firstPrevRelMod | firstNextRelMod | secondPrevRelMod | secondNextRelMod);
            long firstInStartNodeChain = record.isFirstInFirstChain() ? 1L : 0L;
            long firstInEndNodeChain = record.isFirstInSecondChain() ? 2L : 0L;
            byte extraByte = (byte)(firstInEndNodeChain | firstInStartNodeChain);
            cursor.putByte((byte)inUseUnsignedByte);
            cursor.putInt((int)firstNode);
            cursor.putInt((int)secondNode);
            cursor.putInt(typeInt);
            cursor.putInt((int)firstPrevRel);
            cursor.putInt((int)firstNextRel);
            cursor.putInt((int)secondPrevRel);
            cursor.putInt((int)secondNextRel);
            cursor.putInt((int)nextProp);
            cursor.putByte(extraByte);
        } else {
            this.markAsUnused(cursor);
        }
    }
}

