/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration.legacylogs;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.function.Function;
import org.neo4j.cursor.IOCursor;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.kernel.impl.storemigration.legacylogs.LogEntrySortingCursor;
import org.neo4j.kernel.impl.transaction.log.LogVersionBridge;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.ReadAheadLogChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableLogChannel;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeader;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeaderReader;
import org.neo4j.kernel.impl.transaction.log.entry.VersionAwareLogEntryReader;

class LegacyLogEntryReader {
    private final FileSystemAbstraction fs;
    private final Function<LogHeader, LogEntryReader<ReadableLogChannel>> readerFactory;

    LegacyLogEntryReader(FileSystemAbstraction fs, Function<LogHeader, LogEntryReader<ReadableLogChannel>> readerFactory) {
        this.fs = fs;
        this.readerFactory = readerFactory;
    }

    LegacyLogEntryReader(FileSystemAbstraction fs) {
        this(fs, from -> new VersionAwareLogEntryReader());
    }

    public Pair<LogHeader, IOCursor<LogEntry>> openReadableChannel(File logFile) throws IOException {
        StoreChannel rawChannel = this.fs.open(logFile, "r");
        LogHeader header = LogHeaderReader.readLogHeader(ByteBuffer.allocate(16), (ReadableByteChannel)rawChannel, false);
        LogEntryReader<ReadableLogChannel> reader = this.readerFactory.apply(header);
        long lastCommittedTxId = Math.max(1L, header.lastCommittedTxId);
        PhysicalLogVersionedStoreChannel channel = new PhysicalLogVersionedStoreChannel(rawChannel, header.logVersion, header.logFormatVersion);
        ReadAheadLogChannel readableChannel = new ReadAheadLogChannel(channel, LogVersionBridge.NO_MORE_CHANNELS);
        LogEntrySortingCursor cursor = new LogEntrySortingCursor(reader, readableChannel);
        return Pair.of((Object)new LogHeader(6, header.logVersion, lastCommittedTxId), (Object)cursor);
    }
}

