/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.input.csv;

import java.util.Iterator;
import java.util.function.Function;
import org.neo4j.csv.reader.CharSeeker;
import org.neo4j.helpers.collection.NestingIterator;
import org.neo4j.unsafe.impl.batchimport.InputIterator;
import org.neo4j.unsafe.impl.batchimport.input.InputEntity;
import org.neo4j.unsafe.impl.batchimport.input.csv.Configuration;
import org.neo4j.unsafe.impl.batchimport.input.csv.Data;
import org.neo4j.unsafe.impl.batchimport.input.csv.DataFactory;
import org.neo4j.unsafe.impl.batchimport.input.csv.Header;
import org.neo4j.unsafe.impl.batchimport.input.csv.IdType;
import org.neo4j.unsafe.impl.batchimport.input.csv.InputEntityDeserializer;

abstract class InputGroupsDeserializer<ENTITY extends InputEntity>
extends NestingIterator<ENTITY, DataFactory<ENTITY>>
implements InputIterator<ENTITY> {
    private final Header.Factory headerFactory;
    private final Configuration config;
    private final IdType idType;
    private InputIterator<ENTITY> currentInput = new InputIterator.Empty<ENTITY>();
    private long previousInputsCollectivePositions;
    private boolean currentInputOpen;

    InputGroupsDeserializer(Iterator<DataFactory<ENTITY>> dataFactory, Header.Factory headerFactory, Configuration config, IdType idType) {
        super(dataFactory);
        this.headerFactory = headerFactory;
        this.config = config;
        this.idType = idType;
    }

    protected InputIterator<ENTITY> createNestedIterator(DataFactory<ENTITY> dataFactory) {
        this.closeCurrent();
        Data<ENTITY> data = dataFactory.create(this.config);
        CharSeeker dataStream = data.stream();
        Header dataHeader = this.headerFactory.create(dataStream, this.config, this.idType);
        InputEntityDeserializer<ENTITY> input = this.entityDeserializer(dataStream, dataHeader, data.decorator());
        this.currentInput = input;
        this.currentInputOpen = true;
        input.initialize();
        return this.currentInput;
    }

    private void closeCurrent() {
        if (this.currentInputOpen) {
            this.previousInputsCollectivePositions += this.currentInput.position();
            this.currentInput.close();
            this.currentInputOpen = false;
        }
    }

    protected abstract InputEntityDeserializer<ENTITY> entityDeserializer(CharSeeker var1, Header var2, Function<ENTITY, ENTITY> var3);

    public void close() {
        this.closeCurrent();
    }

    public long position() {
        return this.previousInputsCollectivePositions + this.currentInput.position();
    }

    public String sourceDescription() {
        return this.currentInput.sourceDescription();
    }

    public long lineNumber() {
        return this.currentInput.lineNumber();
    }
}

