/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.configuration.docs;

import java.util.List;
import org.neo4j.kernel.configuration.docs.SettingDescription;
import org.neo4j.kernel.configuration.docs.SettingsDocumenter;

public class AsciiDocListGenerator {
    private String listId;
    private String title;
    private boolean shortenDescription;

    public AsciiDocListGenerator(String listId, String title, boolean shortenDescription) {
        this.listId = listId;
        this.title = title;
        this.shortenDescription = shortenDescription;
    }

    public String generateListAndTableCombo(List<SettingDescription> items) {
        StringBuilder sb = new StringBuilder(200 * items.size());
        StringBuilder print = new StringBuilder(100 * items.size());
        if (this.listId != null) {
            sb.append("[[").append(this.listId).append(String.format("]]%n", new Object[0]));
        }
        if (this.title != null) {
            sb.append('.').append(this.title).append(System.lineSeparator());
        }
        sb.append(SettingsDocumenter.IFDEF_HTMLOUTPUT).append(System.lineSeparator()).append(String.format("[options=\"header\"]%n", new Object[0])).append(String.format("|===%n", new Object[0])).append(String.format("|Name|Description%n", new Object[0]));
        print.append(SettingsDocumenter.IFDEF_NONHTMLOUTPUT).append(System.lineSeparator());
        for (SettingDescription item : items) {
            String id = item.id();
            String name = item.name();
            String description = item.description();
            if (this.shortenDescription) {
                int pos = description.indexOf(". ");
                if (pos == -1) {
                    pos = description.indexOf("; ");
                }
                if (pos > 10) {
                    description = description.substring(0, pos);
                }
            }
            sb.append("|<<").append(id).append(',').append(name).append(">>|").append(description);
            print.append("* <<").append(id).append(',').append(name).append(">>: ").append(description);
            if (!description.endsWith(".")) {
                sb.append('.');
                print.append('.');
            }
            sb.append(System.lineSeparator());
            print.append(System.lineSeparator());
        }
        sb.append(String.format("|===%n", new Object[0])).append(SettingsDocumenter.ENDIF);
        print.append(SettingsDocumenter.ENDIF).append(System.lineSeparator());
        sb.append(print.toString());
        return sb.toString();
    }
}

