/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import org.neo4j.kernel.impl.api.TransactionToApply;

public class TransactionQueue {
    private final int maxSize;
    private final Applier applier;
    private TransactionToApply first;
    private TransactionToApply last;
    private int size;

    public TransactionQueue(int maxSize, Applier applier) {
        this.maxSize = maxSize;
        this.applier = applier;
    }

    public void queue(TransactionToApply transacion) throws Exception {
        if (this.size == 0) {
            this.first = this.last = transacion;
        } else {
            this.last.next(transacion);
            this.last = transacion;
        }
        if (++this.size == this.maxSize) {
            this.empty();
        }
    }

    public void empty() throws Exception {
        if (this.size > 0) {
            this.applier.apply(this.first);
            this.last = null;
            this.first = null;
            this.size = 0;
        }
    }

    @FunctionalInterface
    public static interface Applier {
        public void apply(TransactionToApply var1) throws Exception;
    }
}

