/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.coreapi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.neo4j.collection.primitive.Primitive;
import org.neo4j.collection.primitive.PrimitiveLongObjectMap;
import org.neo4j.cursor.Cursor;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.event.LabelEntry;
import org.neo4j.graphdb.event.PropertyEntry;
import org.neo4j.graphdb.event.TransactionData;
import org.neo4j.helpers.collection.IterableWrapper;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.api.exceptions.LabelNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.PropertyKeyIdNotFoundKernelException;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.api.properties.Property;
import org.neo4j.kernel.impl.core.NodeProxy;
import org.neo4j.kernel.impl.core.RelationshipProxy;
import org.neo4j.storageengine.api.LabelItem;
import org.neo4j.storageengine.api.NodeItem;
import org.neo4j.storageengine.api.PropertyItem;
import org.neo4j.storageengine.api.RelationshipItem;
import org.neo4j.storageengine.api.StorageProperty;
import org.neo4j.storageengine.api.StorageStatement;
import org.neo4j.storageengine.api.StoreReadLayer;
import org.neo4j.storageengine.api.txstate.NodeState;
import org.neo4j.storageengine.api.txstate.ReadableTransactionState;
import org.neo4j.storageengine.api.txstate.RelationshipState;

public class TxStateTransactionDataSnapshot
implements TransactionData {
    private final ReadableTransactionState state;
    private final NodeProxy.NodeActions nodeActions;
    private final StorageStatement storeStatement;
    private final RelationshipProxy.RelationshipActions relationshipActions;
    private final StoreReadLayer store;
    private final Collection<PropertyEntry<Node>> assignedNodeProperties = new ArrayList<PropertyEntry<Node>>();
    private final Collection<PropertyEntry<Relationship>> assignedRelationshipProperties = new ArrayList<PropertyEntry<Relationship>>();
    private final Collection<LabelEntry> assignedLabels = new ArrayList<LabelEntry>();
    private final Collection<PropertyEntry<Node>> removedNodeProperties = new ArrayList<PropertyEntry<Node>>();
    private final Collection<PropertyEntry<Relationship>> removedRelationshipProperties = new ArrayList<PropertyEntry<Relationship>>();
    private final Collection<LabelEntry> removedLabels = new ArrayList<LabelEntry>();
    private final PrimitiveLongObjectMap<RelationshipProxy> relationshipsReadFromStore = Primitive.longObjectMap((int)16);

    public TxStateTransactionDataSnapshot(ReadableTransactionState state, NodeProxy.NodeActions nodeActions, RelationshipProxy.RelationshipActions relationshipActions, StoreReadLayer storeReadLayer, StorageStatement storageStatement) {
        this.state = state;
        this.nodeActions = nodeActions;
        this.relationshipActions = relationshipActions;
        this.storeStatement = storageStatement;
        this.store = storeReadLayer;
        this.takeSnapshot();
    }

    public Iterable<Node> createdNodes() {
        return this.map2Nodes(this.state.addedAndRemovedNodes().getAdded());
    }

    public Iterable<Node> deletedNodes() {
        return this.map2Nodes(this.state.addedAndRemovedNodes().getRemoved());
    }

    public Iterable<Relationship> createdRelationships() {
        return this.map2Rels(this.state.addedAndRemovedRelationships().getAdded());
    }

    public Iterable<Relationship> deletedRelationships() {
        return this.map2Rels(this.state.addedAndRemovedRelationships().getRemoved());
    }

    public boolean isDeleted(Node node) {
        return this.state.nodeIsDeletedInThisTx(node.getId());
    }

    public boolean isDeleted(Relationship relationship) {
        return this.state.relationshipIsDeletedInThisTx(relationship.getId());
    }

    public Iterable<PropertyEntry<Node>> assignedNodeProperties() {
        return this.assignedNodeProperties;
    }

    public Iterable<PropertyEntry<Node>> removedNodeProperties() {
        return this.removedNodeProperties;
    }

    public Iterable<PropertyEntry<Relationship>> assignedRelationshipProperties() {
        return this.assignedRelationshipProperties;
    }

    public Iterable<PropertyEntry<Relationship>> removedRelationshipProperties() {
        return this.removedRelationshipProperties;
    }

    public Iterable<LabelEntry> removedLabels() {
        return this.removedLabels;
    }

    public Iterable<LabelEntry> assignedLabels() {
        return this.assignedLabels;
    }

    private void takeSnapshot() {
        try {
            Object property;
            Object labels2;
            for (Long nodeId : this.state.addedAndRemovedNodes().getRemoved()) {
                Cursor<NodeItem> node = this.storeStatement.acquireSingleNodeCursor(nodeId);
                Throwable throwable = null;
                try {
                    if (!node.next()) continue;
                    try (Cursor<PropertyItem> properties = ((NodeItem)node.get()).properties();){
                        while (properties.next()) {
                            this.removedNodeProperties.add(new NodePropertyEntryView(nodeId, this.store.propertyKeyGetName(((PropertyItem)properties.get()).propertyKeyId()), null, ((PropertyItem)properties.get()).value()));
                        }
                    }
                    labels2 = ((NodeItem)node.get()).labels();
                    var6_9 = null;
                    try {
                        while (labels2.next()) {
                            this.removedLabels.add(new LabelEntryView(nodeId, this.store.labelGetName(((LabelItem)labels2.get()).getAsInt())));
                        }
                    }
                    catch (Throwable throwable2) {
                        var6_9 = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (labels2 == null) continue;
                        if (var6_9 != null) {
                            try {
                                labels2.close();
                            }
                            catch (Throwable throwable3) {
                                var6_9.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        labels2.close();
                    }
                }
                catch (Throwable labels2) {
                    throwable = labels2;
                    throw labels2;
                }
                finally {
                    if (node == null) continue;
                    if (throwable != null) {
                        try {
                            node.close();
                        }
                        catch (Throwable labels2) {
                            throwable.addSuppressed(labels2);
                        }
                        continue;
                    }
                    node.close();
                }
            }
            for (Long relId : this.state.addedAndRemovedRelationships().getRemoved()) {
                Relationship relationshipProxy = this.relationship(relId);
                Cursor<RelationshipItem> relationship = this.storeStatement.acquireSingleRelationshipCursor(relId);
                labels2 = null;
                try {
                    if (!relationship.next()) continue;
                    Cursor<PropertyItem> properties = ((RelationshipItem)relationship.get()).properties();
                    Throwable throwable = null;
                    try {
                        while (properties.next()) {
                            this.removedRelationshipProperties.add(new RelationshipPropertyEntryView(relationshipProxy, this.store.propertyKeyGetName(((PropertyItem)properties.get()).propertyKeyId()), null, ((PropertyItem)properties.get()).value()));
                        }
                    }
                    catch (Throwable throwable4) {
                        throwable = throwable4;
                        throw throwable4;
                    }
                    finally {
                        if (properties == null) continue;
                        if (throwable != null) {
                            try {
                                properties.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                            continue;
                        }
                        properties.close();
                    }
                }
                catch (Throwable properties) {
                    labels2 = properties;
                    throw properties;
                }
                finally {
                    if (relationship == null) continue;
                    if (labels2 != null) {
                        try {
                            relationship.close();
                        }
                        catch (Throwable properties) {
                            ((Throwable)labels2).addSuppressed(properties);
                        }
                        continue;
                    }
                    relationship.close();
                }
            }
            for (NodeState nodeState : this.state.modifiedNodes()) {
                Iterator<StorageProperty> added = nodeState.addedAndChangedProperties();
                while (added.hasNext()) {
                    DefinedProperty property2 = (DefinedProperty)added.next();
                    this.assignedNodeProperties.add(new NodePropertyEntryView(nodeState.getId(), this.store.propertyKeyGetName(property2.propertyKeyId()), property2.value(), this.committedValue(nodeState, property2.propertyKeyId())));
                }
                Iterator<Integer> removed = nodeState.removedProperties();
                while (removed.hasNext()) {
                    property = removed.next();
                    this.removedNodeProperties.add(new NodePropertyEntryView(nodeState.getId(), this.store.propertyKeyGetName((Integer)property), null, this.committedValue(nodeState, (Integer)property)));
                }
                labels2 = nodeState.labelDiffSets();
                for (Integer label : labels2.getAdded()) {
                    this.assignedLabels.add(new LabelEntryView(nodeState.getId(), this.store.labelGetName(label)));
                }
                for (Integer label : labels2.getRemoved()) {
                    this.removedLabels.add(new LabelEntryView(nodeState.getId(), this.store.labelGetName(label)));
                }
            }
            for (RelationshipState relState : this.state.modifiedRelationships()) {
                Relationship relationship = this.relationship(relState.getId());
                Iterator<StorageProperty> added = relState.addedAndChangedProperties();
                while (added.hasNext()) {
                    property = (DefinedProperty)added.next();
                    this.assignedRelationshipProperties.add(new RelationshipPropertyEntryView(relationship, this.store.propertyKeyGetName(((Property)property).propertyKeyId()), ((DefinedProperty)property).value(), this.committedValue(this.store, relState, ((Property)property).propertyKeyId())));
                }
                Iterator<Integer> removed = relState.removedProperties();
                while (removed.hasNext()) {
                    Integer property3 = removed.next();
                    this.removedRelationshipProperties.add(new RelationshipPropertyEntryView(relationship, this.store.propertyKeyGetName(property3), null, this.committedValue(this.store, relState, property3)));
                }
            }
        }
        catch (LabelNotFoundKernelException | PropertyKeyIdNotFoundKernelException e) {
            throw new IllegalStateException("An entity that does not exist was modified.", e);
        }
    }

    private Relationship relationship(long relId) {
        RelationshipProxy relationship = new RelationshipProxy(this.relationshipActions, relId);
        if (!this.state.relationshipVisit(relId, relationship)) {
            RelationshipProxy cached = (RelationshipProxy)this.relationshipsReadFromStore.get(relId);
            if (cached != null) {
                return relationship;
            }
            try {
                this.store.relationshipVisit(relId, relationship);
                this.relationshipsReadFromStore.put(relId, (Object)relationship);
            }
            catch (EntityNotFoundException e) {
                throw new IllegalStateException("Getting deleted relationship data should have been covered by the tx state");
            }
        }
        return relationship;
    }

    private Iterable<Node> map2Nodes(Iterable<Long> added) {
        return new IterableWrapper<Node, Long>(added){

            protected Node underlyingObjectToObject(Long id) {
                return new NodeProxy(TxStateTransactionDataSnapshot.this.nodeActions, id);
            }
        };
    }

    private Iterable<Relationship> map2Rels(Iterable<Long> ids) {
        return new IterableWrapper<Relationship, Long>(ids){

            protected Relationship underlyingObjectToObject(Long id) {
                return TxStateTransactionDataSnapshot.this.relationship(id);
            }
        };
    }

    private Object committedValue(NodeState nodeState, int property) {
        if (this.state.nodeIsAddedInThisTx(nodeState.getId())) {
            return null;
        }
        try (Cursor<NodeItem> node = this.storeStatement.acquireSingleNodeCursor(nodeState.getId());){
            if (!node.next()) {
                Object var5_5 = null;
                return var5_5;
            }
            try (Cursor<PropertyItem> properties = ((NodeItem)node.get()).property(property);){
                if (properties.next()) {
                    Object object = ((PropertyItem)properties.get()).value();
                    return object;
                }
            }
        }
        return null;
    }

    private Object committedValue(StoreReadLayer storeReadLayer, RelationshipState relState, int property) {
        if (this.state.relationshipIsAddedInThisTx(relState.getId())) {
            return null;
        }
        try (Cursor<RelationshipItem> relationship = this.storeStatement.acquireSingleRelationshipCursor(relState.getId());){
            if (!relationship.next()) {
                Object var6_6 = null;
                return var6_6;
            }
            try (Cursor<PropertyItem> properties = ((RelationshipItem)relationship.get()).property(property);){
                if (properties.next()) {
                    Object object = ((PropertyItem)properties.get()).value();
                    return object;
                }
            }
        }
        return null;
    }

    private class LabelEntryView
    implements LabelEntry {
        private final long nodeId;
        private final Label label;

        public LabelEntryView(long nodeId, String labelName) {
            this.nodeId = nodeId;
            this.label = Label.label((String)labelName);
        }

        public Label label() {
            return this.label;
        }

        public Node node() {
            return new NodeProxy(TxStateTransactionDataSnapshot.this.nodeActions, this.nodeId);
        }

        public String toString() {
            return "LabelEntryView{nodeId=" + this.nodeId + ", label=" + this.label + '}';
        }
    }

    private class RelationshipPropertyEntryView
    implements PropertyEntry<Relationship> {
        private final Relationship relationship;
        private final String key;
        private final Object newValue;
        private final Object oldValue;

        public RelationshipPropertyEntryView(Relationship relationship, String key, Object newValue, Object oldValue) {
            this.relationship = relationship;
            this.key = key;
            this.newValue = newValue;
            this.oldValue = oldValue;
        }

        public Relationship entity() {
            return this.relationship;
        }

        public String key() {
            return this.key;
        }

        public Object previouslyCommitedValue() {
            return this.oldValue;
        }

        public Object value() {
            if (this.newValue == null) {
                throw new IllegalStateException("This property has been removed, it has no value anymore.");
            }
            return this.newValue;
        }

        public String toString() {
            return "RelationshipPropertyEntryView{relId=" + this.relationship.getId() + ", key='" + this.key + '\'' + ", newValue=" + this.newValue + ", oldValue=" + this.oldValue + '}';
        }
    }

    private class NodePropertyEntryView
    implements PropertyEntry<Node> {
        private final long nodeId;
        private final String key;
        private final Object newValue;
        private final Object oldValue;

        public NodePropertyEntryView(long nodeId, String key, Object newValue, Object oldValue) {
            this.nodeId = nodeId;
            this.key = key;
            this.newValue = newValue;
            this.oldValue = oldValue;
        }

        public Node entity() {
            return new NodeProxy(TxStateTransactionDataSnapshot.this.nodeActions, this.nodeId);
        }

        public String key() {
            return this.key;
        }

        public Object previouslyCommitedValue() {
            return this.oldValue;
        }

        public Object value() {
            if (this.newValue == null) {
                throw new IllegalStateException("This property has been removed, it has no value anymore.");
            }
            return this.newValue;
        }

        public String toString() {
            return "NodePropertyEntryView{nodeId=" + this.nodeId + ", key='" + this.key + '\'' + ", newValue=" + this.newValue + ", oldValue=" + this.oldValue + '}';
        }
    }
}

